/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.ImageUtils;
import com.thevoxelbox.voxelmap.util.ReflectionUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class VoxelColorManager {
    private VoxelMap minimap;
    private List packs = null;
    private BufferedImage terrainBuff = null;
    public BufferedImage colorPicker;
    public int mapImageInt = -1;
    public int[] blockColors = new int[86016];
    private static int COLOR_NOT_LOADED = -65281;
    public static int COLOR_FAILED_LOAD = -65025;
    private Integer[] vegetationIDS = new Integer[]{6, 30, 31, 32, 37, 38, 39, 40, 51, 59, 83, 104, 105, 115, 141, 142};
    private Integer[] shapedIDS = new Integer[]{63, 68, 64, 65, 71, 77, 85, 106, 107, 113, 139, 143};
    public Set<Integer> biomeTintsAvailable = new HashSet<Integer>();
    public Set<Integer> biomeTintEraseList = new HashSet<Integer>();
    protected boolean optifuck = false;
    public HashMap<Integer, Integer[]> blockTintTables = new HashMap();
    public Set<Integer> biomeTextureAvailable = new HashSet<Integer>();
    public HashMap<String, Integer> blockBiomeSpecificColors = new HashMap();
    protected boolean hdInstalled = false;
    private String renderPassThreeBlendMode;
    protected Object tpLoadLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoxelColorManager(VoxelMap minimap) {
        this.minimap = minimap;
        for (int i = 0; i < this.blockColors.length; ++i) {
            this.blockColors[i] = 0xFF00FF;
        }
        this.optifuck = false;
        Field ofProfiler = null;
        try {
            ofProfiler = azw.class.getDeclaredField("ofProfiler");
        }
        catch (SecurityException ex) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        finally {
            if (ofProfiler != null) {
                this.optifuck = true;
            }
        }
        this.hdInstalled = ReflectionUtils.classExists("com.prupe.mcpatcher.ctm.CTMUtils");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForChanges() {
        if (this.packs == null || !this.packs.equals(this.minimap.game.u.l)) {
            Object object = this.tpLoadLock;
            synchronized (object) {
                this.packs = new ArrayList(this.minimap.game.u.l);
                this.biomeTintEraseList.clear();
                this.biomeTintsAvailable.clear();
                this.biomeTextureAvailable.clear();
                this.blockBiomeSpecificColors.clear();
                this.loadColorPicker();
                this.loadMapImage();
                try {
                    try {
                        this.loadTexturePackColors();
                    }
                    catch (Exception e) {
                        System.out.println("error loading colors " + e.getLocalizedMessage());
                    }
                    if (this.hdInstalled || this.optifuck) {
                        try {
                            this.processCTM();
                        }
                        catch (Exception e) {
                            System.out.println("error loading CTM " + e.getLocalizedMessage());
                            e.printStackTrace();
                        }
                        this.blockTintTables.clear();
                        try {
                            this.processColorProperties();
                            if (this.optifuck) {
                                this.processColorProperty("palette.block.~/colormap/water.png", "8 9");
                                this.processColorProperty("palette.block.~/colormap/swampgrass.png", "2");
                                this.processColorProperty("palette.block.~/colormap/swampfoliage.png", "18 106 31:1 31:2");
                                this.processColorProperty("palette.block.~/colormap/pine.png", "18:1");
                                this.processColorProperty("palette.block.~/colormap/birch.png", "18:2");
                            }
                        }
                        catch (Exception e) {
                            System.out.println("error loading custom color properties " + e.getLocalizedMessage());
                        }
                    }
                    try {
                        this.loadBiomeColors(this.minimap.biomes);
                    }
                    catch (Exception e) {
                        System.out.println("error setting default biome shading " + e.getLocalizedMessage());
                    }
                    this.minimap.doFullRender = true;
                    if (this.minimap.radar != null) {
                        this.minimap.radar.loadTexturePackIcons();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    public final BufferedImage getBlockImage(int blockID, int metadata) {
        try {
            ps icon = ((ahu)ahu.c.a(blockID)).a(3, metadata);
            BufferedImage imageBuff = this.terrainBuff;
            int left = (int)(icon.c() * (float)imageBuff.getWidth());
            int right = (int)(icon.d() * (float)imageBuff.getWidth());
            int top = (int)(icon.e() * (float)imageBuff.getHeight());
            int bottom = (int)(icon.f() * (float)imageBuff.getHeight());
            BufferedImage blockImage = imageBuff.getSubimage(left, top, right - left, bottom - top);
            return blockImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadColorPicker() {
        try {
            InputStream is = this.minimap.game.O().a(new bqo("voxelmap", "images/colorPicker.png")).b();
            BufferedImage picker = ImageIO.read(is);
            is.close();
            this.colorPicker = new BufferedImage(((Image)picker).getWidth(null), ((Image)picker).getHeight(null), 2);
            Graphics2D gfx = this.colorPicker.createGraphics();
            gfx.drawImage((Image)picker, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void loadMapImage() {
        if (this.mapImageInt != -1) {
            GLUtils.glah(this.mapImageInt);
        }
        try {
            InputStream is = this.minimap.game.O().a(new bqo("voxelmap", "images/squaremap.png")).b();
            BufferedImage tpMap = ImageIO.read(is);
            BufferedImage mapImage = new BufferedImage(((Image)tpMap).getWidth(null), ((Image)tpMap).getHeight(null), 2);
            Graphics2D gfx = mapImage.createGraphics();
            gfx.drawImage((Image)tpMap, 0, 0, null);
            this.mapImageInt = GLUtils.tex(mapImage);
        }
        catch (Exception e) {
            try {
                InputStream is = this.minimap.game.O().a(new bqo("textures/map/map_background.png")).b();
                BufferedImage tpMap = ImageIO.read(is);
                is.close();
                BufferedImage mapImage = new BufferedImage(((Image)tpMap).getWidth(null), ((Image)tpMap).getHeight(null), 2);
                Graphics2D gfx = mapImage.createGraphics();
                if (!GLUtils.fboEnabled) {
                    gfx.setColor(Color.DARK_GRAY);
                    gfx.fillRect(0, 0, mapImage.getWidth(), mapImage.getHeight());
                }
                gfx.drawImage((Image)tpMap, 0, 0, null);
                int border = mapImage.getWidth() * 8 / 128;
                gfx.setComposite(AlphaComposite.Clear);
                gfx.fillRect(border, border, mapImage.getWidth() - border * 2, mapImage.getHeight() - border * 2);
                gfx.dispose();
                this.mapImageInt = GLUtils.tex(mapImage);
            }
            catch (Exception f) {
                System.out.println(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkyColor(int skyColor) {
        Object object = this.tpLoadLock;
        synchronized (object) {
            for (int t = 0; t < 16; ++t) {
                this.blockColors[this.blockColorID((int)0, (int)t)] = skyColor;
            }
        }
    }

    private void loadTexturePackColors() {
        try {
            for (int i = 0; i < this.blockColors.length; ++i) {
                this.blockColors[i] = COLOR_NOT_LOADED;
            }
            bpx textureManager = this.minimap.game.N();
            textureManager.a(textureManager.a(0));
            BufferedImage terrainStitched = ImageUtils.createBufferedImageFromCurrentGLImage();
            this.terrainBuff = new BufferedImage(terrainStitched.getWidth(null), terrainStitched.getHeight(null), 6);
            Graphics2D gfx = this.terrainBuff.createGraphics();
            gfx.drawImage((Image)terrainStitched, 0, 0, null);
            gfx.dispose();
            this.blockColors[this.blockColorID((int)111, (int)0)] = this.colorMultiplier(this.getColor(2, 0), 2129968);
            this.blockColors[this.blockColorID((int)31, (int)0)] = this.colorMultiplier(this.getColor(31, 0), -1);
            for (int t = 0; t < 16; ++t) {
                this.blockColors[this.blockColorID((int)30, (int)t)] = this.getColor(30, t, false);
            }
            VoxelMapProtectedFieldsHelper.setLightOpacity(ahu.b((String)"flowing_lava"), 1);
            VoxelMapProtectedFieldsHelper.setLightOpacity(ahu.b((String)"lava"), 1);
        }
        catch (Exception e) {
            System.out.println("ERRRORRR " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void loadBiomeColors(boolean biomes) {
        for (int s : this.biomeTintEraseList) {
            this.blockColors[s] = COLOR_NOT_LOADED;
        }
        if (biomes) {
            this.blockColors[this.blockColorID((int)2, (int)0)] = this.getColor(2, 0);
            this.blockColors[this.blockColorID((int)18, (int)0)] = this.getColor(18, 0);
            this.blockColors[this.blockColorID((int)18, (int)1)] = this.getColor(18, 1);
            this.blockColors[this.blockColorID((int)18, (int)2)] = this.getColor(18, 2);
            this.blockColors[this.blockColorID((int)18, (int)3)] = this.getColor(18, 3);
            this.blockColors[this.blockColorID((int)18, (int)4)] = this.getColor(18, 4);
            this.blockColors[this.blockColorID((int)18, (int)5)] = this.getColor(18, 5);
            this.blockColors[this.blockColorID((int)18, (int)6)] = this.getColor(18, 6);
            this.blockColors[this.blockColorID((int)18, (int)7)] = this.getColor(18, 7);
            this.blockColors[this.blockColorID((int)18, (int)8)] = this.getColor(18, 8);
            this.blockColors[this.blockColorID((int)18, (int)9)] = this.getColor(18, 9);
            this.blockColors[this.blockColorID((int)18, (int)10)] = this.getColor(18, 10);
            this.blockColors[this.blockColorID((int)18, (int)11)] = this.getColor(18, 11);
            this.blockColors[this.blockColorID((int)31, (int)1)] = this.getColor(31, 1);
            this.blockColors[this.blockColorID((int)31, (int)2)] = this.getColor(31, 2);
            this.blockColors[this.blockColorID((int)106, (int)1)] = this.getColor(106, 0);
            this.blockColors[this.blockColorID((int)106, (int)2)] = this.getColor(106, 1);
            this.blockColors[this.blockColorID((int)106, (int)4)] = this.getColor(106, 2);
            this.blockColors[this.blockColorID((int)106, (int)8)] = this.getColor(106, 3);
            this.blockColors[this.blockColorID((int)106, (int)9)] = this.getColor(106, 3);
        } else {
            this.blockColors[this.blockColorID((int)2, (int)0)] = this.colorMultiplier(this.getColor(2, 0), afm.a((double)0.7, (double)0.8)) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)0)] = this.colorMultiplier(this.getColor(18, 0), afj.a((double)0.7, (double)0.8)) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)1)] = this.colorMultiplier(this.getColor(18, 1), afj.a()) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)2)] = this.colorMultiplier(this.getColor(18, 2), afj.b()) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)3)] = this.colorMultiplier(this.getColor(18, 3), afj.a((double)0.7, (double)0.8)) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)4)] = this.colorMultiplier(this.getColor(18, 4), afj.a((double)0.7, (double)0.8)) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)5)] = this.colorMultiplier(this.getColor(18, 5), afj.a()) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)6)] = this.colorMultiplier(this.getColor(18, 6), afj.b()) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)7)] = this.colorMultiplier(this.getColor(18, 7), afj.a((double)0.7, (double)0.8)) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)8)] = this.colorMultiplier(this.getColor(18, 8), afj.a((double)0.7, (double)0.8)) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)9)] = this.colorMultiplier(this.getColor(18, 9), afj.a()) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)10)] = this.colorMultiplier(this.getColor(18, 10), afj.b()) | 0xFF000000;
            this.blockColors[this.blockColorID((int)18, (int)11)] = this.colorMultiplier(this.getColor(18, 11), afj.a((double)0.7, (double)0.8)) | 0xFF000000;
            this.blockColors[this.blockColorID((int)31, (int)1)] = this.colorMultiplier(this.getColor(31, 1), afm.a((double)0.7, (double)0.8) | 0xFF000000);
            this.blockColors[this.blockColorID((int)31, (int)2)] = this.colorMultiplier(this.getColor(31, 2), afm.a((double)0.7, (double)0.8) | 0xFF000000);
            this.blockColors[this.blockColorID((int)106, (int)1)] = this.colorMultiplier(this.getColor(106, 0), afj.a((double)0.7, (double)0.8) | 0xFF000000);
            this.blockColors[this.blockColorID((int)106, (int)2)] = this.colorMultiplier(this.getColor(106, 1), afj.a((double)0.7, (double)0.8) | 0xFF000000);
            this.blockColors[this.blockColorID((int)106, (int)4)] = this.colorMultiplier(this.getColor(106, 2), afj.a((double)0.7, (double)0.8) | 0xFF000000);
            this.blockColors[this.blockColorID((int)106, (int)8)] = this.colorMultiplier(this.getColor(106, 3), afj.a((double)0.7, (double)0.8) | 0xFF000000);
            this.blockColors[this.blockColorID((int)106, (int)9)] = this.colorMultiplier(this.getColor(106, 3), afj.a((double)0.7, (double)0.8) | 0xFF000000);
        }
        this.loadWaterColor(biomes);
    }

    private void loadWaterColor(boolean biomes) {
        int waterRGB = -1;
        waterRGB = this.getColor(9, 0);
        InputStream is = null;
        if (!biomes) {
            int waterMult = -1;
            BufferedImage waterColorBuff = null;
            try {
                is = this.minimap.game.O().a(new bqo("mcpatcher/colormap/water.png")).b();
            }
            catch (IOException e) {
                is = null;
            }
            if (is != null) {
                try {
                    BufferedImage waterColor = ImageIO.read(is);
                    is.close();
                    waterColorBuff = new BufferedImage(((Image)waterColor).getWidth(null), ((Image)waterColor).getHeight(null), 1);
                    Graphics2D gfx = waterColorBuff.createGraphics();
                    gfx.drawImage((Image)waterColor, 0, 0, null);
                    gfx.dispose();
                    agg genBase = agg.s;
                    double var1 = ou.a((float)genBase.a(0, 64, 0), (float)0.0f, (float)1.0f);
                    double var2 = ou.a((float)genBase.i(), (float)0.0f, (float)1.0f);
                    var2 *= var1;
                    var1 = 1.0 - var1;
                    var2 = 1.0 - var2;
                    waterMult = waterColorBuff.getRGB((int)((double)(waterColorBuff.getWidth() - 1) * var1), (int)((double)(waterColorBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            waterRGB = waterMult != -1 && waterMult != 0 ? this.colorMultiplier(waterRGB, waterMult | 0xFF000000) : this.colorMultiplier(waterRGB, agg.s.aq | 0xFF000000);
        }
        for (int t = 0; t < 16; ++t) {
            this.blockColors[this.blockColorID((int)8, (int)t)] = waterRGB;
            this.blockColors[this.blockColorID((int)9, (int)t)] = waterRGB;
        }
    }

    protected final int blockColorID(int blockid, int meta) {
        return blockid | meta << 12;
    }

    public final int getBlockColor(int blockID, int metadata, int biomeID) {
        int col;
        if ((this.hdInstalled || this.optifuck) && this.biomeTextureAvailable.contains(blockID)) {
            String biomeName = agg.n()[biomeID].af;
            if (biomeName == null) {
                biomeName = "";
            }
            biomeName = biomeName.toLowerCase().replace(" ", "");
            Integer col2 = this.blockBiomeSpecificColors.get("" + this.blockColorID(blockID, metadata) + biomeName);
            if (col2 != null) {
                return col2;
            }
        }
        if (this.blockColors[this.blockColorID(blockID, metadata)] == COLOR_NOT_LOADED) {
            this.blockColors[this.blockColorID((int)blockID, (int)metadata)] = this.getColor(blockID, metadata);
        }
        if ((col = this.blockColors[this.blockColorID(blockID, metadata)]) != COLOR_FAILED_LOAD) {
            return col;
        }
        if (this.blockColors[this.blockColorID(blockID, 0)] == COLOR_NOT_LOADED) {
            this.blockColors[this.blockColorID((int)blockID, (int)0)] = this.getColor(blockID, 0);
        }
        if ((col = this.blockColors[this.blockColorID(blockID, 0)]) != COLOR_FAILED_LOAD) {
            return col;
        }
        col = 0;
        if (col != COLOR_FAILED_LOAD) {
            return col;
        }
        return COLOR_FAILED_LOAD;
    }

    private int getColor(int blockID, int metadata, boolean retainTransparency) {
        int color = this.getColor(blockID, metadata);
        if (!retainTransparency) {
            color |= 0xFF000000;
        }
        return color;
    }

    private int getColor(int blockID, int metadata) {
        try {
            int tint;
            int side = 1;
            if (Arrays.asList(this.vegetationIDS).contains(blockID)) {
                side = 2;
            }
            ps icon = null;
            if (blockID == 64 || blockID == 71) {
                icon = ahu.e((int)blockID).e((afx)this.minimap.getWorld(), 10, 64, 10, 0);
            } else {
                if (blockID == 55) {
                    return 0x19000000 | (30 + metadata * 15 & 0xFF) << 16 | 0 | 0;
                }
                icon = ahu.e((int)blockID).a(side, metadata);
            }
            int color = this.iconToColor(icon, this.terrainBuff);
            if (blockID != 2 && blockID != 18 && blockID != 31 && blockID != 106 && blockID != 8 && blockID != 9 && (tint = ahu.e((int)blockID).d((afx)this.minimap.getWorld(), this.minimap.lastX, 78, this.minimap.lastZ) | 0xFF000000) != 0xFFFFFF && tint != -1) {
                this.biomeTintsAvailable.add(blockID);
                this.biomeTintEraseList.add(this.blockColorID(blockID, metadata));
                if (!this.minimap.biomes) {
                    color = this.colorMultiplier(color, tint);
                }
            }
            if (Arrays.asList(this.shapedIDS).contains(blockID)) {
                color = this.applyShape(blockID, metadata, color);
            }
            if ((color >> 24 & 0xFF) < 27) {
                color |= 0x1B000000;
            }
            return color;
        }
        catch (Exception e) {
            System.out.println("failed getting color: " + blockID + " " + metadata);
            return COLOR_FAILED_LOAD;
        }
    }

    private int iconToColor(ps icon, BufferedImage imageBuff) {
        int left = (int)(icon.c() * (float)imageBuff.getWidth());
        int right = (int)(icon.d() * (float)imageBuff.getWidth());
        int top = (int)(icon.e() * (float)imageBuff.getHeight());
        int bottom = (int)(icon.f() * (float)imageBuff.getHeight());
        BufferedImage blockTexture = imageBuff.getSubimage(left, top, right - left, bottom - top);
        Image singlePixel = blockTexture.getScaledInstance(1, 1, 4);
        BufferedImage singlePixelBuff = new BufferedImage(1, 1, imageBuff.getType());
        Graphics2D gfx = singlePixelBuff.createGraphics();
        gfx.drawImage(singlePixel, 0, 0, null);
        gfx.dispose();
        int color = singlePixelBuff.getRGB(0, 0);
        return color;
    }

    private int applyShape(int blockID, int metadata, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color >> 0 & 0xFF;
        switch (blockID) {
            case 63: {
                alpha = 31;
                break;
            }
            case 68: {
                alpha = 31;
                break;
            }
            case 64: {
                alpha = 47;
                break;
            }
            case 65: {
                alpha = 15;
                break;
            }
            case 71: {
                alpha = 47;
                break;
            }
            case 77: {
                alpha = 11;
                break;
            }
            case 85: {
                alpha = 95;
                break;
            }
            case 106: {
                alpha = 15;
                break;
            }
            case 107: {
                alpha = 92;
                break;
            }
            case 113: {
                alpha = 95;
                break;
            }
            case 139: {
                alpha = 153;
                break;
            }
            case 143: {
                alpha = 11;
            }
        }
        color = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return color;
    }

    public int colorMultiplier(int color1, int color2) {
        int alpha1 = color1 >> 24 & 0xFF;
        int red1 = color1 >> 16 & 0xFF;
        int green1 = color1 >> 8 & 0xFF;
        int blue1 = color1 >> 0 & 0xFF;
        int alpha2 = color2 >> 24 & 0xFF;
        int red2 = color2 >> 16 & 0xFF;
        int green2 = color2 >> 8 & 0xFF;
        int blue2 = color2 >> 0 & 0xFF;
        int alpha = alpha1 * alpha2 / 255;
        int red = red1 * red2 / 255;
        int green = green1 * green2 / 255;
        int blue = blue1 * blue2 / 255;
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public int colorAdder(int color1, int color2) {
        int topAlpha = color1 >> 24 & 0xFF;
        int red1 = (color1 >> 16 & 0xFF) * topAlpha / 255;
        int green1 = (color1 >> 8 & 0xFF) * topAlpha / 255;
        int blue1 = (color1 >> 0 & 0xFF) * topAlpha / 255;
        int red2 = (color2 >> 16 & 0xFF) * (255 - topAlpha) / 255;
        int green2 = (color2 >> 8 & 0xFF) * (255 - topAlpha) / 255;
        int blue2 = (color2 >> 0 & 0xFF) * (255 - topAlpha) / 255;
        int red = red1 + red2;
        int green = green1 + green2;
        int blue = blue1 + blue2;
        return 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    private void processCTM() {
        this.renderPassThreeBlendMode = "alpha";
        Properties properties = new Properties();
        bqo propertiesFile = new bqo("minecraft", "mcpatcher/renderpass.properties");
        try {
            InputStream input = this.minimap.game.O().a(propertiesFile).b();
            if (input != null) {
                properties.load(input);
                input.close();
                this.renderPassThreeBlendMode = properties.getProperty("blend.3");
            }
        }
        catch (IOException e) {
            this.renderPassThreeBlendMode = "alpha";
        }
        String namespace = "minecraft";
        for (bqo s : this.findResources(namespace, "/mcpatcher/ctm", ".properties", true, false, true)) {
            try {
                this.loadCTM(s);
            }
            catch (NumberFormatException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        for (int t = 0; t < this.blockColors.length; ++t) {
            if (this.blockColors[t] == COLOR_FAILED_LOAD) continue;
            if (this.blockColors[t] == COLOR_NOT_LOADED || (this.blockColors[t] >> 24 & 0xFF) >= 27) continue;
            this.blockColors[t] = this.blockColors[t] | 0x1B000000;
        }
    }

    private void loadCTM(bqo propertiesFile) {
        if (propertiesFile == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            InputStream input = this.minimap.game.O().a(propertiesFile).b();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException e) {
            return;
        }
        ble renderBlocks = new ble();
        String filePath = propertiesFile.a();
        String method = properties.getProperty("method", "").trim().toLowerCase();
        String faces = properties.getProperty("faces", "").trim().toLowerCase();
        String matchBlocks = properties.getProperty("matchBlocks", "").trim().toLowerCase();
        String matchTiles = properties.getProperty("matchTiles", "").trim().toLowerCase();
        String metadata = properties.getProperty("metadata", "").trim().toLowerCase();
        String tiles = properties.getProperty("tiles", "").trim().toLowerCase();
        String biomes = properties.getProperty("biomes", "").trim().toLowerCase();
        String renderPass = properties.getProperty("renderPass", "").trim().toLowerCase();
        int[] blockInts = this.parseIntegerList(matchBlocks, 0, 4095);
        int[] metadataInts = this.parseIntegerList(metadata, 0, 255);
        int[] tilesInts = this.parseIntegerList(tiles, 0, 255);
        int tilesInt = 0;
        if (tilesInts.length > 0) {
            tilesInt = tilesInts[0];
        }
        String[] biomesArray = biomes.split(" ");
        if (blockInts.length == 0) {
            int blockID = -1;
            Pattern pattern = Pattern.compile(".*/block([\\d]+)[a-zA-Z]*.properties");
            Matcher matcher = pattern.matcher(filePath);
            if (matcher.find()) {
                blockID = Integer.parseInt(matcher.group(1));
            } else {
                String tileNameToMatch = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf(".properties"));
                for (int t = 0; t < 4096; ++t) {
                    ahu block = (ahu)ahu.c.a(t);
                    if (block == null) continue;
                    String tileNameOfBlock = "";
                    if (metadataInts.length > 0) {
                        for (int s = 0; s < metadataInts.length; ++s) {
                            try {
                                tileNameOfBlock = renderBlocks.a(block, 1, metadataInts[s]).g();
                            }
                            catch (Exception e) {
                                tileNameOfBlock = "";
                            }
                            if (!tileNameOfBlock.equals(tileNameToMatch)) continue;
                            blockID = t;
                        }
                        continue;
                    }
                    ArrayList<Integer> tmpList = new ArrayList<Integer>();
                    for (int s = 0; s < 16; ++s) {
                        try {
                            tileNameOfBlock = renderBlocks.a(block, 1, s).g();
                        }
                        catch (Exception e) {
                            tileNameOfBlock = "";
                        }
                        if (!tileNameOfBlock.equals(tileNameToMatch)) continue;
                        blockID = t;
                        tmpList.add(s);
                    }
                    metadataInts = new int[tmpList.size()];
                    for (int i = 0; i < metadataInts.length; ++i) {
                        metadataInts[i] = (Integer)tmpList.get(i);
                    }
                }
            }
            if (blockID != -1) {
                blockInts = new int[]{blockID};
            }
        }
        if (metadataInts.length == 0) {
            metadataInts = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        }
        if (blockInts.length == 0) {
            return;
        }
        if (!method.equals("horizontal") && (method.equals("sandstone") || method.equals("top") || faces.contains("top") || faces.contains("all") || faces.length() == 0)) {
            try {
                for (int t = 0; t < blockInts.length; ++t) {
                    String directory = filePath.substring(0, filePath.lastIndexOf("/") + 1);
                    bqo pngResource = new bqo(propertiesFile.b(), directory + tilesInt + ".png");
                    InputStream is = this.minimap.game.O().a(pngResource).b();
                    Image top = ImageIO.read(is);
                    is.close();
                    top = top.getScaledInstance(1, 1, 4);
                    BufferedImage topBuff = new BufferedImage(top.getWidth(null), top.getHeight(null), 6);
                    Graphics2D gfx = topBuff.createGraphics();
                    gfx.drawImage(top, 0, 0, null);
                    gfx.dispose();
                    int topRGB = topBuff.getRGB(0, 0);
                    if (blockInts[t] == 30) {
                        topRGB |= 0xFF000000;
                    }
                    if (renderPass.equals("3")) {
                        topRGB = this.processRenderPassThree(topRGB);
                        int baseRGB = this.blockColors[this.blockColorID(blockInts[t], metadataInts[0])];
                        if (baseRGB != COLOR_FAILED_LOAD) {
                            if (baseRGB != COLOR_NOT_LOADED) {
                                topRGB = this.colorMultiplier(baseRGB, topRGB);
                            }
                        }
                    }
                    if (Arrays.asList(this.shapedIDS).contains(blockInts[t])) {
                        topRGB = this.applyShape(blockInts[t], metadataInts[0], topRGB);
                    }
                    for (int s = 0; s < metadataInts.length; ++s) {
                        try {
                            if (!biomes.equals("")) {
                                this.biomeTextureAvailable.add(blockInts[t]);
                                for (int r = 0; r < biomesArray.length; ++r) {
                                    this.blockBiomeSpecificColors.put("" + this.blockColorID(blockInts[t], metadataInts[s]) + biomesArray[r], topRGB);
                                }
                                continue;
                            }
                            this.blockColors[this.blockColorID((int)blockInts[t], (int)metadataInts[s])] = topRGB;
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("blockID + metadata (" + blockInts[t] + ", " + metadataInts[s] + ") out of range");
                        }
                    }
                }
            }
            catch (IOException e) {
                System.out.println("error getting CTM block: " + e.getLocalizedMessage() + " " + blockInts[0] + " " + metadataInts[0] + " " + filePath.substring(0, filePath.lastIndexOf("/") + 1) + tilesInt + ".png");
            }
        }
    }

    private int processRenderPassThree(int rgb) {
        if (this.renderPassThreeBlendMode.equals("color") || this.renderPassThreeBlendMode.equals("overlay")) {
            int alpha = rgb >> 24 & 0xFF;
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb >> 0 & 0xFF;
            float colorAverage = (float)(red + blue + green) / 3.0f;
            float lighteningFactor = (colorAverage - 127.5f) * 2.0f;
            red += (int)((float)red * (lighteningFactor / 255.0f));
            int newAlpha = (int)Math.abs(lighteningFactor);
            rgb = newAlpha << 24 | (red & 0xFF) << 16 | ((green += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF) << 8 | (blue += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF;
        }
        return rgb;
    }

    private int[] parseIntegerList(String list, int minValue, int maxValue) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        for (String token : list.replace(',', ' ').split("\\s+")) {
            token = token.trim();
            try {
                String[] t;
                if (token.matches("^\\d+$")) {
                    tmpList.add(Integer.parseInt(token));
                    continue;
                }
                if (token.matches("^\\d+-\\d+$")) {
                    t = token.split("-");
                    int min = Integer.parseInt(t[0]);
                    int max = Integer.parseInt(t[1]);
                    for (int i = min; i <= max; ++i) {
                        tmpList.add(i);
                    }
                    continue;
                }
                if (!token.matches("^\\d+:\\d+$")) continue;
                t = token.split(":");
                int id = Integer.parseInt(t[0]);
                int metadata = Integer.parseInt(t[1]);
                tmpList.add(id);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (minValue <= maxValue) {
            int i = 0;
            while (i < tmpList.size()) {
                if ((Integer)tmpList.get(i) < minValue || (Integer)tmpList.get(i) > maxValue) {
                    tmpList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        int[] a = new int[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Integer)tmpList.get(i);
        }
        return a;
    }

    private List<bqr> getResourcePacks(String namespace) {
        ArrayList<bqr> list = new ArrayList<bqr>();
        bqp superResourceManager = this.minimap.game.O();
        if (superResourceManager instanceof bqx) {
            Map nameSpaceToResourceManager = null;
            Object nameSpaceToResourceManagerObj = ReflectionUtils.getPrivateFieldByType(superResourceManager, bqx.class, Map.class);
            if (nameSpaceToResourceManagerObj == null) {
                return list;
            }
            nameSpaceToResourceManager = (Map)nameSpaceToResourceManagerObj;
            for (Map.Entry entry : nameSpaceToResourceManager.entrySet()) {
                if (namespace != null && !namespace.equals(entry.getKey())) continue;
                bqh resourceManager = (bqh)entry.getValue();
                List resourcePacks = null;
                Object resourcePacksObj = ReflectionUtils.getPrivateFieldByType(resourceManager, bqh.class, List.class);
                if (resourcePacksObj == null) {
                    return list;
                }
                resourcePacks = (List)resourcePacksObj;
                list.addAll(resourcePacks);
            }
        }
        Collections.reverse(list);
        return list;
    }

    private List<bqo> findResources(String namespace, String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        if (directory == null) {
            directory = "";
        }
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        if (suffix == null) {
            suffix = "";
        }
        ArrayList<bqo> resources = new ArrayList<bqo>();
        for (bqr resourcePack : this.getResourcePacks(namespace)) {
            if (resourcePack instanceof bqg) continue;
            if (resourcePack instanceof bqi) {
                Object zipFileObj = ReflectionUtils.getPrivateFieldByType(resourcePack, bqi.class, ZipFile.class);
                if (zipFileObj == null) {
                    return resources;
                }
                ZipFile zipFile = (ZipFile)zipFileObj;
                if (zipFile == null) continue;
                this.findResourcesZip(zipFile, namespace, "assets/" + namespace, directory, suffix, recursive, directories, resources);
                continue;
            }
            if (!(resourcePack instanceof bqf)) continue;
            Object baseObj = ReflectionUtils.getPrivateFieldByType(resourcePack, bqf.class, File.class);
            if (baseObj == null) {
                return resources;
            }
            File base = (File)baseObj;
            if (base == null || !base.isDirectory() || !(base = new File(base, "assets/" + namespace)).isDirectory()) continue;
            VoxelColorManager.findResourcesDirectory(base, namespace, directory, suffix, recursive, directories, resources);
        }
        if (sortByFilename) {
            Collections.sort(resources, new Comparator<bqo>(){

                @Override
                public int compare(bqo o1, bqo o2) {
                    String f2;
                    String f1 = o1.a().replaceAll(".*/", "").replaceFirst("\\.properties", "");
                    int result = f1.compareTo(f2 = o2.a().replaceAll(".*/", "").replaceFirst("\\.properties", ""));
                    if (result != 0) {
                        return result;
                    }
                    return o1.a().compareTo(o2.a());
                }
            });
        } else {
            Collections.sort(resources, new Comparator<bqo>(){

                @Override
                public int compare(bqo o1, bqo o2) {
                    return o1.a().compareTo(o2.a());
                }
            });
        }
        return resources;
    }

    private void findResourcesZip(ZipFile zipFile, String namespace, String root, String directory, String suffix, boolean recursive, boolean directories, Collection<bqo> resources) {
        String base = root + "/" + directory;
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String name;
            if (zipEntry.isDirectory() != directories || !(name = zipEntry.getName().replaceFirst("^/", "")).startsWith(base) || !name.endsWith(suffix)) continue;
            if (directory.equals("")) {
                if (!recursive && name.contains("/")) continue;
                resources.add(new bqo(namespace, name));
                continue;
            }
            String subpath = name.substring(base.length());
            if (!subpath.equals("") && !subpath.startsWith("/") || !recursive && !subpath.equals("") && subpath.substring(1).contains("/")) continue;
            resources.add(new bqo(namespace, name.substring(root.length() + 1)));
        }
    }

    private static void findResourcesDirectory(File base, String namespace, String directory, String suffix, boolean recursive, boolean directories, Collection<bqo> resources) {
        File subdirectory = new File(base, directory);
        String[] list = subdirectory.list();
        if (list != null) {
            String pathComponent = directory.equals("") ? "" : directory + "/";
            for (String s : list) {
                File entry = new File(subdirectory, s);
                String resourceName = pathComponent + s;
                if (entry.isDirectory()) {
                    if (directories && s.endsWith(suffix)) {
                        resources.add(new bqo(namespace, resourceName));
                    }
                    if (!recursive) continue;
                    VoxelColorManager.findResourcesDirectory(base, namespace, pathComponent + s, suffix, recursive, directories, resources);
                    continue;
                }
                if (!s.endsWith(suffix) || directories) continue;
                resources.add(new bqo(namespace, resourceName));
            }
        }
    }

    private void processColorProperties() {
        int lilypadMultiplier = 2129968;
        Properties properties = new Properties();
        try {
            InputStream input = this.minimap.game.O().a(new bqo("mcpatcher/color.properties")).b();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException e) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("palette.block")) {
                this.processColorProperty(key, properties.getProperty(key));
                continue;
            }
            if (!key.equals("lilypad")) continue;
            lilypadMultiplier = Integer.parseInt(properties.getProperty(key), 16);
        }
        for (int t = 0; t < 16; ++t) {
            this.blockColors[this.blockColorID((int)111, (int)t)] = this.colorMultiplier(this.getColor(111, 0), lilypadMultiplier);
        }
    }

    private void processColorProperty(String prop, String list) {
        String filename = prop.substring("palette.block.".length());
        filename = filename.replace("~", "mcpatcher");
        Integer[] tints = new Integer[agg.n().length];
        if (this.optifuck) {
            try {
                InputStream is = this.minimap.game.O().a(new bqo(filename)).b();
                if (is != null) {
                    int t = 0;
                    while (agg.n()[t] != null) {
                        tints[t] = -1;
                        ++t;
                    }
                    BufferedImage tintColors = ImageIO.read(is);
                    is.close();
                    BufferedImage tintColorsBuff = new BufferedImage(((Image)tintColors).getWidth(null), ((Image)tintColors).getHeight(null), 1);
                    Graphics2D gfx = tintColorsBuff.createGraphics();
                    gfx.drawImage((Image)tintColors, 0, 0, null);
                    gfx.dispose();
                    t = 0;
                    boolean swampgrass = filename.endsWith("/swampgrass.png");
                    boolean swampfoliage = filename.endsWith("/swampfoliage.png");
                    while (agg.n()[t] != null) {
                        agg genBase = agg.n()[t];
                        double var1 = ou.a((float)genBase.a(0, 64, 0), (float)0.0f, (float)1.0f);
                        double var2 = ou.a((float)genBase.i(), (float)0.0f, (float)1.0f);
                        var2 *= var1;
                        var1 = 1.0 - var1;
                        var2 = 1.0 - var2;
                        int tintMult = tintColorsBuff.getRGB((int)((double)(tintColorsBuff.getWidth() - 1) * var1), (int)((double)(tintColorsBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
                        if (tintMult != 0 && (t == agg.u.ay || !swampgrass && !swampfoliage)) {
                            tints[t] = tintMult;
                        } else if (swampgrass) {
                            tints[t] = genBase.b(0, 64, 0);
                        } else if (swampfoliage) {
                            tints[t] = genBase.c(0, 64, 0);
                        }
                        ++t;
                    }
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        for (String token : list.split("\\s+")) {
            token = token.trim();
            int id = -1;
            int metadata = -1;
            try {
                if (token.matches("^\\d+$")) {
                    id = Integer.parseInt(token);
                    this.biomeTintsAvailable.add(id);
                    for (int t = 0; t < 16; ++t) {
                        if (!this.optifuck) continue;
                        this.blockTintTables.put(this.blockColorID(id, t), tints);
                    }
                    continue;
                }
                if (!token.matches("^\\d+:\\d+$")) continue;
                String[] t = token.split(":");
                id = Integer.parseInt(t[0]);
                metadata = Integer.parseInt(t[1]);
                this.biomeTintsAvailable.add(id);
                if (!this.optifuck) continue;
                this.blockTintTables.put(this.blockColorID(id, metadata), tints);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

