/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.util.EntityWaypointContainer;
import com.thevoxelbox.voxelmap.util.FilesystemUtils;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;

public class VoxelWaypointManager {
    VoxelMap minimap;
    public ArrayList<Waypoint> wayPts = new ArrayList();
    private ArrayList<Waypoint> old2dWayPts = new ArrayList();
    private ArrayList<Waypoint> updatedPts;
    private EntityWaypointContainer entityWaypointContainer = null;
    private File settingsFile;

    public VoxelWaypointManager(VoxelMap minimap) {
        this.minimap = minimap;
    }

    public void handleDeath() {
        TreeSet<Integer> toDel = new TreeSet<Integer>();
        for (Waypoint pt : this.wayPts) {
            if (pt.name.equals("Latest Death")) {
                pt.name = "Previous Death";
            }
            if (!pt.name.startsWith("Previous Death")) continue;
            if (this.minimap.deathpoints > 1) {
                int num = 0;
                try {
                    if (pt.name.length() > 15) {
                        num = Integer.valueOf(pt.name.substring(15));
                    }
                }
                catch (Exception e) {
                    num = 0;
                }
                pt.red -= (pt.red - 0.5f) / 8.0f;
                pt.green -= (pt.green - 0.5f) / 8.0f;
                pt.blue -= (pt.blue - 0.5f) / 8.0f;
                pt.name = "Previous Death " + (num + 1);
                continue;
            }
            toDel.add(this.wayPts.indexOf(pt));
        }
        if (this.minimap.deathpoints < 2 && toDel.size() > 0) {
            TreeSet toDelReverse = (TreeSet)toDel.descendingSet();
            for (Integer index : toDelReverse) {
                this.deleteWaypoint(index);
            }
        }
        if (this.minimap.deathpoints > 0) {
            TreeSet<Integer> dimensions = new TreeSet<Integer>();
            dimensions.add(this.minimap.game.h.aq);
            this.addWaypoint(new Waypoint("Latest Death", this.minimap.game.h.aq != -1 ? this.minimap.xCoord() : this.minimap.xCoord() * 8, this.minimap.game.h.aq != -1 ? this.minimap.zCoord() : this.minimap.zCoord() * 8, this.minimap.yCoord() - 1, true, 1.0f, 1.0f, 1.0f, "skull", this.minimap.getCurrentSubWorldName(), dimensions));
        }
    }

    public void newWorld() {
        for (Waypoint pt : this.wayPts) {
            if (pt.dimensions.size() == 0 || pt.dimensions.contains(this.minimap.game.h.aq)) {
                pt.inDimension = true;
                continue;
            }
            pt.inDimension = false;
        }
        this.injectWaypointEntity();
    }

    public void newSubWorldName(String name) {
        String currentSubWorld = this.scrubName(name);
        for (Waypoint pt : this.wayPts) {
            if (currentSubWorld == "" || pt.world == "" || currentSubWorld.equals(pt.world)) {
                pt.inWorld = true;
                continue;
            }
            pt.inWorld = false;
        }
    }

    public void saveWaypoints() {
        File mcDir;
        int portSepLoc;
        String worldNameSave = this.minimap.getCurrentWorldName();
        if (worldNameSave.endsWith(":25565") && (portSepLoc = worldNameSave.lastIndexOf(":")) != -1) {
            worldNameSave = worldNameSave.substring(0, portSepLoc);
        }
        worldNameSave = this.scrubFileName(worldNameSave);
        File homeDir = FilesystemUtils.getAppDir("minecraft").getAbsoluteFile();
        if (!homeDir.equals(mcDir = azd.A().w.getAbsoluteFile())) {
            String localDirName = "";
            if (this.minimap.game.E()) {
                localDirName = mcDir.getName();
                if ((localDirName.equalsIgnoreCase("minecraft") || localDirName.equalsIgnoreCase(".")) && mcDir.getParentFile() != null) {
                    localDirName = mcDir.getParentFile().getName();
                }
                localDirName = "~" + localDirName;
            }
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap"), worldNameSave + localDirName + ".points");
            this.saveWaypointsTo(this.settingsFile);
            homeDir = new File(azd.A().w, "/mods/VoxelMods/voxelMap/");
            if (!homeDir.exists()) {
                homeDir.mkdirs();
            }
            this.settingsFile = new File(azd.A().w, "/mods/VoxelMods/voxelMap/" + worldNameSave + ".points");
            this.saveWaypointsTo(this.settingsFile);
        } else {
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap"), worldNameSave + ".points");
            this.saveWaypointsTo(this.settingsFile);
        }
    }

    public void saveWaypointsTo(File settingsFile) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
            Date now = new Date();
            String timestamp = new SimpleDateFormat("yyyyMMddHHmm").format(now);
            out.println("filetimestamp:" + timestamp);
            for (Waypoint pt : this.wayPts) {
                if (pt.name.startsWith("^")) continue;
                String dimensionsString = "";
                for (Integer dimension : pt.dimensions) {
                    dimensionsString = dimensionsString + "" + dimension + "#";
                }
                if (dimensionsString.equals("")) {
                    dimensionsString = "-1#0#";
                }
                out.println("name:" + this.scrubName(pt.name) + ",x:" + pt.x + ",z:" + pt.z + ",y:" + pt.y + ",enabled:" + Boolean.toString(pt.enabled) + ",red:" + pt.red + ",green:" + pt.green + ",blue:" + pt.blue + ",suffix:" + pt.imageSuffix + ",world:" + this.scrubName(pt.world) + ",dimensions:" + dimensionsString);
            }
            out.close();
        }
        catch (Exception local) {
            this.minimap.chatInfo("\u00a7EError Saving Waypoints");
        }
    }

    public String scrubName(String input) {
        input = input.replace(":", "~colon~");
        input = input.replace(",", "~comma~");
        return input;
    }

    private String descrubName(String input) {
        input = input.replace("~colon~", ":");
        input = input.replace("~comma~", ",");
        return input;
    }

    public String scrubFileName(String input) {
        input = input.replace("<", "~less~");
        input = input.replace(">", "~greater~");
        input = input.replace(":", "~colon~");
        input = input.replace("\"", "~quote~");
        input = input.replace("/", "~slash~");
        input = input.replace("\\", "~backslash~");
        input = input.replace("|", "~pipe~");
        input = input.replace("?", "~question~");
        input = input.replace("*", "~star~");
        return input;
    }

    public void loadWaypoints() {
        int portSepLoc;
        boolean loaded = false;
        this.wayPts = new ArrayList();
        String worldNameStandard = this.minimap.getCurrentWorldName();
        if (worldNameStandard.endsWith(":25565") && (portSepLoc = worldNameStandard.lastIndexOf(":")) != -1) {
            worldNameStandard = worldNameStandard.substring(0, portSepLoc);
        }
        worldNameStandard = this.scrubFileName(worldNameStandard);
        String worldNameWithPort = this.scrubFileName(this.minimap.getCurrentWorldName());
        String worldNameWithoutPort = this.minimap.getCurrentWorldName();
        int portSepLoc2 = worldNameWithoutPort.lastIndexOf(":");
        if (portSepLoc2 != -1) {
            worldNameWithoutPort = worldNameWithoutPort.substring(0, portSepLoc2);
        }
        worldNameWithoutPort = this.scrubFileName(worldNameWithoutPort);
        String worldNameWithDefaultPort = this.scrubFileName(worldNameWithoutPort + "~colon~25565");
        loaded = this.loadWaypointsExtensible(worldNameStandard);
        if (!loaded) {
            loaded = this.loadOldWaypoints(worldNameWithoutPort, worldNameWithDefaultPort, worldNameWithPort);
        }
        if (!loaded) {
            loaded = this.findReiWaypoints(worldNameWithoutPort);
        }
        if (!loaded) {
            this.minimap.chatInfo("\u00a7ENo waypoints exist for this world/server.");
        } else {
            this.populateOld2dWaypoints();
        }
    }

    private boolean loadWaypointsExtensible(String worldNameStandard) {
        File mcDir;
        File homeDir = FilesystemUtils.getAppDir("minecraft").getAbsoluteFile();
        if (!homeDir.equals(mcDir = azd.A().w.getAbsoluteFile())) {
            long homeDate = -1L;
            long localDate = -1L;
            String localDirName = "";
            if (this.minimap.game.E()) {
                localDirName = mcDir.getName();
                if ((localDirName.equalsIgnoreCase("minecraft") || localDirName.equalsIgnoreCase(".")) && mcDir.getParentFile() != null) {
                    localDirName = mcDir.getParentFile().getName();
                }
                localDirName = "~" + localDirName;
            }
            File settingsFileLocal = new File(azd.A().w, "/mods/VoxelMods/voxelMap/" + worldNameStandard + ".points");
            localDate = this.getDateFromSave(settingsFileLocal);
            File settingsFileHome = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap"), worldNameStandard + localDirName + ".points");
            if (!settingsFileHome.exists() && !settingsFileLocal.exists()) {
                settingsFileHome = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap"), worldNameStandard + ".points");
            }
            homeDate = this.getDateFromSave(settingsFileHome);
            if (!settingsFileHome.exists() && !settingsFileLocal.exists()) {
                return false;
            }
            this.settingsFile = !settingsFileHome.exists() ? settingsFileLocal : (!settingsFileLocal.exists() ? settingsFileHome : (homeDate > localDate ? settingsFileHome : settingsFileLocal));
        } else {
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/VoxelMods/voxelMap"), worldNameStandard + ".points");
        }
        if (this.settingsFile.exists()) {
            try {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new FileReader(this.settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    if (sCurrentLine.startsWith("filetimestamp")) continue;
                    String[] curLine = sCurrentLine.split(",");
                    String name = "";
                    int x = 0;
                    int z = 0;
                    int y2 = -1;
                    boolean enabled = false;
                    float red = 0.5f;
                    float green = 0.0f;
                    float blue = 0.0f;
                    String suffix = "";
                    String world = "";
                    TreeSet<Integer> dimensions = new TreeSet<Integer>();
                    for (int t = 0; t < curLine.length; ++t) {
                        String[] keyValuePair = curLine[t].split(":");
                        if (keyValuePair.length != 2) continue;
                        String key = keyValuePair[0];
                        String value = keyValuePair[1];
                        if (key.equals("name")) {
                            name = this.descrubName(value);
                            continue;
                        }
                        if (key.equals("x")) {
                            x = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("z")) {
                            z = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("y")) {
                            y2 = Integer.parseInt(value);
                            continue;
                        }
                        if (key.equals("enabled")) {
                            enabled = Boolean.parseBoolean(value);
                            continue;
                        }
                        if (key.equals("red")) {
                            red = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("green")) {
                            green = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("blue")) {
                            blue = Float.parseFloat(value);
                            continue;
                        }
                        if (key.equals("suffix")) {
                            suffix = value;
                            continue;
                        }
                        if (key.equals("world")) {
                            world = this.descrubName(value);
                            continue;
                        }
                        if (!key.equals("dimensions")) continue;
                        String[] dimensionStrings = value.split("#");
                        for (int s = 0; s < dimensionStrings.length; ++s) {
                            dimensions.add(Integer.parseInt(dimensionStrings[s]));
                        }
                        if (dimensions.size() != 0) continue;
                        dimensions.add(0);
                        dimensions.add(-1);
                    }
                    if (name.equals("")) continue;
                    this.loadWaypoint(name, x, z, y2, enabled, red, green, blue, suffix, world, dimensions);
                }
                in.close();
            }
            catch (Exception local) {
                this.minimap.chatInfo("\u00a7EError Loading Waypoints");
                System.out.println("waypoint load error: " + local.getLocalizedMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    private long getDateFromSave(File settingsFile) {
        if (settingsFile.exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                String sCurrentLine = in.readLine();
                String[] curLine = sCurrentLine.split(":");
                if (curLine[0].equals("filetimestamp")) {
                    in.close();
                    return Long.parseLong(curLine[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1L;
    }

    private boolean loadOldWaypoints(String worldNameWithPort, String worldNameWithDefaultPort, String worldNameWithoutPort) {
        try {
            this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan"), worldNameWithPort + ".points");
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan"), worldNameWithDefaultPort + ".points");
            }
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/zan"), worldNameWithoutPort + ".points");
            }
            if (!this.settingsFile.exists()) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft"), worldNameWithoutPort + ".points");
            }
            if (this.settingsFile.exists()) {
                String sCurrentLine;
                TreeSet<Integer> dimensions = new TreeSet<Integer>();
                dimensions.add(-1);
                dimensions.add(0);
                BufferedReader in = new BufferedReader(new FileReader(this.settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine.length == 4) {
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), 0.0f, 1.0f, 0.0f, "", "", dimensions);
                        continue;
                    }
                    if (curLine.length == 7) {
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), Float.parseFloat(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), "", "", dimensions);
                        continue;
                    }
                    if (curLine.length == 8) {
                        if (curLine[3].contains("true") || curLine[3].contains("false")) {
                            this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), -1, Boolean.parseBoolean(curLine[3]), Float.parseFloat(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), curLine[7], "", dimensions);
                            continue;
                        }
                        this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), Integer.parseInt(curLine[3]), Boolean.parseBoolean(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), Float.parseFloat(curLine[7]), "", "", dimensions);
                        continue;
                    }
                    if (curLine.length != 9) continue;
                    this.loadWaypoint(curLine[0], Integer.parseInt(curLine[1]), Integer.parseInt(curLine[2]), Integer.parseInt(curLine[3]), Boolean.parseBoolean(curLine[4]), Float.parseFloat(curLine[5]), Float.parseFloat(curLine[6]), Float.parseFloat(curLine[7]), curLine[8], "", dimensions);
                }
                in.close();
                return true;
            }
            return false;
        }
        catch (Exception local) {
            this.minimap.chatInfo("\u00a7EError Loading Waypoints");
            System.out.println("waypoint load error: " + local.getLocalizedMessage());
            return false;
        }
    }

    private boolean findReiWaypoints(String worldNameWithoutPort) {
        boolean foundSome = false;
        this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/rei_minimap"), worldNameWithoutPort + ".points");
        if (!this.settingsFile.exists()) {
            this.settingsFile = new File(azd.A().w, "/mods/rei_minimap/" + worldNameWithoutPort + ".points");
        }
        if (this.settingsFile.exists()) {
            this.loadReiWaypoints(this.settingsFile, 0);
            foundSome = true;
        } else {
            for (int t = -25; t < 25; ++t) {
                this.settingsFile = new File(FilesystemUtils.getAppDir("minecraft/mods/rei_minimap"), worldNameWithoutPort + ".DIM" + t + ".points");
                if (!this.settingsFile.exists()) {
                    this.settingsFile = new File(azd.A().w, "/mods/rei_minimap/" + worldNameWithoutPort + ".DIM" + t + ".points");
                }
                if (!this.settingsFile.exists()) continue;
                foundSome = true;
                this.loadReiWaypoints(this.settingsFile, t);
            }
        }
        return foundSome;
    }

    private void loadReiWaypoints(File settingsFile, int dimension) {
        try {
            if (settingsFile.exists()) {
                String sCurrentLine;
                TreeSet<Integer> dimensions = new TreeSet<Integer>();
                dimensions.add(dimension);
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine.length != 6) continue;
                    int color = Integer.parseInt(curLine[5], 16);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color >> 0 & 0xFF) / 255.0f;
                    int x = Integer.parseInt(curLine[1]);
                    int z = Integer.parseInt(curLine[3]);
                    if (dimension == -1) {
                        x *= 8;
                        z *= 8;
                    }
                    this.loadWaypoint(curLine[0], x, z, Integer.parseInt(curLine[2]), Boolean.parseBoolean(curLine[4]), red, green, blue, "", "", dimensions);
                }
            }
        }
        catch (Exception e) {
            this.minimap.chatInfo("\u00a7EError Loading Old Rei Waypoints");
            System.out.println("waypoint load error: " + e.getLocalizedMessage());
        }
    }

    public void loadWaypoint(String name, int x, int z, int y2, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<Integer> dimensions) {
        Waypoint newWaypoint = new Waypoint(name, x, z, y2, enabled, red, green, blue, suffix, world, dimensions);
        this.wayPts.add(newWaypoint);
    }

    public void populateOld2dWaypoints() {
        this.old2dWayPts = new ArrayList();
        for (Waypoint wpt : this.wayPts) {
            if (wpt.getY() > 0) continue;
            this.old2dWayPts.add(wpt);
        }
    }

    public void check2dWaypoints() {
        if (this.minimap.game.h.aq == 0 && this.old2dWayPts.size() > 0) {
            this.updatedPts = new ArrayList();
            for (Waypoint pt : this.old2dWayPts) {
                if (Math.abs(pt.getX() - this.minimap.xCoord()) >= 400 || Math.abs(pt.getZ() - this.minimap.zCoord()) >= 400 || !this.minimap.game.h.p.d((int)pt.getX(), (int)pt.getZ()).d) continue;
                pt.setY(this.minimap.game.h.p.f(pt.getX(), pt.getZ()));
                this.updatedPts.add(pt);
                this.saveWaypoints();
            }
            this.old2dWayPts.removeAll(this.updatedPts);
            System.out.println("remaining old 2d waypoints: " + this.old2dWayPts.size());
        }
    }

    private void deleteWaypoint(int i) {
        this.old2dWayPts.remove(this.wayPts.get(i));
        this.entityWaypointContainer.removeWaypoint(this.wayPts.get(i));
        this.wayPts.get(i).kill();
        this.wayPts.remove(i);
        this.saveWaypoints();
    }

    public void deleteWaypoint(Waypoint point) {
        this.old2dWayPts.remove(point);
        this.entityWaypointContainer.removeWaypoint(point);
        point.kill();
        this.wayPts.remove(point);
        this.saveWaypoints();
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
        this.entityWaypointContainer.addWaypoint(newWaypoint);
        this.saveWaypoints();
    }

    private void purgeWaypointEntity() {
        List entities = this.minimap.game.f.C();
        for (int t = 0; t < entities.size(); ++t) {
            qn entity = (qn)entities.get(t);
            if (!(entity instanceof EntityWaypointContainer)) continue;
            entity.B();
        }
    }

    public void injectWaypointEntity() {
        this.entityWaypointContainer = new EntityWaypointContainer(this.minimap.getWorld());
        for (Waypoint wpt : this.wayPts) {
            this.entityWaypointContainer.addWaypoint(wpt);
        }
        this.minimap.getWorld().d((qn)this.entityWaypointContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveWaypointEntityToBack() {
        List entities;
        List list = entities = this.minimap.game.f.C();
        synchronized (list) {
            int t = entities.indexOf((Object)this.entityWaypointContainer);
            if (t == -1) {
                this.purgeWaypointEntity();
                this.injectWaypointEntity();
                return;
            }
            if (t != entities.size() - 1) {
                Collections.swap(entities, t, entities.size() - 1);
            }
        }
    }
}

