/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.util.Dimension;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class DimensionManager {
    public ArrayList<Dimension> dimensions;
    private VoxelMap minimap = null;

    public DimensionManager(VoxelMap minimap) {
        this.minimap = minimap;
        this.dimensions = new ArrayList();
    }

    public void populateDimensions() {
        this.dimensions.clear();
        for (int t = -1; t <= 1; ++t) {
            String name = "notLoaded";
            apa provider = null;
            try {
                provider = apa.a((int)t);
            }
            catch (Exception e) {
                provider = null;
            }
            if (provider == null) continue;
            try {
                name = provider.l();
            }
            catch (Exception e) {
                name = "failedToLoad";
            }
            Dimension dim = new Dimension(name, t);
            this.dimensions.add(dim);
        }
        for (Waypoint pt : this.minimap.waypointManager.wayPts) {
            for (Integer t : pt.dimensions) {
                if (this.getDimensionByID(t) != null) continue;
                String name = "notLoaded";
                apa provider = null;
                try {
                    provider = apa.a((int)t);
                }
                catch (Exception e) {
                    provider = null;
                }
                if (provider == null) continue;
                try {
                    name = provider.l();
                }
                catch (Exception e) {
                    name = "failedToLoad";
                }
                Dimension dim = new Dimension(name, t);
                this.dimensions.add(dim);
            }
        }
        Collections.sort(this.dimensions, new Comparator<Dimension>(){

            @Override
            public int compare(Dimension dim1, Dimension dim2) {
                return dim1.ID - dim2.ID;
            }
        });
    }

    public void enteredDimension(int ID) {
        Dimension dim = this.getDimensionByID(ID);
        if (dim == null) {
            dim = new Dimension("notLoaded", ID);
            this.dimensions.add(dim);
            Collections.sort(this.dimensions, new Comparator<Dimension>(){

                @Override
                public int compare(Dimension dim1, Dimension dim2) {
                    return dim1.ID - dim2.ID;
                }
            });
        }
        if (dim.name.equals("notLoaded") || dim.name.equals("failedToLoad")) {
            try {
                dim.name = this.minimap.getWorld().t.l();
            }
            catch (Exception e) {
                dim.name = "dimension " + ID + "(" + this.minimap.getWorld().t.getClass().getSimpleName() + ")";
            }
        }
    }

    public Dimension getDimensionByID(int ID) {
        for (Dimension dim : this.dimensions) {
            if (dim.ID != ID) continue;
            return dim;
        }
        return null;
    }

    public Dimension getDimensionByName(String name) {
        for (Dimension dim : this.dimensions) {
            if (!dim.name.equals(name)) continue;
            return dim;
        }
        return null;
    }
}

