/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap.util;

import com.thevoxelbox.voxelmap.VoxelMap;
import com.thevoxelbox.voxelmap.util.MapChunk;

public class MapChunkCache {
    private int width;
    private int height;
    private aoj lastPlayerChunk = null;
    private MapChunk[] mapChunks;
    private boolean loaded = false;

    public MapChunkCache(int width, int height) {
        this.width = width;
        this.height = height;
        this.mapChunks = new MapChunk[width * height];
    }

    public void setChunk(int x, int z, MapChunk chunk) {
        this.mapChunks[x + z * this.width] = chunk;
    }

    public void checkIfChunksChanged(int playerX, int playerZ) {
        aoj currentChunk = VoxelMap.instance.getWorld().d(playerX, playerZ);
        if (currentChunk != this.lastPlayerChunk) {
            if (this.lastPlayerChunk == null) {
                this.fillAllChunks(playerX, playerZ);
                this.lastPlayerChunk = currentChunk;
                return;
            }
            int middleX = this.width / 2;
            int middleZ = this.height / 2;
            int movedX = currentChunk.g - this.lastPlayerChunk.g;
            int movedZ = currentChunk.h - this.lastPlayerChunk.h;
            if (Math.abs(movedX) < this.width && Math.abs(movedZ) < this.height && currentChunk.e.equals(this.lastPlayerChunk.e)) {
                int x;
                int z;
                this.moveX(movedX);
                this.moveZ(movedZ);
                for (z = movedZ > 0 ? this.height - movedZ : 0; z < (movedZ > 0 ? this.height : -movedZ); ++z) {
                    for (x = 0; x < this.width; ++x) {
                        this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.g - (middleX - x), currentChunk.h - (middleZ - z));
                    }
                }
                for (z = 0; z < this.height; ++z) {
                    for (x = movedX > 0 ? this.width - movedX : 0; x < (movedX > 0 ? this.width : -movedX); ++x) {
                        this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.g - (middleX - x), currentChunk.h - (middleZ - z));
                    }
                }
            } else {
                this.fillAllChunks(playerX, playerZ);
            }
            this.lastPlayerChunk = currentChunk;
        }
        for (int t = 0; t < this.width * this.height; ++t) {
            this.mapChunks[t].checkIfChunkChanged();
        }
    }

    public void fillAllChunks(int playerX, int playerZ) {
        aoj currentChunk = VoxelMap.instance.getWorld().d(playerX, playerZ);
        int middleX = this.width / 2;
        int middleZ = this.height / 2;
        for (int z = 0; z < this.height; ++z) {
            for (int x = 0; x < this.width; ++x) {
                this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.g - (middleX - x), currentChunk.h - (middleZ - z));
            }
        }
        this.loaded = true;
    }

    public void moveX(int offset) {
        if (offset > 0) {
            System.arraycopy(this.mapChunks, offset, this.mapChunks, 0, this.mapChunks.length - offset);
        } else if (offset < 0) {
            System.arraycopy(this.mapChunks, 0, this.mapChunks, -offset, this.mapChunks.length + offset);
        }
    }

    public void moveZ(int offset) {
        if (offset > 0) {
            System.arraycopy(this.mapChunks, offset * this.width, this.mapChunks, 0, this.mapChunks.length - offset * this.width);
        } else if (offset < 0) {
            System.arraycopy(this.mapChunks, 0, this.mapChunks, -offset * this.width, this.mapChunks.length + offset * this.width);
        }
    }

    public void calculateChunks(boolean oldNorth) {
        if (!this.loaded || VoxelMap.instance.dlSafe) {
            return;
        }
        for (int z = this.height - 1; z >= 0; --z) {
            int x;
            if (oldNorth) {
                for (x = this.width - 1; x >= 0; --x) {
                    this.mapChunks[x + z * this.width].calculateChunk();
                }
                continue;
            }
            for (x = 0; x < this.width; ++x) {
                this.mapChunks[x + z * this.width].calculateChunk();
            }
        }
    }
}

