/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.config;

import bspkrs.treecapitator.EnchantmentTreecapitating;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BSConfiguration;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;

public final class TCSettings {
    public static boolean allowDebugLogging = false;
    public static boolean allowDebugOutput = false;
    public static boolean allowItemDamage = true;
    public static boolean allowMoreBlocksThanDamage = false;
    public static float damageIncreaseAmount = 1.0f;
    public static float damageMultiplier = 1.0f;
    public static boolean destroyLeaves = true;
    public static boolean disableCreativeDrops = false;
    public static boolean disableInCreative = false;
    public static boolean enableEnchantmentMode = false;
    public static int enchantmentID = 187;
    private static final int enchantmentWeight = 5;
    public static int increaseDamageEveryXBlocks = 8;
    public static boolean needItem = true;
    public static boolean requireItemInAxeListForEnchant = true;
    public static boolean shearLeaves = false;
    public static boolean shearVines = false;
    public static String sneakAction = "disable";
    public static boolean useIncreasingItemDamage = false;
    public static boolean useStrictBlockPairing = true;
    public static boolean allowSmartTreeDetection = true;
    public static float breakSpeedModifier = 0.256f;
    public static int maxHorLogBreakDist = 16;
    public static int maxHorLeafBreakDist = 4;
    public static int maxLeafIDDist = 1;
    public static int maxVerLogBreakDist = -1;
    public static int minLeavesToID = 3;
    public static boolean onlyDestroyUpwards = true;
    public static boolean requireLeafDecayCheck = true;
    public static boolean useAdvancedTopLogLogic = true;
    public static String multiMineModID = "AS_MultiMine";
    public static boolean userConfigOverridesIMC = false;
    public static boolean saveIMCConfigsToFile = true;
    public static boolean treeHeightDecidesBreakSpeed = true;
    public static float treeHeightModifier = 2.0f;
    public static boolean allowOreDictionaryLookup = true;
    public static String oreDictionaryLogStrings = "logWood,";
    public static String oreDictionaryLeafStrings = "treeLeaves,";
    public static String blockIDBlacklist = "";
    public static String itemIDBlacklist = "";
    public static Enchantment treecapitating;
    private static TCSettings instance;

    public static TCSettings instance() {
        if (instance == null) {
            new TCSettings();
        }
        return instance;
    }

    private TCSettings() {
        instance = this;
    }

    public void handleEnchantmentID(int id) {
        if (id >= 0 && id < 256 && enableEnchantmentMode) {
            if (Enchantment.field_77331_b[enchantmentID] != null) {
                Enchantment.field_77331_b[TCSettings.enchantmentID] = null;
            }
            enchantmentID = id;
            treecapitating = new EnchantmentTreecapitating(enchantmentID, 5);
            treecapitating.func_77322_b("treecapitating");
            LanguageRegistry.instance().addStringLocalization("enchantment.treecapitating", "Treecapitating");
        }
    }

    public void readFromNBT(NBTTagCompound ntc) {
        allowItemDamage = ntc.func_74767_n("allowItemDamage");
        allowMoreBlocksThanDamage = ntc.func_74767_n("allowMoreBlocksThanDamage");
        allowSmartTreeDetection = ntc.func_74767_n("allowSmartTreeDetection");
        treeHeightDecidesBreakSpeed = ntc.func_74767_n("treeHeightDecidesBreakSpeed");
        treeHeightModifier = ntc.func_74760_g("treeHeightModifier");
        breakSpeedModifier = ntc.func_74760_g("breakSpeedModifier");
        damageIncreaseAmount = ntc.func_74760_g("damageIncreaseAmount");
        damageMultiplier = ntc.func_74760_g("damageMultiplier");
        destroyLeaves = ntc.func_74767_n("destroyLeaves");
        disableCreativeDrops = ntc.func_74767_n("disableCreativeDrops");
        disableInCreative = ntc.func_74767_n("disableInCreative");
        enableEnchantmentMode = ntc.func_74767_n("enableEnchantmentMode");
        allowOreDictionaryLookup = ntc.func_74767_n("allowOreDictionaryLookup");
        oreDictionaryLogStrings = ntc.func_74779_i("oreDictionaryLogStrings");
        oreDictionaryLeafStrings = ntc.func_74779_i("oreDictionaryLeafStrings");
        this.handleEnchantmentID(ntc.func_74762_e("enchantmentID"));
        increaseDamageEveryXBlocks = ntc.func_74762_e("increaseDamageEveryXBlocks");
        maxHorLogBreakDist = ntc.func_74762_e("maxHorLogBreakDist");
        maxHorLeafBreakDist = ntc.func_74762_e("maxHorLeafBreakDist");
        maxLeafIDDist = ntc.func_74762_e("maxLeafIDDist");
        maxVerLogBreakDist = ntc.func_74762_e("maxVerLogBreakDist");
        minLeavesToID = ntc.func_74762_e("minLeavesToID");
        needItem = ntc.func_74767_n("needItem");
        onlyDestroyUpwards = ntc.func_74767_n("onlyDestroyUpwards");
        requireItemInAxeListForEnchant = ntc.func_74767_n("requireItemInAxeListForEnchant");
        requireLeafDecayCheck = ntc.func_74767_n("requireLeafDecayCheck");
        shearLeaves = ntc.func_74767_n("shearLeaves");
        shearVines = ntc.func_74767_n("shearVines");
        sneakAction = ntc.func_74779_i("sneakAction");
        useAdvancedTopLogLogic = ntc.func_74767_n("useAdvancedTopLogLogic");
        useIncreasingItemDamage = ntc.func_74767_n("useIncreasingItemDamage");
        useStrictBlockPairing = ntc.func_74767_n("useStrictBlockPairing");
    }

    public void writeToNBT(NBTTagCompound ntc) {
        ntc.func_74757_a("allowItemDamage", allowItemDamage);
        ntc.func_74757_a("allowMoreBlocksThanDamage", allowMoreBlocksThanDamage);
        ntc.func_74757_a("allowOreDictionaryLookup", allowOreDictionaryLookup);
        ntc.func_74757_a("allowSmartTreeDetection", allowSmartTreeDetection);
        ntc.func_74757_a("treeHeightDecidesBreakSpeed", treeHeightDecidesBreakSpeed);
        ntc.func_74776_a("treeHeightModifier", treeHeightModifier);
        ntc.func_74776_a("breakSpeedModifier", breakSpeedModifier);
        ntc.func_74776_a("damageIncreaseAmount", damageIncreaseAmount);
        ntc.func_74776_a("damageMultiplier", damageMultiplier);
        ntc.func_74757_a("destroyLeaves", destroyLeaves);
        ntc.func_74757_a("disableCreativeDrops", disableCreativeDrops);
        ntc.func_74757_a("disableInCreative", disableInCreative);
        ntc.func_74757_a("enableEnchantmentMode", enableEnchantmentMode);
        ntc.func_74768_a("enchantmentID", enchantmentID);
        ntc.func_74768_a("increaseDamageEveryXBlocks", increaseDamageEveryXBlocks);
        ntc.func_74768_a("maxHorLogBreakDist", maxHorLogBreakDist);
        ntc.func_74768_a("maxHorLeafBreakDist", maxHorLeafBreakDist);
        ntc.func_74768_a("maxLeafIDDist", maxLeafIDDist);
        ntc.func_74768_a("maxVerLogBreakDist", maxVerLogBreakDist);
        ntc.func_74768_a("minLeavesToID", minLeavesToID);
        ntc.func_74757_a("needItem", needItem);
        ntc.func_74757_a("onlyDestroyUpwards", onlyDestroyUpwards);
        ntc.func_74778_a("oreDictionaryLogStrings", oreDictionaryLogStrings);
        ntc.func_74778_a("oreDictionaryLeafStrings", oreDictionaryLeafStrings);
        ntc.func_74757_a("requireItemInAxeListForEnchant", requireItemInAxeListForEnchant);
        ntc.func_74757_a("requireLeafDecayCheck", requireLeafDecayCheck);
        ntc.func_74757_a("shearLeaves", shearLeaves);
        ntc.func_74757_a("shearVines", shearVines);
        ntc.func_74778_a("sneakAction", sneakAction);
        ntc.func_74757_a("useAdvancedTopLogLogic", useAdvancedTopLogLogic);
        ntc.func_74757_a("useIncreasingItemDamage", useIncreasingItemDamage);
        ntc.func_74757_a("useStrictBlockPairing", useStrictBlockPairing);
    }

    public void syncConfiguration(BSConfiguration config) {
        allowDebugLogging = config.getBoolean("allowDebugLogging", "general_settings.miscellaneous_settings", allowDebugLogging, "[Global] Set to true if you want TreeCapitator to log info about what it's doing, false to disable.\nIf you are having an issue with the mod, set this option to true and post the resulting log to the\nTreecapitator Minecraftforum.net thread along with a detailed description of the issue.");
        allowDebugOutput = config.getBoolean("allowDebugOutput", "general_settings.miscellaneous_settings", allowDebugOutput, "[Global] Set to true if you want TreeCapitator to tell you what kind of block you have clicked when \nsneaking, false to disable.");
        disableCreativeDrops = config.getBoolean("disableCreativeDrops", "general_settings.miscellaneous_settings", disableCreativeDrops, "[Global] Flag to disable drops in Creative mode");
        disableInCreative = config.getBoolean("disableInCreative", "general_settings.miscellaneous_settings", disableInCreative, "[Global] Flag to disable tree chopping in Creative mode");
        allowOreDictionaryLookup = config.getBoolean("allowOreDictionaryLookup", "general_settings.miscellaneous_settings", allowOreDictionaryLookup, "[Global] When true, TreeCapitator will scan the Forge Ore Dictionary for blocks with an ore name matching\none of the strings in oreDictionaryLogStrings and generate a generic tree definition for them on the fly. \nWhen false oreDictionaryLogStrings and oreDictionaryLeafStrings will be ignored.");
        oreDictionaryLogStrings = config.getString("oreDictionaryLogStrings", "general_settings.miscellaneous_settings", oreDictionaryLogStrings, "[Global] The list of log type values to check for in the Forge Ore Dictionary. Entries are comma (,) separated.");
        oreDictionaryLeafStrings = config.getString("oreDictionaryLeafStrings", "general_settings.miscellaneous_settings", oreDictionaryLeafStrings, "[Global] The list of leaf type values to check for in the Forge Ore Dictionary. Entries are comma (,) separated.");
        blockIDBlacklist = config.getString("blockIDBlacklist", "general_settings.miscellaneous_settings", blockIDBlacklist, "[Global] Add unique block names to this list if you want to keep them from being registered as logs. This list will override\nthe local user configuration, inter-mod communication (IMC) configuration, and the Ore Dictionary scanning feature.\nUse ',' to split block name from metadata and ';' to split entries.\nRefer to the UniqueNames.txt file in the config folder for a list of values.");
        itemIDBlacklist = config.getString("itemIDBlacklist", "general_settings.miscellaneous_settings", itemIDBlacklist, "[Global] Add unique item names to this list if you want to keep them from being registered as axes. This list will override\nthe local user configuration and inter-mod communication (IMC) configuration.\nUse ',' to split item name from metadata and ';' to split entries.\nRefer to the UniqueNames.txt file in the config folder for a list of values.");
        sneakAction = config.getString("sneakAction", "general_settings.miscellaneous_settings", sneakAction, "[Global] Set sneakAction = \"disable\" to disable tree chopping while sneaking,\nset sneakAction = \"enable\" to only enable tree chopping while sneaking,\nset sneakAction = \"none\" to have tree chopping enabled regardless of sneaking.");
        breakSpeedModifier = config.getFloat("breakSpeedModifier", "general_settings.break_speed_settings", breakSpeedModifier, 0.01f, 1.0f, "[Global, PerTree] When using an item that can chop trees, the break speed will by multiplied by this value\nTHIS OPTION IS IGNORED WHEN treeHeightDecidesBreakSpeed=true");
        treeHeightDecidesBreakSpeed = config.getBoolean("treeHeightDecidesBreakSpeed", "general_settings.break_speed_settings", treeHeightDecidesBreakSpeed, "[Global] When true, the log break speed is equal to original break speed / (tree height * <treeHeightModifier>)\nWhen false, the original break speed is multiplied by the breakSpeedModifier value");
        treeHeightModifier = config.getFloat("treeHeightModifier", "general_settings.break_speed_settings", treeHeightModifier, 0.25f, 10.0f, "[Global] See description for treeHeightDecidesBreakSpeed");
        needItem = config.getBoolean("needItem", "general_settings.item_settings", needItem, "[Global] Whether you need an item from the axeIDList to chop down a tree. Disabling will let you chop \ntrees with any item.");
        allowItemDamage = config.getBoolean("allowItemDamage", "general_settings.item_settings", allowItemDamage, "[Global] Enable to cause item damage based on number of blocks destroyed");
        allowMoreBlocksThanDamage = config.getBoolean("allowMoreBlocksThanDamage", "general_settings.item_settings", allowMoreBlocksThanDamage, "[Global] Enable to allow chopping down the entire tree even if your item does not have enough damage \nremaining to cover the number of blocks.");
        increaseDamageEveryXBlocks = config.getInt("increaseDamageEveryXBlocks", "general_settings.item_settings", increaseDamageEveryXBlocks, 1, 500, "[Global] When useIncreasingItemDamage=true the damage applied per block broken will increase each time \nthis many blocks are broken in a tree.");
        useIncreasingItemDamage = config.getBoolean("useIncreasingItemDamage", "general_settings.item_settings", useIncreasingItemDamage, "[Global] Set to true to have the per-block item damage amount increase after every \nincreaseDamageEveryXBlocks blocks are broken.");
        damageIncreaseAmount = config.getFloat("damageIncreaseAmount", "general_settings.item_settings", damageIncreaseAmount, 0.1f, 100.0f, "[Global] When useIncreasingItemDamage=true the damage applied per block broken will increase by this \namount every increaseDamageEveryXBlocks blocks broken in a tree.");
        damageMultiplier = config.getFloat("damageMultiplier", "general_settings.item_settings", damageMultiplier, 0.1f, 50.0f, "[Global] Axes and shears will take damage this many times for each log broken. Remaining damage is \nrounded and applied to tools when a tree is finished.");
        allowSmartTreeDetection = config.getBoolean("allowSmartTreeDetection", "general_settings.tree_chop_behavior_settings", allowSmartTreeDetection, "[Global, PerTree] Set to false to disable TreeCapitator Smart Tree Detection.\nSmart Tree Detection counts the number of leaf blocks that are adjacent to the\ntop-most connected log block at the x, z location of a log you've broken. If\nthere are at least minLeavesToID leaf blocks within maxLeafIDDist blocks then\nTreeCapitator considers it a tree and allows chopping.\nWARNING: Disabling Smart Tree Detection will remove the only safeguard against\naccidentally destroying a log structure.  Make sure you know what you're doing!");
        useAdvancedTopLogLogic = config.getBoolean("useAdvancedTopLogLogic", "general_settings.tree_chop_behavior_settings", useAdvancedTopLogLogic, "[Global, PerTree] Set to false to use the older \"top log\" algorithm for finding the top log of a tree.\nThe old algorithm searches only the vertical column of blocks above the log you are chopping,\nthe newer algorithm is able to branch out to find the true top log of a tree.");
        useStrictBlockPairing = config.getBoolean("useStrictBlockPairing", "general_settings.tree_chop_behavior_settings", useStrictBlockPairing, "[Global] Set to true if you want only the log/leaf blocks listed with each log in a tree\nto break when that log type is chopped.  When set to false it will break\nany log/leaf type blocks connected to the tree, not just the types for that tree.");
        destroyLeaves = config.getBoolean("destroyLeaves", "general_settings.tree_chop_behavior_settings", destroyLeaves, "[Global] Enabling this will make leaves be destroyed when trees are chopped.");
        shearLeaves = config.getBoolean("shearLeaves", "general_settings.tree_chop_behavior_settings", shearLeaves, "[Global] Enabling this will cause destroyed leaves to be sheared when a shearing item is in the hotbar \n(ignored if destroyLeaves is false).");
        shearVines = config.getBoolean("shearVines", "general_settings.tree_chop_behavior_settings", shearVines, "[Global] Enabling this will shear /some/ of the vines on a tree when a shearing item is in the hotbar \n(ignored if destroyLeaves is false).");
        maxHorLeafBreakDist = config.getInt("maxHorLeafBreakDist", "general_settings.tree_chop_behavior_settings", maxHorLeafBreakDist, -1, 100, "[Global, PerTree] The maximum horizontal distance that the leaf breaking effect will travel from the tree (use -1 for no limit).");
        maxHorLogBreakDist = config.getInt("maxHorLogBreakDist", "general_settings.tree_chop_behavior_settings", maxHorLogBreakDist, -1, 100, "[Global, PerTree] The maximum horizontal distance that the log breaking effect will travel (use -1 for no limit).");
        maxVerLogBreakDist = config.getInt("maxVerLogBreakDist", "general_settings.tree_chop_behavior_settings", maxVerLogBreakDist, -1, 255, "[Global, PerTree] The maximum vertical distance that the log breaking effect will travel (use -1 for no limit).");
        maxLeafIDDist = config.getInt("maxLeafIDDist", "general_settings.tree_chop_behavior_settings", maxLeafIDDist, 1, 8, "[Global, PerTree] If a tree's top log is not close enough to leaf blocks, the tree will not be chopped.\nIncreasing this value will search further.  I would try to keep it at or below 3.");
        minLeavesToID = config.getInt("minLeavesToID", "general_settings.tree_chop_behavior_settings", minLeavesToID, 0, 8, "[Global, PerTree] The minimum number of leaves within maxLeafIDDist of the top log block required to identify a tree.");
        onlyDestroyUpwards = config.getBoolean("onlyDestroyUpwards", "general_settings.tree_chop_behavior_settings", onlyDestroyUpwards, "[Global, PerTree] Setting this to false will allow the chopping to move downward as well as upward (and \nblocks below the one you break will be chopped)");
        requireLeafDecayCheck = config.getBoolean("requireLeafDecayCheck", "general_settings.tree_chop_behavior_settings", requireLeafDecayCheck, "[Global, PerTree] When true TreeCapitator will only instantly decay leaves that have actually been marked \nfor decay. Set to false if you want leaves to be destroyed regardless of their decay status \n(hint: or for \"leaf\" blocks that are not really leaves).");
        enableEnchantmentMode = config.getBoolean("enableEnchantmentMode", "general_settings.enchantment_mode_settings", enableEnchantmentMode, "[Global] Toggle for whether or not to use the Treecapitating enchantment as opposed to requiring an item \nto be in the axeIDList to chop a tree.");
        this.handleEnchantmentID(config.getInt("enchantmentID", "general_settings.enchantment_mode_settings", enchantmentID, 0, Enchantment.field_77331_b.length - 1, "[Global] The internal ID for the Treecapitating enchantment. Change this if the default ID is conflicting \nwith another mod."));
        requireItemInAxeListForEnchant = config.getBoolean("requireItemInAxeListForEnchant", "general_settings.enchantment_mode_settings", requireItemInAxeListForEnchant, "[Global] Whether or not to check the axe ID list for an item when determining if a given item can be \nimbued with the Treecapitating enchantment.\nNOTE: when set to false, any ItemTool type item (pickaxes, shovels, etc) with a high enough \nenchantability level can get the enchantment, not just axes.");
        if (allowDebugLogging) {
            TCLog.configs((Configuration)config, "general_settings.miscellaneous_settings");
            TCLog.configs((Configuration)config, "general_settings.break_speed_settings");
            TCLog.configs((Configuration)config, "general_settings.item_settings");
            TCLog.configs((Configuration)config, "general_settings.tree_chop_behavior_settings");
            TCLog.configs((Configuration)config, "general_settings.enchantment_mode_settings");
        }
    }
}

