/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.forge;

import bspkrs.helpers.item.ItemHelper;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHandler {
    private static OreDictionaryHandler instance;
    private static boolean hasRun;

    public static OreDictionaryHandler instance() {
        if (instance == null) {
            instance = new OreDictionaryHandler();
        }
        return instance;
    }

    public void generateAndRegisterOreDictionaryTreeDefinitions() {
        if (!hasRun) {
            hasRun = true;
            if (TCSettings.allowOreDictionaryLookup) {
                TCLog.info("Scanning Ore Dictionary for unregistered tree blocks...", new Object[0]);
                LinkedList<BlockID> leafList = new LinkedList<BlockID>();
                for (String oreName : TCSettings.oreDictionaryLeafStrings.split(",")) {
                    if (oreName.trim().isEmpty()) continue;
                    for (ItemStack itemStack : OreDictionary.getOres((String)oreName.trim())) {
                        Item item = itemStack.func_77973_b();
                        BlockID blockID = new BlockID(ItemHelper.getUniqueID((Item)item));
                        if (!(item instanceof ItemBlock) || leafList.contains(blockID)) continue;
                        leafList.add(blockID);
                    }
                }
                for (String oreName : TCSettings.oreDictionaryLogStrings.split(",")) {
                    if (oreName.trim().isEmpty()) continue;
                    TreeDefinition genericTree = new TreeDefinition();
                    for (ItemStack itemStack : OreDictionary.getOres((String)oreName.trim())) {
                        Item item = itemStack.func_77973_b();
                        if (!(item instanceof ItemBlock)) continue;
                        BlockID blockID = new BlockID(ItemHelper.getUniqueID((Item)item));
                        if (TreeRegistry.instance().isRegistered(blockID)) continue;
                        genericTree.addLogID(blockID);
                    }
                    if (genericTree.getLogList().isEmpty()) continue;
                    for (BlockID blockID : leafList) {
                        genericTree.addLeafID(blockID);
                    }
                    for (BlockID blockID : TreeRegistry.instance().masterDefinition().getLeafList()) {
                        genericTree.addLeafID(blockID);
                    }
                    TCLog.debug("Registering generic Ore Dictionary tree %s...", oreName.trim());
                    TreeRegistry.instance().registerTree(oreName.trim(), genericTree);
                }
                TCLog.info("Ore Dictionary processing complete.", new Object[0]);
            } else {
                TCLog.info("Skipping Ore Dictionary processing.", new Object[0]);
            }
        }
    }

    static {
        hasRun = false;
    }
}

