/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.helpers.nbt.NBTTagCompoundHelper;
import bspkrs.helpers.nbt.NBTTagListHelper;
import bspkrs.treecapitator.TreecapitatorMod;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ToolRegistry;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.registry.TreeRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BSConfiguration;
import bspkrs.util.ItemID;
import bspkrs.util.ListUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ThirdPartyModConfig {
    private String modID;
    private String axeKeys;
    private String shearsKeys;
    private boolean overrideIMC;
    private Map<String, TreeDefinition> configTreesMap;
    private Map<String, TreeDefinition> treesMap;
    private Map<String, String> tagMap;

    protected ThirdPartyModConfig(boolean init) {
        this.modID = TreecapitatorMod.metadata.modId;
        this.overrideIMC = TCSettings.userConfigOverridesIMC;
        this.tagMap = new HashMap<String, String>();
        this.treesMap = new TreeMap<String, TreeDefinition>();
        if (init) {
            this.axeKeys = ListUtils.getListAsDelimitedString(ToolRegistry.instance().vanillaAxeList(), (String)"; ");
            this.shearsKeys = ListUtils.getListAsDelimitedString(ToolRegistry.instance().vanillaShearsList(), (String)"; ");
            this.configTreesMap = TreeRegistry.instance().vanillaTrees();
            this.refreshTreeDefinitionsFromConfig();
        } else {
            this.axeKeys = "";
            this.shearsKeys = "";
            this.configTreesMap = new TreeMap<String, TreeDefinition>();
        }
    }

    protected ThirdPartyModConfig() {
        this(true);
    }

    public ThirdPartyModConfig(String modID, String configPath, String axeKeys, String shearsKeys) {
        this.modID = modID;
        this.axeKeys = axeKeys;
        this.shearsKeys = shearsKeys;
        this.overrideIMC = TCSettings.userConfigOverridesIMC;
        this.configTreesMap = new TreeMap<String, TreeDefinition>();
        this.treesMap = new TreeMap<String, TreeDefinition>();
    }

    public ThirdPartyModConfig(String modID, String configPath) {
        this(modID, configPath, "", "");
    }

    public ThirdPartyModConfig(BSConfiguration config, String category) {
        this(false);
        this.readFromConfiguration(config, category);
    }

    public ThirdPartyModConfig(NBTTagCompound tpModCfg) {
        this(false);
        this.readFromNBT(tpModCfg);
    }

    public ThirdPartyModConfig readFromNBT(NBTTagCompound tpModCfg) {
        this.modID = tpModCfg.func_74779_i("modID");
        if (tpModCfg.func_74764_b("axeIDList")) {
            this.axeKeys = tpModCfg.func_74779_i("axeIDList");
        }
        if (tpModCfg.func_74764_b("shearsIDList")) {
            this.shearsKeys = tpModCfg.func_74779_i("shearsIDList");
        }
        this.configTreesMap = new TreeMap<String, TreeDefinition>();
        NBTTagList treeList = NBTTagCompoundHelper.getTagList((NBTTagCompound)tpModCfg, (String)"trees", (Byte)10);
        for (int i = 0; i < treeList.func_74745_c(); ++i) {
            NBTTagCompound tree = NBTTagListHelper.getCompoundTagAt((NBTTagList)treeList, (int)i);
            this.addConfigTreeDef(tree.func_74779_i("treeName"), new TreeDefinition(tree));
        }
        return this;
    }

    public void writeToNBT(NBTTagCompound tpModCfg) {
        tpModCfg.func_74778_a("modID", this.modID);
        if (this.axeKeys.length() > 0) {
            tpModCfg.func_74778_a("axeIDList", this.axeKeys);
        }
        if (this.shearsKeys.length() > 0) {
            tpModCfg.func_74778_a("shearsIDList", this.shearsKeys);
        }
        NBTTagList treeList = new NBTTagList();
        for (Map.Entry<String, TreeDefinition> e : this.configTreesMap.entrySet()) {
            NBTTagCompound tree = new NBTTagCompound();
            e.getValue().writeToNBT(tree);
            tree.func_74778_a("treeName", e.getKey());
            treeList.func_74742_a((NBTBase)tree);
        }
        tpModCfg.func_74782_a("trees", (NBTBase)treeList);
    }

    public ThirdPartyModConfig readFromConfiguration(BSConfiguration config, String category) {
        ConfigCategory cc = config.getCategory(category);
        this.modID = cc.get("modID").getString();
        if (cc.containsKey("axeIDList")) {
            this.axeKeys = cc.get("axeIDList").getString();
        }
        if (cc.containsKey("shearsIDList")) {
            this.shearsKeys = cc.get("shearsIDList").getString();
        }
        this.overrideIMC = config.getBoolean("overrideIMC", category, TCSettings.userConfigOverridesIMC, "This setting controls whether or not the mod config section it appears in will override an IMC message sent by that mod.");
        this.configTreesMap = new TreeMap<String, TreeDefinition>();
        for (String ctgy : config.getCategoryNames()) {
            if (ctgy.indexOf(category + ".") == -1) continue;
            this.addConfigTreeDef(config.getCategory(ctgy).getQualifiedName(), new TreeDefinition((Configuration)config, ctgy));
        }
        return this;
    }

    public void writeToConfiguration(BSConfiguration config, String category) {
        config.get(category, "modID", this.modID);
        if (this.axeKeys.length() > 0) {
            config.get(category, "axeIDList", this.axeKeys);
        }
        if (this.shearsKeys.length() > 0) {
            config.get(category, "shearsIDList", this.shearsKeys);
        }
        config.getBoolean("overrideIMC", category, this.overrideIMC, "This setting controls whether or not the mod config section it appears in will override an IMC message sent by that mod.");
        for (Map.Entry<String, TreeDefinition> e : this.configTreesMap.entrySet()) {
            e.getValue().writeToConfiguration((Configuration)config, category + "." + e.getKey());
        }
    }

    public ThirdPartyModConfig addConfigTreeDef(String key, TreeDefinition tree) {
        if (!this.configTreesMap.containsKey(key)) {
            this.configTreesMap.put(key, tree);
        } else {
            TCLog.warning("Mod %s attempted to add two tree configs with the same name: %s", this.modID, key);
        }
        return this;
    }

    public ThirdPartyModConfig addTreeDef(String key, TreeDefinition tree) {
        if (!this.treesMap.containsKey(key)) {
            this.treesMap.put(key, tree);
        } else {
            TCLog.warning("Mod %s attempted to add two tree definitions with the same id: %s", this.modID, key);
        }
        return this;
    }

    public ThirdPartyModConfig registerTrees() {
        this.refreshTreeDefinitionsFromConfig();
        for (Map.Entry<String, TreeDefinition> e : this.treesMap.entrySet()) {
            TreeRegistry.instance().registerTree(e.getKey(), e.getValue());
        }
        return this;
    }

    public ThirdPartyModConfig registerTools() {
        String axeList = this.axeKeys;
        String shearsList = this.shearsKeys;
        for (Map.Entry<String, String> e : this.tagMap.entrySet()) {
            axeList = axeList.replace(e.getKey(), e.getValue());
            shearsList = shearsList.replace(e.getKey(), e.getValue());
        }
        for (ItemID axe : ListUtils.getDelimitedStringAsItemIDList((String)axeList, (String)";")) {
            if (axe.id.equals("")) continue;
            ToolRegistry.instance().registerAxe(axe);
        }
        for (ItemID shears : ListUtils.getDelimitedStringAsItemIDList((String)shearsList, (String)";")) {
            if (shears.id.equals("")) continue;
            ToolRegistry.instance().registerShears(shears);
        }
        return this;
    }

    public String modID() {
        return this.modID;
    }

    public boolean overrideIMC() {
        return this.overrideIMC;
    }

    public ThirdPartyModConfig setOverrideIMC(boolean bol) {
        this.overrideIMC = bol;
        return this;
    }

    public ThirdPartyModConfig refreshTreeDefinitionsFromConfig() {
        this.treesMap.clear();
        for (Map.Entry<String, TreeDefinition> e : this.configTreesMap.entrySet()) {
            this.treesMap.put(e.getKey(), e.getValue());
        }
        return this;
    }
}

