/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.network;

import bspkrs.helpers.network.PacketBufferHelper;
import bspkrs.network.BSPacket;
import bspkrs.treecapitator.TreecapitatorMod;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class TCPacketConfig
implements BSPacket {
    protected NBTTagCompound settings;
    protected NBTTagCompound treeRegistry;
    protected NBTTagCompound toolRegistry;

    public TCPacketConfig() {
        this(TreecapitatorMod.instance.nbtManager().getPacketArray());
    }

    public TCPacketConfig(NBTTagCompound settings, NBTTagCompound treeRegistry, NBTTagCompound toolRegistry) {
        this(new NBTTagCompound[]{settings, treeRegistry, toolRegistry});
    }

    public TCPacketConfig(NBTTagCompound[] packetArray) {
        assert (packetArray.length == 3) : "Length of packetArray must be 3!";
        this.settings = packetArray[0];
        this.treeRegistry = packetArray[1];
        this.toolRegistry = packetArray[2];
    }

    public void readBytes(PacketBuffer buffer) {
        try {
            this.settings = PacketBufferHelper.readNBTTagCompound((PacketBuffer)buffer);
            this.treeRegistry = PacketBufferHelper.readNBTTagCompound((PacketBuffer)buffer);
            this.toolRegistry = PacketBufferHelper.readNBTTagCompound((PacketBuffer)buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeBytes(PacketBuffer buffer) {
        try {
            PacketBufferHelper.writeNBTTagCompound((PacketBuffer)buffer, (NBTTagCompound)this.settings);
            PacketBufferHelper.writeNBTTagCompound((PacketBuffer)buffer, (NBTTagCompound)this.treeRegistry);
            PacketBufferHelper.writeNBTTagCompound((PacketBuffer)buffer, (NBTTagCompound)this.toolRegistry);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

