/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.util.ItemID;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ToolRegistry {
    private static ToolRegistry instance;
    private List<ItemID> axeList;
    private List<ItemID> shearsList;
    private List<ItemID> vanAxeList;
    private List<ItemID> vanShearsList;
    private List<ItemID> blacklist;

    public static ToolRegistry instance() {
        if (instance == null) {
            new ToolRegistry();
        }
        return instance;
    }

    protected ToolRegistry() {
        instance = this;
        this.initLists();
        this.initVanillaItemLists();
    }

    protected void initLists() {
        this.axeList = new ArrayList<ItemID>();
        this.shearsList = new ArrayList<ItemID>();
        this.blacklist = new ArrayList<ItemID>();
    }

    protected void initVanillaLists() {
        this.vanAxeList = new ArrayList<ItemID>();
        this.vanShearsList = new ArrayList<ItemID>();
    }

    protected void initVanillaItemLists() {
        this.initVanillaLists();
        this.vanAxeList.add(new ItemID(Items.field_151053_p));
        this.vanAxeList.add(new ItemID(Items.field_151049_t));
        this.vanAxeList.add(new ItemID(Items.field_151036_c));
        this.vanAxeList.add(new ItemID(Items.field_151006_E));
        this.vanAxeList.add(new ItemID(Items.field_151056_x));
        this.vanShearsList.add(new ItemID((Item)Items.field_151097_aZ));
    }

    public List<ItemID> blacklist() {
        return new ArrayList<ItemID>(this.blacklist);
    }

    public void readBlacklistFromDelimitedString(String dList) {
        this.blacklist = ListUtils.getDelimitedStringAsItemIDList((String)dList, (String)";");
    }

    protected void readFromNBT(NBTTagCompound ntc) {
        this.axeList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.func_74779_i("axeIDList"), (String)";");
        this.shearsList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.func_74779_i("shearsIDList"), (String)";");
        this.blacklist = ListUtils.getDelimitedStringAsItemIDList((String)ntc.func_74779_i("blacklist"), (String)";");
    }

    public void writeToNBT(NBTTagCompound ntc) {
        ntc.func_74778_a("axeIDList", ListUtils.getListAsDelimitedString(this.axeList, (String)";"));
        ntc.func_74778_a("shearsIDList", ListUtils.getListAsDelimitedString(this.shearsList, (String)";"));
        ntc.func_74778_a("blacklist", ListUtils.getListAsDelimitedString(this.blacklist, (String)";"));
    }

    public void registerAxe(ItemID axe) {
        if (axe != null && !this.blacklist.contains(axe) && !this.axeList.contains(axe)) {
            this.axeList.add(axe);
        }
    }

    public void registerShears(ItemID shears) {
        if (shears != null && !this.blacklist.contains(shears) && !this.shearsList.contains(shears)) {
            this.shearsList.add(shears);
        }
    }

    public List<ItemID> axeList() {
        return new ArrayList<ItemID>(this.axeList);
    }

    public List<ItemID> shearsList() {
        return new ArrayList<ItemID>(this.shearsList);
    }

    public List<ItemID> vanillaAxeList() {
        return new ArrayList<ItemID>(this.vanAxeList);
    }

    public List<ItemID> vanillaShearsList() {
        return new ArrayList<ItemID>(this.vanShearsList);
    }

    public boolean isAxe(ItemID itemID) {
        return !this.blacklist.contains(itemID) && this.axeList.contains(itemID);
    }

    public boolean isAxe(Item item) {
        if (item != null) {
            ItemID itemID = new ItemID(item);
            return !this.blacklist.contains(itemID) && this.axeList.contains(itemID);
        }
        return false;
    }

    public boolean isAxe(ItemStack itemStack) {
        if (itemStack != null) {
            ItemID itemID = new ItemID(itemStack);
            return !this.blacklist.contains(itemID) && this.axeList.contains(itemID);
        }
        return false;
    }

    public boolean isShears(ItemID itemID) {
        return !this.blacklist.contains(itemID) && this.shearsList.contains(itemID);
    }

    public boolean isShears(Item item) {
        if (item != null) {
            ItemID itemID = new ItemID(item);
            return !this.blacklist.contains(itemID) && this.shearsList.contains(itemID);
        }
        return false;
    }

    public boolean isShears(ItemStack itemStack) {
        if (itemStack != null) {
            ItemID itemID = new ItemID(itemStack);
            return !this.blacklist.contains(itemID) && this.shearsList.contains(new ItemID(itemStack));
        }
        return false;
    }
}

