/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.crystalwing;

import bspkrs.crystalwing.CWSettings;
import bspkrs.util.CommonUtils;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum CWLog {
    INSTANCE;

    private Logger logger;

    public Logger getLogger() {
        if (this.logger == null) {
            this.init();
        }
        return this.logger;
    }

    private void init() {
        if (this.logger != null) {
            return;
        }
        this.logger = LogManager.getLogger((String)"CrystalWing");
    }

    public static void info(String format, Object ... args) {
        INSTANCE.log(Level.INFO, format, args);
    }

    public static void log(Level level, Throwable exception, String format, Object ... args) {
        INSTANCE.getLogger().log(level, String.format(format, args), exception);
    }

    public static void severe(String format, Object ... args) {
        INSTANCE.log(Level.ERROR, format, args);
    }

    public static void warning(String format, Object ... args) {
        INSTANCE.log(Level.WARN, format, args);
    }

    public static void config(String format, Object ... args) {
        if (CWSettings.allowDebugLogging) {
            INSTANCE.log(Level.INFO, format, args);
        }
    }

    public static void config(Property prop) {
        if (CWSettings.allowDebugLogging) {
            if (prop.isList()) {
                INSTANCE.log(Level.INFO, "%s: %s", prop.getName(), CommonUtils.stringArrayToString((String[])prop.getStringList(), (String)"; "));
            } else {
                INSTANCE.log(Level.INFO, "%s: %s", prop.getName(), prop.getString());
            }
        }
    }

    public static void configs(Configuration config, String category) {
        if (CWSettings.allowDebugLogging) {
            CWLog.config("Logging config category %s:", category);
            for (Property prop : config.getCategory(category).getValues().values()) {
                CWLog.config(prop);
            }
        }
    }

    private void log(Level level, String format, Object ... data) {
        this.getLogger().log(level, String.format(format, data));
    }

    public static void debug(String format, Object ... args) {
        if (CWSettings.allowDebugLogging) {
            CWLog.info("[DEBUG] " + format, args);
        }
    }
}

