/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mod.scf.content;

import edgarallen.mod.scf.config.Config;
import edgarallen.mod.scf.inventory.DualInventoryWrapper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraftforge.oredict.OreDictionary;

public class TileSuperCraftingFrame
extends TileEntity {
    public ItemStack[] stackList = new ItemStack[10];

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        NBTTagList list = data.func_150295_c("stackList", 10);
        this.stackList = new ItemStack[10];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            int slot = itemTag.func_74771_c("slot") & 0xFF;
            if (slot < 0 || slot >= this.stackList.length) continue;
            this.stackList[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        NBTTagList list = new NBTTagList();
        for (int slot = 0; slot < this.stackList.length; ++slot) {
            if (this.stackList[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("slot", (byte)slot);
            this.stackList[slot].func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a("stackList", (NBTBase)list);
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_145841_b(data);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, data);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public ItemStack getDisplayedItemStack() {
        return this.stackList[9];
    }

    public void craftStack(EntityPlayer player) {
        if (this.stackList[9] == null) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack result = this.stackList[9].func_77946_l();
            result.field_77994_a = result.func_77976_d();
            this.ejectItem(result);
            return;
        }
        IInventory inventory = this.getAttachedInventory();
        DualInventoryWrapper dualInventory = new DualInventoryWrapper(this.getAttachedInventory(), player.field_71071_by, this.getSide());
        int numCrafted = 0;
        block0: while (numCrafted < this.stackList[9].func_77976_d()) {
            ItemStack result;
            if (Config.checkInventory && inventory != null) {
                if (inventory instanceof ISidedInventory) {
                    ISidedInventory si = (ISidedInventory)inventory;
                    int[] slots = si.func_94128_d(this.getSide());
                    for (int i = 0; i < slots.length; ++i) {
                        ItemStack stack1 = si.func_70301_a(slots[i]);
                        if (!this.isMatchingItem(this.stackList[9], stack1)) continue;
                        ItemStack result2 = si.func_70298_a(slots[i], 1);
                        this.ejectItem(result2);
                        ++numCrafted;
                        continue block0;
                    }
                } else {
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack stack1 = inventory.func_70301_a(i);
                        if (!this.isMatchingItem(this.stackList[9], stack1)) continue;
                        ItemStack result3 = inventory.func_70298_a(i, 1);
                        this.ejectItem(result3);
                        ++numCrafted;
                        continue block0;
                    }
                }
            }
            if (!this.hasIngredients(player, dualInventory) || (result = this.doCraft(player, dualInventory)) == null) break;
            numCrafted += result.field_77994_a;
            this.ejectItem(result);
        }
    }

    public void craftItem(EntityPlayer player) {
        DualInventoryWrapper di;
        if (this.stackList[9] == null) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack result = this.stackList[9].func_77946_l();
            result.field_77994_a = 1;
            this.ejectItem(result);
            return;
        }
        IInventory inventory = this.getAttachedInventory();
        if (Config.checkInventory && inventory != null) {
            if (inventory instanceof ISidedInventory) {
                ISidedInventory si = (ISidedInventory)inventory;
                int[] slots = si.func_94128_d(this.getSide());
                for (int i = 0; i < slots.length; ++i) {
                    ItemStack stack = si.func_70301_a(slots[i]);
                    if (!this.isMatchingItem(this.stackList[9], stack)) continue;
                    ItemStack result = si.func_70298_a(slots[i], 1);
                    this.ejectItem(result);
                    return;
                }
            } else {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack1 = inventory.func_70301_a(i);
                    if (!this.isMatchingItem(this.stackList[9], stack1)) continue;
                    ItemStack result = inventory.func_70298_a(i, 1);
                    this.ejectItem(result);
                    return;
                }
            }
        }
        if (this.hasIngredients(player, di = new DualInventoryWrapper(inventory, player.field_71071_by, this.getSide()))) {
            this.ejectItem(this.doCraft(player, di));
        }
    }

    private boolean hasIngredients(EntityPlayer player, IInventory inventory) {
        int[] hitCount = new int[inventory.func_70302_i_()];
        for (int i = 0; i < 9; ++i) {
            if (this.stackList[i] == null) continue;
            boolean found = false;
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                ItemStack stack = inventory.func_70301_a(j);
                if (stack == null) continue;
                if (this.isStairsRecipe()) {
                    if (!this.isMatchingItem(this.stackList[i], stack) || hitCount[j] >= stack.field_77994_a || hitCount[j] >= stack.func_77976_d()) continue;
                    int n = j;
                    hitCount[n] = hitCount[n] + 1;
                    found = true;
                    break;
                }
                if (!this.isItemEquivalent(this.stackList[i], stack) || hitCount[j] >= stack.field_77994_a || hitCount[j] >= stack.func_77976_d()) continue;
                int n = j;
                hitCount[n] = hitCount[n] + 1;
                found = true;
                break;
            }
            if (found) continue;
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("scf.missing.ingredient", new Object[]{this.stackList[i].func_82833_r()}));
            return false;
        }
        return true;
    }

    private ItemStack doCraft(EntityPlayer player, IInventory inventory) {
        InventoryCrafting tempMatrix = this.getTempCraftingMatrix();
        InventoryCraftResult tempResult = new InventoryCraftResult();
        SlotCrafting slotCrafting = new SlotCrafting(player, (IInventory)tempMatrix, (IInventory)tempResult, 0, 0, 0);
        int[] binding = new int[9];
        block0: for (int i = 0; i < 9; ++i) {
            if (this.stackList[i] == null) {
                binding[i] = -1;
                continue;
            }
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                ItemStack stack = inventory.func_70301_a(j);
                if (stack == null) continue;
                if (this.isStairsRecipe()) {
                    if (!this.isMatchingItem(this.stackList[i], stack)) continue;
                    binding[i] = j;
                    tempMatrix.func_70299_a(i, inventory.func_70298_a(j, 1));
                    inventory.func_70296_d();
                    continue block0;
                }
                if (!this.isItemEquivalent(this.stackList[i], stack)) continue;
                binding[i] = j;
                tempMatrix.func_70299_a(i, inventory.func_70298_a(j, 1));
                inventory.func_70296_d();
                continue block0;
            }
        }
        ItemStack result = this.findMatchingRecipe(tempMatrix);
        if (result != null) {
            slotCrafting.func_82870_a(player, result);
            for (int i = 0; i < 9; ++i) {
                ItemStack tempMatrixStack = tempMatrix.func_70301_a(i);
                if (tempMatrixStack == null) continue;
                tempMatrix.func_70299_a(i, null);
                ItemStack stack = inventory.func_70301_a(binding[i]);
                if (stack == null) {
                    inventory.func_70299_a(binding[i], tempMatrixStack);
                    continue;
                }
                this.ejectItem(tempMatrixStack);
            }
        }
        player.field_71069_bz.func_75142_b();
        return result;
    }

    private void ejectItem(ItemStack stack) {
        if (stack != null && stack.field_77994_a != 0) {
            Vec3 position = this.field_145850_b.func_82732_R().func_72345_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
            Vec3 velocity = this.field_145850_b.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
            switch (this.getSide()) {
                case 0: {
                    position.field_72448_b += 0.25;
                    velocity.field_72448_b = -0.2;
                    break;
                }
                case 1: {
                    position.field_72448_b -= 0.25;
                    velocity.field_72448_b = 0.2;
                    break;
                }
                case 2: {
                    position.field_72449_c += 0.25;
                    position.field_72448_b -= 0.25;
                    velocity.field_72449_c = -0.2;
                    break;
                }
                case 3: {
                    position.field_72449_c -= 0.25;
                    position.field_72448_b -= 0.25;
                    velocity.field_72449_c = 0.2;
                    break;
                }
                case 4: {
                    position.field_72450_a += 0.25;
                    position.field_72448_b -= 0.25;
                    velocity.field_72450_a = -0.2;
                    break;
                }
                case 5: {
                    position.field_72450_a -= 0.25;
                    position.field_72448_b -= 0.25;
                    velocity.field_72450_a = 0.2;
                    break;
                }
            }
            EntityItem item = new EntityItem(this.field_145850_b, position.field_72450_a, position.field_72448_b, position.field_72449_c, stack);
            item.field_70159_w = velocity.field_72450_a;
            item.field_70181_x = velocity.field_72448_b;
            item.field_70179_y = velocity.field_72449_c;
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    private boolean isItemEquivalent(ItemStack base, ItemStack comparison) {
        int idComp;
        if (this.isMatchingItem(base, comparison)) {
            return true;
        }
        int idBase = OreDictionary.getOreID((ItemStack)base);
        return idBase >= 0 && (idComp = OreDictionary.getOreID((ItemStack)comparison)) >= 0 && idBase == idComp;
    }

    private boolean isMatchingItem(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (base.func_77973_b().func_77614_k() && base.func_77960_j() != Short.MAX_VALUE && base.func_77960_j() != comparison.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)base, (ItemStack)comparison);
    }

    public int getSide() {
        return this.func_145832_p() & 7;
    }

    private IInventory getAttachedInventory() {
        TileEntity tile = null;
        switch (this.getSide()) {
            case 0: {
                tile = this.func_145831_w().func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                break;
            }
            case 1: {
                tile = this.func_145831_w().func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                break;
            }
            case 2: {
                tile = this.func_145831_w().func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                break;
            }
            case 3: {
                tile = this.func_145831_w().func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                break;
            }
            case 4: {
                tile = this.func_145831_w().func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 5: {
                tile = this.func_145831_w().func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                break;
            }
        }
        if (tile != null && tile instanceof IInventory) {
            return this.getFullInventory((IInventory)tile);
        }
        return null;
    }

    private IInventory getFullInventory(IInventory inv) {
        if (!(inv instanceof TileEntityChest)) {
            return inv;
        }
        TileEntityChest chest = (TileEntityChest)inv;
        TileEntityChest adjacent = null;
        if (chest.field_145991_k != null) {
            adjacent = chest.field_145991_k;
        }
        if (chest.field_145990_j != null) {
            adjacent = chest.field_145990_j;
        }
        if (chest.field_145992_i != null) {
            adjacent = chest.field_145992_i;
        }
        if (chest.field_145988_l != null) {
            adjacent = chest.field_145988_l;
        }
        return adjacent == null ? inv : new InventoryLargeChest("", inv, (IInventory)adjacent);
    }

    private ItemStack findMatchingRecipe(InventoryCrafting craftMatrix) {
        return CraftingManager.func_77594_a().func_82787_a(craftMatrix, this.field_145850_b);
    }

    private InventoryCrafting getTempCraftingMatrix() {
        InventoryCrafting tempMatrix = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer entityplayer) {
                return true;
            }
        }, 3, 3);
        return tempMatrix;
    }

    private boolean isStairsRecipe() {
        return this.stackList[9] != null && (this.stackList[9].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150476_ad) || this.stackList[9].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150400_ck) || this.stackList[9].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150487_bG) || this.stackList[9].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150401_cl) || this.stackList[9].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150481_bH) || this.stackList[9].func_77973_b() == Item.func_150898_a((Block)Blocks.field_150485_bF));
    }
}

