/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.SMCLog;
import shadersmodcore.transform.SMCRemap;

public class SMCCTTextureDownload
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String nameM = SMCRemap.remapper.mapMethodName(this.classname, name, desc);
            if (nameM.equals("getMultiTexID")) {
                return null;
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            MethodVisitor mv = SMCRemap.getAdaptor(this.cv.visitMethod(1, "getMultiTexID", "()Lshadersmodcore/client/MultiTexID;", null, null));
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "net/minecraft/client/renderer/ThreadDownloadImageData", "field_110559_g", "Z");
            Label l1 = new Label();
            mv.visitJumpInsn(154, l1);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "net/minecraft/client/renderer/ThreadDownloadImageData", "func_110552_b", "()I");
            mv.visitInsn(87);
            mv.visitLabel(l1);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "net/minecraft/client/renderer/texture/AbstractTexture", "getMultiTexID", "()Lshadersmodcore/client/MultiTexID;");
            mv.visitInsn(176);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("this", "Lnet/minecraft/client/renderer/ThreadDownloadImageData;", null, l0, l3, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            this.cv.visitEnd();
        }
    }
}

