/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.worldstatecheckpoints;

import bspkrs.helpers.client.MinecraftHelper;
import bspkrs.helpers.client.gui.GuiScreenWrapper;
import bspkrs.worldstatecheckpoints.CheckpointManager;
import bspkrs.worldstatecheckpoints.GuiCheckpointsMenu;
import bspkrs.worldstatecheckpoints.GuiDeleteCheckpointYesNo;
import bspkrs.worldstatecheckpoints.WSCSettings;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;

public class GuiLoadCheckpoint
extends GuiScreenWrapper {
    String guiTitle = StatCollector.func_74838_a((String)"wsc.loadCheckpoint.title");
    String guiSubTitle = StatCollector.func_74838_a((String)"wsc.loadCheckpoint.title2");
    protected boolean showDelButtons = true;
    private boolean gameOverScreen = false;
    private GuiButton[] buttons;
    private GuiButton[] delButtons;
    protected String[] dirNames;
    private int[] pageNums;
    private int pages = 0;
    protected int currentPage = 0;
    protected int startPage = 0;
    protected CheckpointManager cpm;
    private GuiButton back;
    private GuiButton prev;
    private GuiButton next;
    private GuiButton switchLoad;
    protected boolean isAutoCheckpointsLoad;

    public GuiLoadCheckpoint(CheckpointManager cpm, boolean gameover, boolean isAutoCheckpointsLoad) {
        this.cpm = cpm;
        this.gameOverScreen = gameover;
        this.isAutoCheckpointsLoad = isAutoCheckpointsLoad;
    }

    public GuiLoadCheckpoint() {
        this.gameOverScreen = false;
        this.isAutoCheckpointsLoad = false;
    }

    public void func_73866_w_() {
        this.buttonList().clear();
        int byte0 = -16;
        int prevX = this.width() / 2 - 70 - 60 - 3;
        int backX = this.width() / 2 - 70 - 1;
        int switchX = this.width() / 2 + 1;
        int nextX = this.width() / 2 + 70 + 3;
        if (this.isAutoCheckpointsLoad) {
            this.guiTitle = StatCollector.func_74838_a((String)"wsc.loadCheckpoint.titleAutoSaves");
            this.switchLoad = new GuiButton(-4, switchX, this.height() / 4 + 24 + byte0, 70, 20, StatCollector.func_74838_a((String)"wsc.loadCheckpoint.checkpoints"));
        } else {
            this.switchLoad = new GuiButton(-4, switchX, this.height() / 4 + 24 + byte0, 70, 20, StatCollector.func_74838_a((String)"wsc.loadCheckpoint.autoSaves"));
        }
        this.switchLoad.field_146124_l = this.cpm.getHasCheckpoints(!this.isAutoCheckpointsLoad);
        this.prev = new GuiButton(-2, prevX, this.height() / 4 + 24 + byte0, 60, 20, "<<<");
        this.back = new GuiButton(-1, backX, this.height() / 4 + 24 + byte0, 70, 20, StatCollector.func_74838_a((String)"gui.back"));
        this.next = new GuiButton(-3, nextX, this.height() / 4 + 24 + byte0, 60, 20, ">>>");
        this.field_146292_n.add(this.back);
        this.field_146292_n.add(this.switchLoad);
        this.field_146292_n.add(this.prev);
        this.field_146292_n.add(this.next);
        File[] files = this.cpm.getCheckpoints(this.isAutoCheckpointsLoad);
        this.dirNames = new String[files.length];
        this.pageNums = new int[files.length];
        this.buttons = new GuiButton[files.length];
        this.delButtons = new GuiButton[files.length];
        int page = 0;
        int pagecounter = -1;
        int index = -1;
        for (File file : files) {
            String label;
            if (!file.isDirectory()) continue;
            try {
                label = file.getName().split("!", 2)[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                label = file.getName();
            }
            ++index;
            if (++pagecounter >= 5) {
                pagecounter = 0;
            }
            GuiButton btn = new GuiButton(index, this.width() / 2 - 100, this.height() / 4 + 48 + 6 + 23 * pagecounter + byte0, label);
            this.field_146292_n.add(btn);
            GuiButton delbtn = new GuiButton(index + 1000, this.width() / 2 + 100 + 4, this.height() / 4 + 48 + 6 + 23 * pagecounter + byte0, 20, 20, "X");
            this.field_146292_n.add(delbtn);
            this.dirNames[index] = file.getName();
            this.pageNums[index] = ++page;
            this.buttons[index] = btn;
            this.delButtons[index] = delbtn;
        }
        this.pages = page;
        this.currentPage = this.startPage;
        this.showPage(this.currentPage);
    }

    void showPage(int page) {
        this.currentPage = page;
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        if (this.currentPage > this.pages) {
            this.currentPage = this.pages;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].field_146125_m = this.pageNums[i] == page;
            this.delButtons[i].field_146125_m = this.pageNums[i] == page && this.showDelButtons;
        }
        this.prevNextDisableIfNeeded();
    }

    private void prevNextDisableIfNeeded() {
        this.prev.field_146124_l = this.currentPage > 0;
        this.next.field_146124_l = this.currentPage < this.pages;
    }

    private void goPrev() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.showPage(this.currentPage);
        }
    }

    private void goNext() {
        if (this.currentPage < this.pages) {
            ++this.currentPage;
            this.showPage(this.currentPage);
        }
    }

    protected void checkpointButtonClicked(int index) {
        String dirname = this.dirNames[index];
        this.cpm.loadCheckpoint(dirname, this.isAutoCheckpointsLoad);
        MinecraftHelper.displayGuiScreen((Minecraft)WSCSettings.mc, null);
        WSCSettings.mc.func_71381_h();
        WSCSettings.justLoadedCheckpoint = true;
        WSCSettings.loadMessage = StatCollector.func_74837_a((String)"wsc.chatMessage.loadedCheckpoint", (Object[])new Object[]{dirname.split("!", 2)[1]});
    }

    protected void delButtonClicked(int index) {
        MinecraftHelper.displayGuiScreen((Minecraft)WSCSettings.mc, (GuiScreen)new GuiDeleteCheckpointYesNo(this.cpm, this, this.dirNames[index], this.currentPage, this.isAutoCheckpointsLoad));
    }

    protected void backButtonClicked() {
        MinecraftHelper.displayGuiScreen((Minecraft)WSCSettings.mc, (GuiScreen)(this.gameOverScreen ? new GuiGameOver() : new GuiCheckpointsMenu(this.cpm)));
    }

    protected void switchButtonClicked() {
        MinecraftHelper.displayGuiScreen((Minecraft)WSCSettings.mc, (GuiScreen)new GuiLoadCheckpoint(this.cpm, this.gameOverScreen, !this.isAutoCheckpointsLoad));
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        switch (guibutton.field_146127_k) {
            case -1: {
                this.backButtonClicked();
                return;
            }
            case -2: {
                this.goPrev();
                return;
            }
            case -3: {
                this.goNext();
                return;
            }
            case -4: {
                this.switchButtonClicked();
                return;
            }
        }
        if (guibutton.field_146127_k >= 1000) {
            this.delButtonClicked(guibutton.field_146127_k - 1000);
        } else {
            this.checkpointButtonClicked(guibutton.field_146127_k);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        if (this.guiSubTitle == null || this.gameOverScreen && WSCSettings.mc.field_71441_e.func_72912_H().func_76093_s()) {
            this.func_73732_a(this.field_146289_q, this.guiTitle, this.width() / 2, 55, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, this.guiSubTitle, this.width() / 2, 55, 0xEE0000);
            this.func_73732_a(this.field_146289_q, this.guiTitle, this.width() / 2, 39, 0xFFFFFF);
        }
        super.func_73863_a(par1, par2, par3);
    }
}

