/*
 * Decompiled with CFR 0.152.
 */
package DamageIndicatorsMod.core;

import DamageIndicatorsMod.DIMod;
import DamageIndicatorsMod.configuration.DIConfig;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class EntityConfigurationEntry {
    public static HashMap<Integer, Integer> maxHealthOverride = new HashMap(200);
    private static boolean lasttimefailed = false;
    public final boolean AppendBaby;
    public final float BabyScaleFactor;
    public final Class Clazz;
    public final float EntitySizeScaling;
    public float eyeHeight;
    public final boolean IgnoreThisMob;
    public int maxHP;
    public final String NameOverride;
    public final float ScaleFactor;
    public final float XOffset;
    public final float YOffset;

    public void save() {
        EntityConfigurationEntry.saveEntityConfig(this);
    }

    public static EntityConfigurationEntry generateDefaultConfiguration(Configuration config, Class entry) {
        boolean ignore = false;
        boolean appendBabyName = true;
        float scaleFactor = 22.0f;
        float xOffset = 0.0f;
        float yOffset = -5.0f;
        float SizeModifier = 0.0f;
        float BabyScaleFactor = 2.0f;
        if (entry == EntityIronGolem.class) {
            scaleFactor = 16.0f;
        } else if (entry == EntitySlime.class || entry == EntityMagmaCube.class) {
            scaleFactor = 5.0f;
            SizeModifier = 2.0f;
            yOffset = -5.0f;
        } else if (entry == EntityEnderman.class) {
            scaleFactor = 15.0f;
        } else if (entry == EntityGhast.class) {
            scaleFactor = 7.0f;
            yOffset = -20.0f;
        } else if (entry == EntitySquid.class) {
            yOffset = -17.0f;
        } else if (entry == EntityOcelot.class) {
            scaleFactor = 25.0f;
            yOffset = -5.0f;
        } else if (entry == EntityWither.class) {
            scaleFactor = 15.0f;
            yOffset = 5.0f;
        } else if (entry.getName().equalsIgnoreCase("thaumcraft.common.entities.EntityWisp")) {
            yOffset = -14.0f;
        } else if (entry.getName().equalsIgnoreCase("drzhark.mocreatures.MoCEntityWerewolf")) {
            scaleFactor = 20.0f;
            yOffset = -4.0f;
        } else if (entry.getName().equalsIgnoreCase("drzhark.mocreatures.MoCEntityOgre")) {
            scaleFactor = 12.0f;
        } else if (entry.getName().equalsIgnoreCase("xolova.blued00r.divinerpg.mobs.EntityCyclops")) {
            scaleFactor = 10.0f;
        } else if (entry.getName().equalsIgnoreCase("xolova.blued00r.divinerpg.mobs.EntityEnergyGolem")) {
            scaleFactor = 10.0f;
        } else if (entry.getName().equalsIgnoreCase("xolova.blued00r.divinerpg.mobs.EntityCaveclops")) {
            scaleFactor = 10.0f;
        } else if (EntityList.field_75626_c.get(entry) != null && ((String)EntityList.field_75626_c.get(entry)).equalsIgnoreCase("Linkbook")) {
            ignore = true;
        } else if (Loader.isModLoaded((String)"RDVehicleTools")) {
            try {
                Class<?> clazz = Class.forName("net.richdigitsmods.vehiclecore.vehicles.EntityVehicleCore");
                if (clazz.isAssignableFrom(entry)) {
                    ignore = true;
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return EntityConfigurationEntry.loadEntityConfig(config, new EntityConfigurationEntry(entry, scaleFactor, xOffset, yOffset, SizeModifier, BabyScaleFactor, appendBabyName, "", ignore, 20, 1.5f));
    }

    public static EntityConfigurationEntry loadEntityConfig(Configuration config, EntityConfigurationEntry ece) {
        return EntityConfigurationEntry.loadEntityConfig(config, ece, null);
    }

    public static EntityConfigurationEntry loadEntityConfig(Configuration config, EntityConfigurationEntry ece, EntityLiving el) {
        float babyScaleFactor;
        float SizeModifier;
        float yOffset;
        float xOffset;
        float scaleFactor;
        String CatagoryName;
        Class entry = ece.Clazz;
        String mod = "Vanilla";
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(ece.Clazz, true);
        if (er != null) {
            try {
                mod = er.getContainer().getMetadata().name.replaceAll(Pattern.quote("."), "");
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if ((CatagoryName = EntityList.field_75626_c.containsKey(entry) ? StatCollector.func_74838_a((String)((String)EntityList.field_75626_c.get(entry))) : entry.getName()).lastIndexOf(".") != -1) {
            CatagoryName = CatagoryName.substring(CatagoryName.lastIndexOf("."), CatagoryName.length());
            CatagoryName = CatagoryName.replaceAll(Pattern.quote("."), "");
        }
        CatagoryName = mod + "." + CatagoryName;
        CatagoryName = CatagoryName.replaceAll("[^a-zA-Z0-9\\s\\!\\:\\.\\&\\$]", "");
        config.addCustomCategoryComment(CatagoryName, "These settings are to help other modders and users to make custom mobs fit correctly in the preview window.");
        Property prop = config.get(CatagoryName, "Scale_Factor", String.valueOf(ece.ScaleFactor));
        prop.comment = "How much to upscale the mob. 0 will cause it to disappear entirely. 22 is OK for most mobs";
        try {
            scaleFactor = Float.valueOf(prop.getString()).floatValue();
        }
        catch (Throwable ex) {
            System.err.println("Invalid or malformed configuration entry for " + prop.getName());
            scaleFactor = ece.ScaleFactor;
            prop.set(String.valueOf(22.0f));
        }
        prop = config.get(CatagoryName, "Name", "");
        prop.comment = "Entities Name to use if overriden.";
        String entityName = prop.getString();
        prop = config.get(CatagoryName, "Append_Baby_Name", ece.AppendBaby);
        prop.comment = "Append Baby to this entity type if it is a baby.";
        boolean appendBabyName = prop.getBoolean(ece.AppendBaby);
        prop = config.get(CatagoryName, "Ignore_This_Mob", ece.IgnoreThisMob);
        prop.comment = "Should the portrait display should ignore this entity entirely?";
        boolean ignore = prop.getBoolean(ece.IgnoreThisMob);
        prop = config.get(CatagoryName, "X_Offset", String.valueOf(ece.XOffset));
        prop.comment = "How much to nudge the mob display horizontally. 0 is default, negative numbers to move left, positive for right.";
        try {
            xOffset = Float.valueOf(prop.getString()).floatValue();
        }
        catch (Throwable ex) {
            System.err.println("Invalid or malformed configuration entry for " + prop.getName());
            prop.set(String.valueOf(ece.XOffset));
            xOffset = ece.XOffset;
        }
        prop = config.get(CatagoryName, "Y_Offset", String.valueOf(ece.YOffset));
        prop.comment = "How much to nudge the mob display vertically. 0 is default, negative numbers to move up, positive for down.";
        try {
            yOffset = Float.valueOf(prop.getString()).floatValue();
        }
        catch (Throwable ex) {
            System.err.println("Invalid or malformed configuration entry for " + prop.getName());
            prop.set(String.valueOf(ece.YOffset));
            yOffset = ece.YOffset;
        }
        prop = config.get(CatagoryName, "Size_Modifier", String.valueOf(ece.EntitySizeScaling));
        prop.comment = "If and how much to scale the mob is it has a size modifier(like slimes)";
        try {
            SizeModifier = Float.valueOf(prop.getString()).floatValue();
        }
        catch (Throwable ex) {
            System.err.println("Invalid or malformed configuration entry for " + prop.getName());
            prop.set(String.valueOf(ece.EntitySizeScaling));
            SizeModifier = ece.EntitySizeScaling;
        }
        prop = config.get(CatagoryName, "Baby_Scale_Modifier", (double)ece.BabyScaleFactor);
        prop.comment = "If and how much to scale the mob is a baby.";
        try {
            babyScaleFactor = Float.valueOf(prop.getString()).floatValue();
        }
        catch (Throwable ex) {
            System.err.println("Invalid or malformed configuration entry for " + prop.getName());
            prop.set(String.valueOf(ece.BabyScaleFactor));
            babyScaleFactor = ece.BabyScaleFactor;
        }
        EntityConfigurationEntry tmp = new EntityConfigurationEntry(entry, scaleFactor, xOffset, yOffset, SizeModifier, babyScaleFactor, appendBabyName, entityName, ignore, ece.maxHP, ece.eyeHeight);
        return tmp;
    }

    public static Configuration getEntityConfiguration() {
        File configfile = new File(DIConfig.mainInstance().CONFIG_FILE.getParentFile(), "DIAdvancedCompatibility.cfg");
        try {
            configfile.createNewFile();
            return new Configuration(configfile);
        }
        catch (Exception e) {
            if (configfile.exists()) {
                if (!lasttimefailed) {
                    DIMod.log.warn("Per mob configuration file was corrupt! Attempting to purge and recreate...");
                    if (!configfile.delete()) {
                        configfile.deleteOnExit();
                    }
                    lasttimefailed = true;
                    return EntityConfigurationEntry.getEntityConfiguration();
                }
                DIMod.log.warn("Failed to recreate configuration! Configuration should be deleted when minecraft closes.");
                throw new RuntimeException("DIAdvancedCompatibility was currupt and was unable to recreate the file.");
            }
            throw new RuntimeException("Exception while creating " + configfile.getAbsolutePath(), e);
        }
    }

    public static void saveEntityConfig(EntityConfigurationEntry ece) {
        String CatagoryName;
        Class entry = ece.Clazz;
        String mod = "Vanilla";
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(ece.Clazz, true);
        if (er != null) {
            try {
                mod = er.getContainer().getMetadata().name.replaceAll(Pattern.quote("."), "_");
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if ((CatagoryName = EntityList.field_75626_c.containsKey(entry) ? StatCollector.func_74838_a((String)((String)EntityList.field_75626_c.get(entry))) : entry.getName()).lastIndexOf(".") != -1) {
            CatagoryName = CatagoryName.substring(CatagoryName.lastIndexOf("."), CatagoryName.length());
            CatagoryName = CatagoryName.replaceAll(Pattern.quote("."), "");
        }
        CatagoryName = mod + "." + CatagoryName;
        CatagoryName = CatagoryName.replaceAll("[^a-zA-Z0-9\\s\\!\\:\\.\\&\\$]", "");
        Configuration config = EntityConfigurationEntry.getEntityConfiguration();
        config.addCustomCategoryComment(CatagoryName, "These settings are to help other modders and users to make custom mobs fit correctly in the preview window.");
        config.get(CatagoryName, "Scale_Factor", String.valueOf(ece.ScaleFactor)).set(String.valueOf(ece.ScaleFactor));
        if (ece.NameOverride == null || "".equals(ece.NameOverride)) {
            config.get(CatagoryName, "Name", ece.NameOverride).set("");
        } else {
            config.get(CatagoryName, "Name", ece.NameOverride).set(ece.NameOverride);
        }
        config.get(CatagoryName, "Ignore_This_Mob", ece.IgnoreThisMob).set(ece.IgnoreThisMob);
        config.get(CatagoryName, "Append_Baby_Name", ece.AppendBaby).set(ece.AppendBaby);
        config.get(CatagoryName, "X_Offset", String.valueOf(ece.XOffset)).set((double)ece.XOffset);
        config.get(CatagoryName, "Y_Offset", String.valueOf(ece.YOffset)).set((double)ece.YOffset);
        config.get(CatagoryName, "Size_Modifier", String.valueOf(ece.EntitySizeScaling)).set((double)ece.EntitySizeScaling);
        config.get(CatagoryName, "Baby_Scale_Modifier", String.valueOf(ece.BabyScaleFactor)).set((double)ece.BabyScaleFactor);
        config.save();
    }

    public EntityConfigurationEntry(Class clazz, float scale, float xoffset, float yoffset, float sizeScaling, float babyscale, boolean appendBaby, boolean ignoreThisMob, int maxHP, float eyeHeight) {
        this(clazz, scale, xoffset, yoffset, sizeScaling, babyscale, appendBaby, "", ignoreThisMob, maxHP, eyeHeight);
    }

    public EntityConfigurationEntry(Class clazz, float scale, float xoffset, float yoffset, float sizeScaling, float babyscale, boolean appendBaby, String nameOverride, boolean ignoreThisMob, int maxHP, float eyeHeight) {
        this.IgnoreThisMob = ignoreThisMob;
        this.Clazz = clazz;
        this.ScaleFactor = scale;
        this.XOffset = xoffset;
        this.YOffset = yoffset;
        this.EntitySizeScaling = sizeScaling;
        this.BabyScaleFactor = babyscale;
        this.AppendBaby = appendBaby;
        this.NameOverride = nameOverride != null ? nameOverride : "";
        this.maxHP = maxHP;
        this.eyeHeight = eyeHeight;
    }

    public boolean equals(Object obj) {
        return obj.toString().intern() == this.toString().intern();
    }

    public void SetInfo(int maxh, float eyeh) {
        this.maxHP = maxh;
        this.eyeHeight = eyeh;
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append(eol).append("---------------------------------").append(eol).append("Class Name: ").append(this.Clazz.getName()).append(eol).append("ScaleFactor: ").append(String.valueOf(this.ScaleFactor)).append(eol).append("Name Override: ").append(this.NameOverride).append(eol).append("AppendBabyName: ").append(String.valueOf(this.AppendBaby)).append(eol).append("X Offset: ").append(String.valueOf(this.XOffset)).append(eol).append("Y Offset: ").append(String.valueOf(this.YOffset)).append(eol).append("Size Modifier: ").append(String.valueOf(this.EntitySizeScaling)).append(eol).append("Baby Scale Modifier: ").append(String.valueOf(this.BabyScaleFactor)).append(eol).append("Ignored: ").append(String.valueOf(this.IgnoreThisMob)).append(eol).append("---------------------------------").append(eol);
        return output.toString();
    }
}

