/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.editor.EditorFieldListener;

public abstract class EditorHandler
implements Blockable {
    private final String path;
    private String value;
    private final List<EditorFieldListener> listeners;

    public EditorHandler(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public boolean addListener(EditorFieldListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.add(listener);
    }

    public boolean removeListener(EditorFieldListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.remove(listener);
    }

    public void onChange(String newvalue) {
        for (EditorFieldListener listener : this.listeners) {
            listener.onChange(this, this.value, newvalue);
        }
        this.value = newvalue;
    }

    public String getPath() {
        return this.path;
    }

    public void updateValue(Object obj) {
        String val = obj == null ? null : obj.toString();
        this.onChange(val);
        this.setValue0(this.value);
    }

    public void setValue(Object obj) {
        String val = obj == null ? null : obj.toString();
        this.setValue0(val);
    }

    public abstract boolean isValid();

    public abstract JComponent getComponent();

    public abstract String getValue();

    protected abstract void setValue0(String var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{path='" + this.path + "', value='" + this.value + "'}";
    }
}

