/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.nio.file.Files;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tlauncher.tlauncher.controller.UpdaterFormController;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.DownloaderListener;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.listener.UpdateUIListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.swing.ImagePanel;
import org.tlauncher.tlauncher.updater.client.AutoUpdater;
import org.tlauncher.tlauncher.updater.client.Update;
import org.tlauncher.tlauncher.updater.client.UpdateListener;
import org.tlauncher.tlauncher.updater.client.Updater;
import org.tlauncher.tlauncher.updater.client.UpdaterListener;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class AutoUpdaterFrame
extends JFrame
implements DownloaderListener,
UpdaterListener,
UpdateListener {
    private static final long serialVersionUID = -1184260781662212096L;
    private static final int ANIMATION_TICK = 1;
    private static final double OPACITY_STEP = 0.005;
    private final AutoUpdaterFrame instance;
    private final Color border = new Color(255, 255, 255, 255);
    private final JPanel titlepan;
    private final JPanel pan;
    private final LocalizableLabel label;
    private final ImagePanel hide;
    private final ImagePanel skip;
    private final Object animationLock;
    private boolean closed;
    private boolean canSkip;

    public AutoUpdaterFrame(AutoUpdater updater) {
        this.instance = this;
        this.animationLock = new Object();
        this.setPreferredSize(new Dimension(350, 60));
        this.setResizable(false);
        this.setUndecorated(true);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setDefaultCloseOperation(3);
        this.pan = new JPanel(){
            private static final long serialVersionUID = -8469500310564854471L;
            protected final Insets insets = new Insets(5, 10, 10, 10);
            protected final Color background = new Color(255, 255, 255, 220);

            @Override
            public void paintComponent(Graphics g0) {
                Graphics2D g = (Graphics2D)g0;
                int arc = 16;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(this.background);
                g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arc, arc);
                g.setColor(AutoUpdaterFrame.this.border);
                for (int x = 1; x < 2; ++x) {
                    g.drawRoundRect(x - 1, x - 1, this.getWidth() - 2 * x + 1, this.getHeight() - 2 * x + 1, arc, arc);
                }
                Color shadow = U.shiftAlpha(Color.gray, -200);
                int x = 2;
                while ((shadow = U.shiftAlpha(shadow, -8)).getAlpha() != 0) {
                    g.setColor(shadow);
                    g.drawRoundRect(x - 1, x - 1, this.getWidth() - 2 * x + 1, this.getHeight() - 2 * x + 1, arc - 2 * x + 1, arc - 2 * x + 1);
                    ++x;
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                super.paintComponent(g0);
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.pan.setOpaque(false);
        this.pan.setLayout(new BorderLayout());
        this.add(this.pan);
        this.titlepan = new JPanel();
        this.titlepan.setOpaque(false);
        this.titlepan.setLayout(new FlowLayout(2));
        this.hide = new ImagePanel("hide.png", 0.75f, 0.5f, false){
            private static final long serialVersionUID = 513294577418505533L;

            @Override
            protected boolean onClick() {
                if (!super.onClick()) {
                    return false;
                }
                AutoUpdaterFrame.this.instance.setExtendedState(1);
                return true;
            }
        };
        this.hide.setToolTipText(Localizable.get("autoupdater.buttons.hide"));
        this.titlepan.add(this.hide);
        this.skip = new ImagePanel("skip.png", 0.75f, 0.5f, false){
            private static final long serialVersionUID = 513294577418505533L;

            @Override
            protected boolean onClick() {
                if (!super.onClick() || !AutoUpdaterFrame.this.canSkip) {
                    return false;
                }
                AutoUpdaterFrame.this.handleClose();
                return true;
            }
        };
        this.pan.add("East", this.titlepan);
        this.label = new LocalizableLabel("autoupdater.preparing");
        this.label.setOpaque(false);
        this.pan.add("West", this.label);
        this.setCanSkip(true);
        updater.getLauncher().getDownloader().addListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
        this.requestFocusInWindow();
    }

    private void hideButtons() {
        this.skip.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFrame() {
        if (this.closed) {
            this.dispose();
        } else {
            float opacity = 1.0f;
            Object object = this.animationLock;
            synchronized (object) {
                try {
                    this.setOpacity(opacity);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                while (opacity > 0.0f) {
                    if ((opacity = (float)((double)opacity - 0.005)) < 0.0f) {
                        opacity = 0.0f;
                    }
                    try {
                        this.setOpacity(opacity);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    U.sleepFor(1L);
                }
                this.dispose();
            }
        }
        this.closed = true;
    }

    public boolean canSkip() {
        return this.canSkip;
    }

    private void setCanSkip(boolean b) {
        this.canSkip = b;
        if (!b) {
            this.hideButtons();
        }
    }

    private void handleClose() {
        this.label.setText("autoupdater.opening", TLauncher.getVersion());
        this.closeFrame();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void onUpdateError(Update u, Throwable e) {
        if (this.closed) {
            return;
        }
        if (!Files.isWritable(FileUtil.getRunningJar().getParentFile().toPath())) {
            if (Alert.showErrorMessage("updater.error.title", "updater.access.denied.message", "updater.button.download.handle", "review.button.close") == 0) {
                OS.openLink(OS.is(OS.WINDOWS) ? u.getExeLinks().get(0) : u.getJarLinks().get(0));
            }
            TLauncher.kill();
        } else if (Alert.showLocQuestion("updater.error.title", "updater.download-error", e)) {
            UpdateUIListener.openUpdateLink(u.getlastDownloadedLink());
        }
        this.handleClose();
    }

    @Override
    public void onUpdateDownloading(Update u) {
        this.label.setText("autoupdater.downloading", u.getVersion());
    }

    @Override
    public void onUpdateDownloadError(Update u, Throwable e) {
        this.onUpdateError(u, e);
    }

    @Override
    public void onUpdateReady(Update u) {
        this.setCanSkip(true);
    }

    @Override
    public void onUpdateApplying(Update u) {
    }

    @Override
    public void onUpdateApplyError(Update u, Throwable e) {
        if (Alert.showLocQuestion("updater.save-error", e)) {
            UpdateUIListener.openUpdateLink(u.getlastDownloadedLink());
        }
    }

    @Override
    public void onUpdaterRequesting(Updater u) {
        this.label.setText("autoupdater.requesting");
    }

    @Override
    public void onUpdaterErrored(Updater.SearchFailed failed) {
        this.handleClose();
    }

    @Override
    public void onUpdaterSucceeded(Updater.SearchSucceeded succeeded) {
        Update update = succeeded.getResponse();
        if (!FileUtil.checkFreeSpace(FileUtil.getRunningJar(), FileUtil.SIZE_100) && update.isApplicable()) {
            this.showSpaceMessage(update);
            update.setFreeSpaceEnough(false);
        }
        if (update.isApplicable()) {
            UpdaterFormController controller = new UpdaterFormController(update, TLauncher.getInstance().getConfiguration());
            update.setUserChoose(controller.getResult());
        }
        if (update.isApplicable()) {
            update.addListener(this);
        } else {
            this.label.setText("autoupdater.opening");
            this.handleClose();
        }
    }

    private void showSpaceMessage(Update update) {
        Alert.showMessage(Localizable.get("launcher.update.title"), Localizable.get("launcher.update.no.space").replace("disk", FileUtil.getRunningJar().toPath().getRoot().toString()));
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        this.setCanSkip(false);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed, double alreadyDownloaded) {
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
    }
}

