/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.component;

import java.util.concurrent.Semaphore;
import org.tlauncher.tlauncher.component.RefreshableComponent;
import org.tlauncher.tlauncher.managers.ComponentManager;

public abstract class InterruptibleComponent
extends RefreshableComponent {
    protected final boolean[] refreshList;
    private int lastRefreshID;
    protected final Semaphore semaphore = new Semaphore(1);
    protected boolean lastResult;

    protected InterruptibleComponent(ComponentManager manager) throws Exception {
        this(manager, 64);
    }

    private InterruptibleComponent(ComponentManager manager, int listSize) throws Exception {
        super(manager);
        if (listSize < 1) {
            throw new IllegalArgumentException("Invalid list size: " + listSize + " < 1");
        }
        this.refreshList = new boolean[listSize];
    }

    @Override
    public final boolean refresh() {
        if (this.semaphore.tryAcquire()) {
            try {
                boolean bl = this.lastResult = this.refresh(this.nextID());
                return bl;
            }
            finally {
                this.semaphore.release();
            }
        }
        try {
            this.semaphore.acquire();
            boolean bl = this.lastResult;
            return bl;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.semaphore.release();
        }
    }

    public synchronized void stopRefresh() {
        for (int i = 0; i < this.refreshList.length; ++i) {
            this.refreshList[i] = false;
        }
    }

    protected synchronized int nextID() {
        int next;
        int listSize = this.refreshList.length;
        if ((next = this.lastRefreshID++) >= listSize) {
            next = 0;
        }
        this.lastRefreshID = next;
        return next;
    }

    protected boolean isCancelled(int refreshID) {
        return !this.refreshList[refreshID];
    }

    protected abstract boolean refresh(int var1);
}

