/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import joptsimple.OptionSet;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.versions.ReleaseType;
import org.tlauncher.tlauncher.configuration.ArgumentParser;
import org.tlauncher.tlauncher.configuration.ConfigurationDefaults;
import org.tlauncher.tlauncher.configuration.InnerConfiguration;
import org.tlauncher.tlauncher.configuration.PlainParser;
import org.tlauncher.tlauncher.configuration.SimpleConfiguration;
import org.tlauncher.tlauncher.configuration.enums.ActionOnLaunch;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.configuration.enums.ConsoleType;
import org.tlauncher.tlauncher.entity.ConfigEnum;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.Direction;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.IntegerArray;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.Reflect;
import org.tlauncher.util.U;

public class Configuration
extends SimpleConfiguration {
    private ConfigurationDefaults defaults;
    private Map<String, Object> constants;
    private List<Locale> defaultLocales;
    private List<Locale> supportedLocales;
    private boolean firstRun;

    private Configuration(URL url, OptionSet set) throws IOException {
        super(url);
        this.init(set);
    }

    private Configuration(File file, OptionSet set) {
        super(file);
        this.init(set);
    }

    public static Configuration createConfiguration(OptionSet set) throws IOException {
        boolean doesntExist;
        Object path = set != null ? set.valueOf("settings") : null;
        InnerConfiguration inner = TLauncher.getInnerSettings();
        File file = path == null ? MinecraftUtil.getSystemRelatedDirectory(inner.get("settings.new")) : new File(path.toString());
        boolean bl = doesntExist = !file.isFile();
        if (doesntExist) {
            U.log("Creating configuration file...");
            FileUtil.createFile(file);
        }
        U.log("Loading configuration from file:", file);
        Configuration config = new Configuration(file, set);
        config.firstRun = doesntExist;
        return config;
    }

    public static Configuration createConfiguration() throws IOException {
        return Configuration.createConfiguration(null);
    }

    public static List<Locale> getDefaultLocales(SimpleConfiguration simpleConfiguration) {
        String[] languages;
        ArrayList<Locale> l = new ArrayList<Locale>();
        for (String string : languages = simpleConfiguration.get("languages").split(",")) {
            l.add(Configuration.getLocaleOf(string));
        }
        return l;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public boolean isSaveable(String key) {
        return !this.constants.containsKey(key);
    }

    public Locale getLocale() {
        return Configuration.getLocaleOf(this.get("locale"));
    }

    public Locale[] getLocales() {
        Locale[] locales = new Locale[this.supportedLocales.size()];
        return this.supportedLocales.toArray(locales);
    }

    public ActionOnLaunch getActionOnLaunch() {
        return ActionOnLaunch.get(this.get("minecraft.onlaunch"));
    }

    public ConsoleType getConsoleType() {
        return ConsoleType.get(this.get("gui.console"));
    }

    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.get(this.get("connection"));
    }

    public int[] getClientWindowSize() {
        String plainValue = this.get("minecraft.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(plainValue);
            value[0] = arr.get(0);
            value[1] = arr.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getLauncherWindowSize() {
        String plainValue = this.get("gui.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(plainValue);
            value[0] = arr.get(0);
            value[1] = arr.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getDefaultClientWindowSize() {
        String plainValue = this.getDefault("minecraft.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public int[] getDefaultLauncherWindowSize() {
        String plainValue = this.getDefault("gui.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public VersionFilter getVersionFilter() {
        VersionFilter filter = new VersionFilter();
        for (ReleaseType type : ReleaseType.getDefinable()) {
            boolean include = this.getBoolean("minecraft.versions." + (Object)((Object)type));
            if (include) continue;
            filter.exclude(type);
        }
        for (ReleaseType.SubType type : ReleaseType.SubType.values()) {
            boolean include = this.getBoolean("minecraft.versions.sub." + (Object)((Object)type));
            if (include) continue;
            filter.exclude(type);
        }
        return filter;
    }

    public Direction getDirection(String key) {
        return Reflect.parseEnum(Direction.class, this.get(key));
    }

    public Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public UUID getClient() {
        try {
            return UUID.fromString(this.get("client"));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getDefault(String key) {
        return this.getStringOf(this.defaults.get(key));
    }

    @Override
    public int getDefaultInteger(String key) {
        return this.getIntegerOf(this.defaults.get(key), 0);
    }

    @Override
    public double getDefaultDouble(String key) {
        return this.getDoubleOf(this.defaults.get(key), 0.0);
    }

    @Override
    public float getDefaultFloat(String key) {
        return this.getFloatOf(this.defaults.get(key), 0.0f);
    }

    @Override
    public long getDefaultLong(String key) {
        return this.getLongOf(this.defaults.get(key), 0L);
    }

    @Override
    public boolean getDefaultBoolean(String key) {
        return this.getBooleanOf(this.defaults.get(key), false);
    }

    @Override
    public void set(String key, Object value, boolean flush) {
        if (this.constants.containsKey(key)) {
            return;
        }
        super.set(key, value, flush);
    }

    public void setForcefully(String key, Object value, boolean flush) {
        super.set(key, value, flush);
    }

    public void setForcefully(String key, Object value) {
        this.setForcefully(key, value, true);
    }

    @Override
    public void save() throws IOException {
        if (!this.isSaveable()) {
            throw new UnsupportedOperationException();
        }
        Properties temp = Configuration.copyProperties(this.properties);
        for (String key : this.constants.keySet()) {
            temp.remove(key);
        }
        File file = (File)this.input;
        temp.store(new FileOutputStream(file), this.comments);
    }

    public File getFile() {
        if (!this.isSaveable()) {
            return null;
        }
        return (File)this.input;
    }

    private void init(OptionSet set) {
        this.comments = " TLauncher configuration file\n Version " + TLauncher.getVersion();
        InnerConfiguration inner = TLauncher.getInnerSettings();
        this.defaults = new ConfigurationDefaults(inner);
        this.constants = ArgumentParser.parse(set);
        this.set(this.constants, false);
        this.log("Constant values:", this.constants);
        int version = ConfigurationDefaults.getVersion();
        if (this.getDouble("settings.version") != (double)version) {
            this.clear();
        }
        this.set("settings.version", version, false);
        for (Map.Entry<String, Object> curen : this.defaults.getMap().entrySet()) {
            String key = curen.getKey();
            if (this.constants.containsKey(key)) {
                this.log("Key \"" + key + "\" is unsaveable!");
                continue;
            }
            String value = this.get(key);
            Object defvalue = curen.getValue();
            if (defvalue == null) continue;
            try {
                PlainParser.parse(value, defvalue);
            }
            catch (Exception e) {
                this.log("Key \"" + key + "\" is invalid!");
                this.set(key, defvalue, false);
            }
        }
        this.defaultLocales = Configuration.getDefaultLocales(inner);
        this.supportedLocales = this.defaultLocales;
        Locale selected = Configuration.getLocaleOf(this.get("locale"));
        if (selected == null) {
            this.log("Selected locale is not supported, rolling back to default one");
            selected = Locale.getDefault();
            if (selected == Configuration.getLocaleOf("uk_UA")) {
                selected = Configuration.getLocaleOf("ru_RU");
            }
        }
        selected = Configuration.findSuitableLocale(selected, this.supportedLocales);
        this.set("locale", selected, false);
        if (this.get("chooser.type.account") == null) {
            this.set("chooser.type.account", false, false);
        }
        if (this.get("skin.status.checkbox.state") == null) {
            this.set("skin.status.checkbox.state", true, false);
        }
        if (this.getInteger("minecraft.memory.ram2") > OS.Arch.MAX_MEMORY) {
            U.log(String.format("decreased memory from  %s to %s", this.getInteger("minecraft.memory.ram2"), OS.Arch.MAX_MEMORY));
            this.set("minecraft.memory.ram2", (Object)OS.Arch.MAX_MEMORY);
        }
        if (this.getInteger("minecraft.memory.ram2") < 512) {
            this.set("minecraft.memory.ram2", (Object)512);
        }
        this.set(ConfigEnum.UPDATER_LAUNCHER, (Object)false);
        if (this.isSaveable()) {
            try {
                this.save();
            }
            catch (IOException e) {
                this.log("Cannot save value!", e);
            }
        }
    }

    public static Locale getLocaleOf(String locale) {
        if (locale == null) {
            return null;
        }
        for (Locale cur : Locale.getAvailableLocales()) {
            if (!cur.toString().equals(locale)) continue;
            return cur;
        }
        return null;
    }

    public static Locale findSuitableLocale(Locale selected, List<Locale> supportedLocales) {
        for (Locale l : supportedLocales) {
            if (!l.getLanguage().equals(selected.getLanguage())) continue;
            return l;
        }
        U.log("Default locale is not supported, rolling back to global default one");
        return Locale.US;
    }

    public boolean isExist(String key) {
        return this.get(key) != null;
    }
}

