/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack.right.panel;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.listener.BlockClickListener;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.listener.mods.UpdateGameListener;
import org.tlauncher.tlauncher.ui.loc.modpack.GameRightButton;
import org.tlauncher.tlauncher.ui.modpack.right.panel.RightTableModel;
import org.tlauncher.tlauncher.ui.scenes.CompleteSubEntityScene;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;

public class GameEntityRightPanel
extends JTable
implements GameEntityListener {
    private final ModpackComboBox localmodpacks;
    private final GameType type;
    private static final int HEIGHT_RIGHT_ELEMENT = 159;
    private List<Long> changeableElements = new ArrayList<Long>();
    private Integer nextPageIndex = 0;
    private boolean nextPage;
    private boolean processingRequest;

    public GameEntityRightPanel(ModpackComboBox localmodpacks, GameType type) {
        this.localmodpacks = localmodpacks;
        this.type = type;
        this.setBackground(ColorUtil.COLOR_233);
        this.setRowHeight(159);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setDefaultEditor(GameRightElement.class, new RightRenderer());
        this.setDefaultRenderer(GameRightElement.class, new RightRenderer());
        this.setModel(new RightTableModel());
        MouseAdapter mouse = new MouseAdapter(){
            int current = -1;

            @Override
            public void mouseMoved(MouseEvent e) {
                this.check(e);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GameEntityRightPanel.this.getParent().dispatchEvent(e);
                this.check(e);
            }

            private void check(MouseEvent e) {
                int i = GameEntityRightPanel.this.rowAtPoint(e.getPoint());
                if (i != -1 && i != this.current) {
                    GameEntityRightPanel.this.editCellAt(i, 0);
                    this.current = i;
                }
            }
        };
        this.addMouseWheelListener(mouse);
        this.addMouseMotionListener(mouse);
    }

    public void addElements(List<GameEntityDTO> list, boolean clean) {
        RightTableModel rightTableModel = (RightTableModel)this.getModel();
        rightTableModel.addElements(list, clean);
    }

    @Override
    public void processingStarted(GameEntityDTO e, VersionDTO version) {
        this.changeableElements.add(e.getId());
        for (Component c : Arrays.asList(this.getComponents())) {
            GameRightElement el;
            if (!(c instanceof GameRightElement) || !(el = (GameRightElement)c).getEntity().getId().equals(e.getId())) continue;
            el.processingInstall();
        }
    }

    @Override
    public void installEntity(GameEntityDTO e, GameType type) {
        this.changeableElements.remove(e.getId());
        this.repaint();
        this.updateRow();
    }

    @Override
    public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
        this.changeableElements.remove(e.getId());
        GameRightElement elem = this.find(e);
        if (elem != null) {
            elem.modpackActButton.reset();
        }
    }

    private GameRightElement find(GameEntityDTO e) {
        for (Component c : Arrays.asList(this.getComponents())) {
            GameRightElement el;
            if (!(c instanceof GameRightElement) || !(el = (GameRightElement)c).getEntity().getId().equals(e.getId())) continue;
            return el;
        }
        return null;
    }

    @Override
    public void populateStatus(GameEntityDTO e, GameType type, boolean state) {
        GameRightElement elem = this.find(e);
        if (elem != null) {
            elem.getStatusStarButton().setStatus(state);
        }
    }

    @Override
    public void removeEntity(GameEntityDTO e) {
        this.changeableElements.remove(e.getId());
        this.repaint();
        this.updateRow();
    }

    void updateRow() {
        int row = this.getEditingRow();
        if (row >= 0) {
            SwingUtilities.invokeLater(() -> this.editCellAt(row, 0));
        }
    }

    public void filterRightPanel(GameType current) {
        Container container = this.getParent();
        CardLayout cardLayout = (CardLayout)container.getLayout();
        if (this.getModel().getRowCount() > 0) {
            cardLayout.show(container, ModpackScene.NOT_EMPTY);
        } else {
            cardLayout.show(container, ModpackScene.EMPTY);
        }
        if (this.isEditing()) {
            this.cellEditor.cancelCellEditing();
        }
    }

    @Override
    public void installEntity(CompleteVersion e) {
    }

    @Override
    public void activationStarted(GameEntityDTO e) {
    }

    @Override
    public void activation(GameEntityDTO e) {
    }

    @Override
    public void activationError(GameEntityDTO e, Throwable t) {
    }

    @Override
    public void updateVersion(CompleteVersion v, CompleteVersion newVersion) {
    }

    @Override
    public void removeCompleteVersion(CompleteVersion e) {
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return GameRightElement.class;
    }

    public Integer getNextPageIndex() {
        return this.nextPageIndex;
    }

    public void setNextPageIndex(Integer nextPageIndex) {
        this.nextPageIndex = nextPageIndex;
    }

    public boolean isNextPage() {
        return this.nextPage;
    }

    public void setNextPage(boolean nextPage) {
        this.nextPage = nextPage;
    }

    public boolean isProcessingRequest() {
        return this.processingRequest;
    }

    public void setProcessingRequest(boolean processingRequest) {
        this.processingRequest = processingRequest;
    }

    private class RightRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (Objects.isNull(value)) {
                return null;
            }
            GameRightElement el = new GameRightElement((GameEntityDTO)value, GameEntityRightPanel.this.type, row);
            if (GameEntityRightPanel.this.changeableElements.contains(((GameEntityDTO)value).getId())) {
                el.modpackActButton.setTypeButton("PROCESSING");
            }
            el.setBackground(ColorUtil.COLOR_247);
            return el;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (Objects.isNull(value)) {
                return null;
            }
            GameRightElement el = new GameRightElement((GameEntityDTO)value, GameEntityRightPanel.this.type, row);
            if (GameEntityRightPanel.this.changeableElements.contains(((GameEntityDTO)value).getId())) {
                el.modpackActButton.setTypeButton("PROCESSING");
            }
            el.setBackground(Color.WHITE);
            return el;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    public class GameRightElement
    extends CompleteSubEntityScene.DescriptionGamePanel
    implements UpdateGameListener {
        private GameEntityDTO entity;
        private int row;
        private GameRightButton modpackActButton;

        public GameEntityDTO getEntity() {
            return this.entity;
        }

        public GameRightElement(final GameEntityDTO entity, final GameType type, int row) {
            super(entity, type);
            this.row = row;
            this.description.setVisible(true);
            this.entity = entity;
            this.modpackActButton = new GameRightButton(entity, type, GameEntityRightPanel.this.localmodpacks){

                @Override
                public void updateRow() {
                    GameEntityRightPanel.this.repaint();
                }
            };
            JLabel shadow = new JLabel(){

                @Override
                protected void paintComponent(Graphics g) {
                    Rectangle rec = this.getBounds();
                    SwingUtil.paintShadowLine(rec, g, this.getParent().getBackground().getRed() - 14, 14);
                }
            };
            shadow.setBackground(Color.green);
            this.descriptionLayout.putConstraint("West", (Component)shadow, 0, "West", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)shadow, 0, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)shadow, 0, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)shadow, 14, "North", (Component)this);
            this.add(shadow);
            this.modpackActButton.initButton();
            this.imagePanel.addMoapckActButton(this.modpackActButton);
            this.descriptionLayout.putConstraint("West", (Component)this.imagePanel, 27, "West", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)this.imagePanel, 138, "West", (Component)this);
            class MouseBackgroundListener
            extends MouseAdapter
            implements BlockClickListener {
                MouseBackgroundListener() {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ((ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class)).showFullGameEntity(entity, type);
                    }
                }
            }
            MouseBackgroundListener adapter = new MouseBackgroundListener();
            this.addMouseListener(adapter);
            for (Component comp : this.getComponents()) {
                comp.removeMouseListener(adapter);
            }
            this.description.addMouseListener(adapter);
        }

        @Override
        public void processingActivation() {
        }

        @Override
        public void processingInstall() {
            this.modpackActButton.setTypeButton("PROCESSING");
            ((RightTableModel)GameEntityRightPanel.this.getModel()).fireTableCellUpdated(this.row, 0);
        }

        @Override
        public void initGameEntity() {
        }
    }
}

