/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import net.minecraft.launcher.process.JavaProcessLauncher;
import org.apache.commons.io.IOUtils;
import org.tlauncher.tlauncher.rmo.Bootstrapper;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.loc.LocalizableCheckbox;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

public class ResetView
extends JPanel {
    private JButton resetAgain;

    public ResetView() {
        SpringLayout spring = new SpringLayout();
        this.setLayout(spring);
        this.setPreferredSize(new Dimension(420, 280));
        LocalizableLabel label = new LocalizableLabel("settings.reset.message");
        LocalizableLabel mapsNotRemove = new LocalizableLabel("settings.reset.not.remove.maps");
        mapsNotRemove.setHorizontalAlignment(0);
        mapsNotRemove.setForeground(new Color(255, 58, 66));
        this.resetAgain = new UpdaterButton(new Color(222, 64, 43), new Color(222, 31, 8), Color.WHITE, "settings.reset.button.start");
        SwingUtil.setFontSize(this.resetAgain, 13.0f, 1);
        EditorCheckBox tlSettings = new EditorCheckBox("settings.reset.remove.tlauncher.settings");
        tlSettings.setIconTextGap(15);
        tlSettings.setSelected(true);
        EditorCheckBox minecraft = new EditorCheckBox("settings.reset.remove.minecraft.folder");
        minecraft.setIconTextGap(15);
        minecraft.setSelected(true);
        EditorCheckBox versions = new EditorCheckBox("settings.reset.remove.versions");
        versions.setIconTextGap(15);
        versions.setSelected(true);
        spring.putConstraint("North", (Component)label, 10, "North", (Component)this);
        spring.putConstraint("West", (Component)label, 10, "West", (Component)this);
        spring.putConstraint("South", (Component)label, 40, "North", (Component)this);
        spring.putConstraint("East", (Component)label, -10, "East", (Component)this);
        this.add(label);
        spring.putConstraint("North", (Component)tlSettings, 10, "South", (Component)label);
        spring.putConstraint("West", (Component)tlSettings, 10, "West", (Component)this);
        spring.putConstraint("South", (Component)tlSettings, 40, "South", (Component)label);
        spring.putConstraint("East", (Component)tlSettings, -10, "East", (Component)this);
        this.add(tlSettings);
        spring.putConstraint("North", (Component)versions, 10, "South", (Component)tlSettings);
        spring.putConstraint("West", (Component)versions, 10, "West", (Component)this);
        spring.putConstraint("South", (Component)versions, 40, "South", (Component)tlSettings);
        spring.putConstraint("East", (Component)versions, -10, "East", (Component)this);
        this.add(versions);
        spring.putConstraint("North", (Component)minecraft, 10, "South", (Component)versions);
        spring.putConstraint("West", (Component)minecraft, 10, "West", (Component)this);
        spring.putConstraint("South", (Component)minecraft, 40, "South", (Component)versions);
        spring.putConstraint("East", (Component)minecraft, -10, "East", (Component)this);
        this.add(minecraft);
        spring.putConstraint("North", (Component)mapsNotRemove, 30, "South", (Component)minecraft);
        spring.putConstraint("West", (Component)mapsNotRemove, 0, "West", (Component)this);
        spring.putConstraint("South", (Component)mapsNotRemove, 55, "South", (Component)minecraft);
        spring.putConstraint("East", (Component)mapsNotRemove, 0, "East", (Component)this);
        this.add(mapsNotRemove);
        spring.putConstraint("North", (Component)this.resetAgain, -50, "South", (Component)this);
        spring.putConstraint("West", (Component)this.resetAgain, 50, "West", (Component)this);
        spring.putConstraint("South", (Component)this.resetAgain, -10, "South", (Component)this);
        spring.putConstraint("East", (Component)this.resetAgain, -50, "East", (Component)this);
        this.add(this.resetAgain);
        this.resetAgain.addActionListener(e1 -> {
            if (Alert.showLocQuestion("settings.reset.question.confirm")) {
                AsyncThread.execute(() -> this.reset(tlSettings, minecraft, versions));
            }
        });
    }

    public JButton getResetAgain() {
        return this.resetAgain;
    }

    private void reset(LocalizableCheckbox tlSettings, LocalizableCheckbox minecraft, LocalizableCheckbox versions) {
        File dir2;
        ArrayList<File> files = new ArrayList<File>();
        JavaProcessLauncher p = Bootstrapper.restartLauncher();
        if (versions.isSelected() && (dir2 = new File(MinecraftUtil.getWorkingDirectory(), "versions")).exists()) {
            files.add(dir2);
        }
        if (minecraft.isSelected()) {
            try {
                File dir3 = MinecraftUtil.getWorkingDirectory();
                if (dir3.exists()) {
                    files.addAll(IOUtils.readLines(this.getClass().getResourceAsStream("/removedFolders.txt")).stream().map(e -> new File(dir3, (String)e)).filter(File::exists).collect(Collectors.toList()));
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (tlSettings.isSelected()) {
            File tlFolder = MinecraftUtil.getTLauncherFile("");
            Object[] listFiles = tlFolder.listFiles(pathname -> !pathname.toString().endsWith("jvms"));
            files.addAll(Lists.newArrayList((Object[])listFiles));
            TLauncher.getInstance().getConfiguration().clear();
            TLauncher.getInstance().getConfiguration().store();
        }
        files.forEach(f -> {
            if (f.isDirectory()) {
                FileUtil.deleteDirectory(f);
            } else {
                FileUtil.deleteFile(f);
            }
        });
        try {
            p.start();
            TLauncher.kill();
        }
        catch (IOException e3) {
            U.log(e3);
        }
    }
}

