/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.renderer;

import java.awt.Component;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.CompoundBorder;
import org.tlauncher.modpack.domain.client.share.CategoryDTO;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.model.CategoryComboBoxModel;
import org.tlauncher.tlauncher.ui.swing.renderer.UserCategoryListRenderer;
import org.tlauncher.util.ColorUtil;

public class CategoryListRenderer
extends UserCategoryListRenderer {
    private JComboBox<CategoryDTO> categoriesBox;

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent component;
        if (value == null) {
            return null;
        }
        CategoryDTO cat = (CategoryDTO)value;
        String text = Localizable.get("modpack." + cat.getName());
        Set<CategoryDTO> set = ((CategoryComboBoxModel)this.categoriesBox.getModel()).getSelectedCategories();
        if (set.contains(cat)) {
            component = (JComponent)this.createElement(index, true, text);
            component.setBackground(ColorUtil.BACKGROUND_COMBO_BOX_POPUP_SELECTED);
        } else {
            component = (JComponent)this.createElement(index, isSelected, text);
        }
        if (cat.getNesting() != 0) {
            CompoundBorder border = new CompoundBorder(component.getBorder(), BorderFactory.createEmptyBorder(0, cat.getNesting() == 1 ? 15 : 30, 0, 0));
            component.setBorder(border);
        }
        return component;
    }

    public CategoryListRenderer(JComboBox<CategoryDTO> categoriesBox) {
        this.categoriesBox = categoriesBox;
    }
}

