/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.site.play;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.entity.server.SiteServer;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.U;

@Singleton
public class SitePlay
implements VersionManagerListener {
    private boolean status = false;
    @Inject
    private TLauncher tLauncher;
    @Inject
    private ModpackManager manager;
    private HttpServer server;

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        this.init();
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        this.init();
    }

    private static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("\\?")[1].split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private synchronized void init() {
        if (this.status) {
            return;
        }
        this.status = true;
        for (String port : TLauncher.getInnerSettings().getArray("local.ports.client.play")) {
            try {
                SocketConfig config = SocketConfig.copy(SocketConfig.DEFAULT).setSoReuseAddress(true).build();
                this.server = ServerBootstrap.bootstrap().setListenerPort(Integer.parseInt(port)).setSslContext(this.createSSLContext()).setSocketConfig(config).registerHandler("/", new HttpRequestHandlerServer()).registerHandler("/open/modpack/element", new HttpRequestHandlerMinecraftElement()).create();
                this.server.start();
                U.log("local server started");
                return;
            }
            catch (Exception e) {
                U.log(e);
            }
        }
    }

    private SSLContext createSSLContext() throws Exception {
        char[] ksPass = "test123123".toCharArray();
        char[] ctPass = "test123123".toCharArray();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(TLauncher.class.getResource("/play_game_server").openStream(), ksPass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, ctPass);
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(kmf.getKeyManagers(), null, null);
        return sc;
    }

    private class HttpRequestHandlerMinecraftElement
    implements HttpRequestHandler {
        private HttpRequestHandlerMinecraftElement() {
        }

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws IOException {
            Map map = SitePlay.getQueryMap(request.getRequestLine().getUri());
            response.setStatusCode(200);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.setEntity(new StringEntity("ok"));
            CompletableFuture.runAsync(() -> SitePlay.this.manager.openModpackElement(Long.valueOf((String)map.get("id")), GameType.create((String)map.get("type"))));
        }
    }

    private class HttpRequestHandlerServer
    implements HttpRequestHandler {
        private HttpRequestHandlerServer() {
        }

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws IOException {
            BasicHttpEntityEnclosingRequest ob = (BasicHttpEntityEnclosingRequest)context.getAttribute("http.request");
            HttpEntity entity = ob.getEntity();
            SiteServer siteServer = new Gson().fromJson(IOUtils.toString(entity.getContent()), SiteServer.class);
            response.setStatusCode(200);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.setEntity(new StringEntity("ok"));
            entity.getContent().close();
            SitePlay.this.tLauncher.getFrame().setAlwaysOnTop(true);
            SitePlay.this.tLauncher.getFrame().setAlwaysOnTop(false);
            ((SitePlay)SitePlay.this).tLauncher.getFrame().mp.defaultScene.loginForm.startLauncher(siteServer);
        }
    }
}

