/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.tlauncher.tlauncher.ui.swing.ImageButton;

public class ImageUdaterButton
extends ImageButton {
    public final Color backroundColor;
    public final String defaultImage;
    private Color modelPressedColor;

    public ImageUdaterButton(Color color, String image) {
        super(image);
        this.defaultImage = image;
        this.backroundColor = color;
        this.setBackground(color);
    }

    public ImageUdaterButton(Color color) {
        this.backroundColor = color;
        this.defaultImage = null;
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        this.setBackground(color);
    }

    public ImageUdaterButton(String image) {
        super(image);
        this.defaultImage = image;
        this.backroundColor = Color.BLACK;
    }

    public ImageUdaterButton(final Color color, final Color color1, final String s, final String s1) {
        this(color, s);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ImageUdaterButton.this.getModel().isEnabled()) {
                    ImageUdaterButton.super.setImage(ImageUdaterButton.loadImage(s1));
                    ImageUdaterButton.super.setBackground(color1);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImageUdaterButton.super.setImage(ImageUdaterButton.loadImage(s));
                ImageUdaterButton.super.setBackground(color);
            }
        });
    }

    public ImageUdaterButton(final Color color, final Color color1, String s) {
        this(color, s);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ImageUdaterButton.this.getModel().isEnabled()) {
                    ImageUdaterButton.super.setBackground(color1);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImageUdaterButton.super.setBackground(color);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle rec = this.getVisibleRect();
        g.setColor(this.getBackground());
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isPressed() && buttonModel.isEnabled() && this.modelPressedColor != null) {
            g.setColor(this.modelPressedColor);
        }
        g.fillRect(rec.x, rec.y, rec.width, rec.height);
        ImageUdaterButton component = this;
        if (this.image != null) {
            this.paintPicture(g, component, rec);
        }
    }

    protected void paintPicture(Graphics g, JComponent c, Rectangle rect) {
        Graphics2D g2d = (Graphics2D)g;
        int x = (this.getWidth() - this.image.getWidth(null)) / 2;
        int y = (this.getHeight() - this.image.getHeight(null)) / 2;
        g2d.drawImage(this.image, x, y, null);
    }

    public String getDefaultImage() {
        return this.defaultImage;
    }

    public Color getBackroundColor() {
        return this.backroundColor;
    }

    public void setModelPressedColor(Color modelPressedColor) {
        this.modelPressedColor = modelPressedColor;
    }
}

