/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc.modpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.listener.BlockClickListener;
import org.tlauncher.tlauncher.ui.loc.RoundUpdaterButton;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackActButton;
import org.tlauncher.tlauncher.ui.modpack.filter.Filter;
import org.tlauncher.tlauncher.ui.modpack.filter.InstallGameEntityFilter;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public abstract class GameRightButton
extends ModpackActButton {
    InstallGameEntityFilter installGameEntityFilter;

    public GameRightButton(GameEntityDTO entity, GameType type, ModpackComboBox localmodpacks) {
        super(entity, type, localmodpacks);
        class Button
        extends RoundUpdaterButton {
            public Button(String value) {
                super(Color.WHITE, new Color(0, 183, 81), new Color(0, 222, 99), value);
            }
        }
        this.installButton = new Button("loginform.enter.install");
        this.removeButton = new Button("modpack.remove.button");
        this.processButton = new Button("modpack.process.button");
        this.installGameEntityFilter = new InstallGameEntityFilter(localmodpacks, type, new Filter[0]);
        this.add((Component)this.installButton, "INSTALL");
        this.add((Component)this.removeButton, "REMOVE");
        this.add((Component)this.processButton, "PROCESSING");
        SwingUtil.changeFontFamily(this.installButton, FontTL.ROBOTO_REGULAR, 12);
        SwingUtil.changeFontFamily(this.removeButton, FontTL.ROBOTO_REGULAR, 12);
        SwingUtil.changeFontFamily(this.processButton, FontTL.ROBOTO_REGULAR, 12);
        this.initButton();
        ModpackManager manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
        this.removeButton.addActionListener(e -> manager.removeEntity(this.getEntity(), entity.getVersion(), this.getType()));
        this.installButton.addActionListener(e -> manager.installEntity(this.entity, null, this.getType(), true));
    }

    @Override
    public void initButton() {
        this.setTypeButton("INSTALL");
        this.getSelectedModpackData().stream().filter(e -> this.entity.getId().equals(e.getId())).findFirst().ifPresent(e -> {
            this.setVisible(false);
            this.setTypeButton("REMOVE");
        });
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        if (l instanceof BlockClickListener) {
            return;
        }
        super.addMouseListener(l);
    }

    public abstract void updateRow();
}

