/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.extended;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import org.tlauncher.tlauncher.ui.block.BlockableLayeredPane;
import org.tlauncher.tlauncher.ui.swing.ResizeableComponent;

public abstract class ExtendedLayeredPane
extends BlockableLayeredPane
implements ResizeableComponent {
    private static final long serialVersionUID = -1L;
    private Integer LAYER_COUNT = 0;
    protected final JComponent parent;

    protected ExtendedLayeredPane() {
        this.parent = null;
    }

    protected ExtendedLayeredPane(JComponent parent) {
        this.parent = parent;
        if (parent == null) {
            return;
        }
        parent.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ExtendedLayeredPane.this.onResize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ExtendedLayeredPane.this.onResize();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public Component add(Component comp) {
        Integer n = this.LAYER_COUNT;
        Integer n2 = this.LAYER_COUNT = Integer.valueOf(this.LAYER_COUNT + 1);
        super.add(comp, n);
        return comp;
    }

    public void add(Component ... components) {
        if (components == null) {
            throw new NullPointerException();
        }
        for (Component comp : components) {
            this.add(comp);
        }
    }

    @Override
    public void onResize() {
        if (this.parent == null) {
            return;
        }
        this.setSize(this.parent.getWidth(), this.parent.getHeight());
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof ResizeableComponent)) continue;
            ((ResizeableComponent)((Object)comp)).onResize();
        }
    }
}

