/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.user.xb.xsts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Locale;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.tlauncher.tlauncher.minecraft.user.HttpClientRequester;
import org.tlauncher.tlauncher.minecraft.user.InvalidResponseException;
import org.tlauncher.tlauncher.minecraft.user.InvalidStatusCodeException;
import org.tlauncher.tlauncher.minecraft.user.Requester;
import org.tlauncher.tlauncher.minecraft.user.xb.XboxServiceAuthStrategy;
import org.tlauncher.tlauncher.minecraft.user.xb.XboxServiceAuthenticationResponse;
import org.tlauncher.tlauncher.minecraft.user.xb.xsts.ChildAccountException;
import org.tlauncher.tlauncher.minecraft.user.xb.xsts.NoXboxAccountException;
import org.tlauncher.tlauncher.minecraft.user.xb.xsts.XSTSAuthenticationException;

public class XSTSAuthenticator
extends XboxServiceAuthStrategy {
    private static final Logger LOGGER = LogManager.getLogger(XSTSAuthenticator.class);

    public XSTSAuthenticator() {
        super(LOGGER, new HttpClientRequester<String>(xboxLiveToken -> Request.Post((String)"https://xsts.auth.xboxlive.com/xsts/authorize").bodyString(String.format(Locale.ROOT, "{\"Properties\":{\"SandboxId\":\"RETAIL\",\"UserTokens\":[\"%s\"]},\"RelyingParty\": \"rp://api.minecraftservices.com/\",\"TokenType\": \"JWT\"}", xboxLiveToken), ContentType.APPLICATION_JSON)));
    }

    XSTSAuthenticator(Requester<String> requester) {
        super(LOGGER, requester);
    }

    private static XSTSAuthenticationException parseXErr(JsonObject response) {
        JsonElement xErr;
        if (response.has("XErr") && (xErr = response.get("XErr")) instanceof JsonPrimitive) {
            String code;
            switch (code = xErr.getAsString()) {
                case "2148916233": {
                    return new NoXboxAccountException();
                }
                case "2148916238": {
                    return new ChildAccountException();
                }
            }
        }
        return null;
    }

    public XboxServiceAuthenticationResponse xstsAuthenticate(String xboxLiveToken) throws XSTSAuthenticationException, IOException {
        try {
            return (XboxServiceAuthenticationResponse)this.requestAndParse(xboxLiveToken);
        }
        catch (InvalidResponseException e) {
            XSTSAuthenticationException e1;
            JsonObject response;
            if (e instanceof InvalidStatusCodeException && ((InvalidStatusCodeException)e).getStatusCode() == 401 && (response = e.getResponseAsJson()) != null && (e1 = XSTSAuthenticator.parseXErr(response)) != null) {
                throw e1;
            }
            throw new XSTSAuthenticationException(e);
        }
    }
}

