/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.modpack;

import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.U;

public class ModpackGameListener
implements MinecraftListener {
    @Inject
    private ModpackManager modpackManager;
    @Inject
    private TLauncher tLauncher;

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
        U.log("copied to modpack servers.dat");
        this.copy(true);
    }

    @Override
    public void onMinecraftClose() {
        U.log("copy from modpack servers.dat ");
        this.copy(false);
    }

    @Override
    public void onMinecraftError(Throwable e) {
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
    }

    private void copy(boolean toModpack) {
        String servers = "servers.dat";
        Path modpackServers = ModpackUtil.getPathByVersion(this.tLauncher.getLauncher().getVersion(), servers);
        Path baseServers = FileUtil.getRelative(servers);
        try {
            if (toModpack) {
                Files.copy(baseServers, modpackServers, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(modpackServers, baseServers, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            U.log(e);
        }
    }
}

