/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.modpack;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.extract.ExtractArchive;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.commons.io.FilenameUtils;
import org.tlauncher.tlauncher.modpack.PreparedMod;
import org.tlauncher.util.U;

public class PreparedModIMpl
implements PreparedMod {
    @Override
    public List<Path> prepare(CompleteVersion completeVersion) {
        return new ArrayList<Path>();
    }

    private void prepareModeFolders(Path source, Path dest, List<Path> paths) {
        File[] files = source.toFile().listFiles();
        for (int i = 0; i < files.length; ++i) {
            paths.add(files[i].toPath());
        }
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            U.log(e);
        }
    }

    private void prepareGameFolders(Path source, Path dest, List<Path> paths) {
        File[] files = source.toFile().listFiles();
        ExtractArchive extractArchive = new ExtractArchive();
        for (int i = 0; i < files.length; ++i) {
            String ext;
            switch (ext = FilenameUtils.getExtension(files[i].toString())) {
                case "rar": {
                    try {
                        paths.addAll(this.topFolders(new Archive(files[i])));
                    }
                    catch (RarException | IOException e) {
                        U.log(e);
                    }
                    extractArchive.extractArchive(files[i], dest.toFile());
                    return;
                }
                case "zip": {
                    return;
                }
            }
            U.log("don't find extension");
        }
    }

    private List<Path> topFolders(Archive rar) throws IOException, RarException {
        FileHeader fh = rar.nextFileHeader();
        ArrayList<Path> list = new ArrayList<Path>();
        while (fh != null) {
            if (fh.isDirectory()) {
                list.add(Paths.get(fh.getFileNameString(), new String[0]));
            }
            fh = rar.nextFileHeader();
        }
        return list;
    }

    private List<Path> topFolders(ZipFile zipFile) {
        ArrayList<Path> list = new ArrayList<Path>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            File file;
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory() || (file = new File(entry.getName())).getParent() != null) continue;
            list.add(Paths.get(file.getName(), new String[0]));
        }
        return list;
    }
}

