/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.async;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tlauncher.util.async.AsyncContainerLockedException;
import org.tlauncher.util.async.AsyncObject;
import org.tlauncher.util.async.AsyncObjectGotErrorException;
import org.tlauncher.util.async.AsyncObjectNotReadyException;

public class AsyncObjectContainer<T> {
    private final List<AsyncObject<T>> objects = new ArrayList<AsyncObject<T>>();
    private final Map<AsyncObject<T>, T> values = new LinkedHashMap<AsyncObject<T>, T>();
    private boolean executionLock;

    public AsyncObjectContainer() {
    }

    public AsyncObjectContainer(AsyncObject<T>[] asyncObjects) {
        this();
        for (AsyncObject<T> object : asyncObjects) {
            this.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AsyncObject<T>, T> execute() {
        this.executionLock = true;
        this.values.clear();
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            int i = 0;
            int size = this.objects.size();
            for (AsyncObject<T> object : this.objects) {
                object.start();
            }
            while (i < size) {
                for (AsyncObject<T> object : this.objects) {
                    try {
                        if (this.values.containsKey(object)) continue;
                        this.values.put(object, object.getValue());
                        ++i;
                    }
                    catch (AsyncObjectNotReadyException asyncObjectNotReadyException) {
                    }
                    catch (AsyncObjectGotErrorException ignored0) {
                        this.values.put(object, null);
                        ++i;
                    }
                }
            }
        }
        this.executionLock = false;
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AsyncObject<T> object) {
        if (object == null) {
            throw new NullPointerException();
        }
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<AsyncObject<T>> list = this.objects;
        synchronized (list) {
            if (this.executionLock) {
                throw new AsyncContainerLockedException();
            }
            this.objects.clear();
        }
    }
}

