/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.util.OS;

public class RepositoryBasedVersionList
extends RemoteVersionList {
    protected final Repo repo;

    RepositoryBasedVersionList(Repo repo) {
        if (repo == null) {
            throw new NullPointerException();
        }
        this.repo = repo;
    }

    @Override
    public VersionList.RawVersionList getRawList() throws IOException {
        VersionList.RawVersionList rawList = super.getRawList();
        for (Version version : rawList.getVersions()) {
            version.setSource(this.repo);
        }
        return rawList;
    }

    @Override
    public CompleteVersion getCompleteVersion(Version version) throws JsonSyntaxException, IOException {
        CompleteVersion complete = super.getCompleteVersion(version);
        complete.setSource(this.repo);
        return complete;
    }

    @Override
    public boolean hasAllFiles(CompleteVersion paramCompleteVersion, OS paramOperatingSystem) {
        return true;
    }

    @Override
    protected String getUrl(String uri) throws IOException {
        return this.repo.getUrl(uri);
    }
}

