/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.accounts.helper;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.accounts.AccountEditor;
import org.tlauncher.tlauncher.ui.accounts.helper.HelperState;
import org.tlauncher.tlauncher.ui.accounts.helper.HelperTip;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedLayeredPane;

public class AccountEditorHelper
extends ExtendedLayeredPane {
    static final int MARGIN = 5;
    static final byte LEFT = 0;
    static final byte UP = 1;
    static final byte RIGHT = 2;
    static final byte DOWN = 3;
    private final MainPane pane;
    private final HelperTip[] tips;

    public AccountEditorHelper(AccountEditorScene scene) {
        super(scene);
        this.pane = scene.getMainPane();
        AccountEditor editor = scene.editor;
        this.tips = new HelperTip[]{new HelperTip("account", editor, editor, 1, HelperState.PREMIUM, HelperState.FREE), new HelperTip("username", editor.username, editor, 0, HelperState.PREMIUM, HelperState.FREE), new HelperTip("password", editor.password, editor, 0, HelperState.PREMIUM), new HelperTip("button", editor.save, editor, 0, HelperState.PREMIUM, HelperState.FREE)};
        this.add(this.tips);
    }

    public void setState(HelperState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        for (HelperState helperState : HelperState.values()) {
            helperState.item.setEnabled(!helperState.equals((Object)state));
        }
        if (state == HelperState.NONE) {
            for (HelperTip helperTip : this.tips) {
                helperTip.setVisible(false);
            }
            return;
        }
        for (HelperTip helperTip : this.tips) {
            int y;
            int x;
            LocalizableLabel l = helperTip.label;
            l.setText("auth.helper." + state.toString() + "." + helperTip.name);
            Component c = helperTip.component;
            int cWidth = c.getWidth();
            int cHeight = c.getHeight();
            Point cp = this.pane.getLocationOf(c);
            Component p = helperTip.parent;
            int pWidth = p.getWidth();
            int pHeight = p.getHeight();
            Point pp = this.pane.getLocationOf(p);
            FontMetrics fm = l.getFontMetrics(l.getFont());
            Insets i = helperTip.getInsets();
            int height = i.top + i.bottom + fm.getHeight();
            int width = i.left + i.right + fm.stringWidth(l.getText());
            switch (helperTip.alignment) {
                case 0: {
                    x = pp.x - 5 - width;
                    y = cp.y + cHeight / 2 - height / 2;
                    break;
                }
                case 1: {
                    x = cp.x + cWidth / 2 - width / 2;
                    y = pp.y - 5 - height;
                    break;
                }
                case 2: {
                    x = pp.x + pWidth + 5;
                    y = cp.y + cHeight / 2 - height / 2;
                    break;
                }
                case 3: {
                    x = cp.x + cWidth / 2 - width / 2;
                    y = pp.y + pHeight + 5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown alignment");
                }
            }
            if (x < 0) {
                x = 0;
            } else if (x + width > this.getWidth()) {
                x = this.getWidth() - width;
            }
            if (y < 0) {
                y = 0;
            } else if (y + height > this.getHeight()) {
                y = this.getHeight() - height;
            }
            helperTip.setVisible(true);
            helperTip.setBounds(x, y, width, height);
        }
    }

    @Override
    public void onResize() {
        super.onResize();
    }
}

