/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.menu;

import java.util.List;
import java.util.Objects;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.entity.ServerInfo;

public class PopupMenuModel {
    private List<VersionSyncInfo> servers;
    private ServerInfo info;
    private boolean mainPage;
    private VersionSyncInfo selected;

    public ServerInfo getInfo() {
        return this.info;
    }

    public PopupMenuModel(List<VersionSyncInfo> servers, ServerInfo info, boolean mainPage) {
        this.info = info;
        this.servers = servers;
        this.mainPage = mainPage;
    }

    public String getName() {
        return this.getAddress().split(":")[0];
    }

    public String getAddress() {
        return this.info.getAddress();
    }

    public String getResolvedAddress() {
        if (Objects.nonNull(this.info.getRedirectAddress())) {
            return this.info.getRedirectAddress();
        }
        return this.getAddress();
    }

    public String getServerId() {
        return this.info.getServerId();
    }

    public List<VersionSyncInfo> getServers() {
        return this.servers;
    }

    public boolean isMainPage() {
        return this.mainPage;
    }

    public VersionSyncInfo getSelected() {
        return this.selected;
    }

    public void setServers(List<VersionSyncInfo> servers) {
        this.servers = servers;
    }

    public void setInfo(ServerInfo info) {
        this.info = info;
    }

    public void setMainPage(boolean mainPage) {
        this.mainPage = mainPage;
    }

    public void setSelected(VersionSyncInfo selected) {
        this.selected = selected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PopupMenuModel)) {
            return false;
        }
        PopupMenuModel other = (PopupMenuModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<VersionSyncInfo> this$servers = this.getServers();
        List<VersionSyncInfo> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        ServerInfo this$info = this.getInfo();
        ServerInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        if (this.isMainPage() != other.isMainPage()) {
            return false;
        }
        VersionSyncInfo this$selected = this.getSelected();
        VersionSyncInfo other$selected = other.getSelected();
        return !(this$selected == null ? other$selected != null : !((Object)this$selected).equals(other$selected));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PopupMenuModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<VersionSyncInfo> $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        ServerInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        result = result * 59 + (this.isMainPage() ? 79 : 97);
        VersionSyncInfo $selected = this.getSelected();
        result = result * 59 + ($selected == null ? 43 : $selected.hashCode());
        return result;
    }

    public String toString() {
        return "PopupMenuModel(servers=" + this.getServers() + ", info=" + this.getInfo() + ", mainPage=" + this.isMainPage() + ", selected=" + this.getSelected() + ")";
    }
}

