/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import org.tlauncher.modpack.domain.client.share.CategoryDTO;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;

public class CategoryComboBoxModel
extends DefaultComboBoxModel<CategoryDTO> {
    private static final long serialVersionUID = -216867993953483715L;
    private ModpackScene modpackScene;
    private Set<CategoryDTO> set = new HashSet<CategoryDTO>();

    public CategoryComboBoxModel(ModpackScene modpackScene, CategoryDTO[] items) {
        super(items);
        this.modpackScene = modpackScene;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject);
        if (Objects.nonNull(anObject)) {
            CategoryDTO c = (CategoryDTO)anObject;
            if (c.getId() == 0L) {
                this.set.clear();
                return;
            }
            if (this.set.size() > 4 && !this.set.contains(c)) {
                SwingUtilities.invokeLater(() -> Alert.showLocMessageWithoutTitle("modpack.selected.so.much"));
                return;
            }
            if (this.set.contains(c)) {
                this.set.remove(c);
            } else {
                this.set.add(c);
            }
            this.modpackScene.fillGameEntitiesPanel(true);
        }
    }

    public Set<CategoryDTO> getSelectedCategories() {
        return this.set;
    }
}

