/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack.filter;

import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.Filter;
import org.tlauncher.tlauncher.ui.modpack.filter.ListGameEntityImpl;
import org.tlauncher.tlauncher.ui.modpack.filter.version.IncompatibleFilter;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;

public class InstallGameEntityFilter
extends BaseModpackFilter<GameEntityDTO> {
    private ModpackComboBox modpackComboBox;
    private GameType type;

    public InstallGameEntityFilter(ModpackComboBox modpackComboBox, GameType type, Filter<GameEntityDTO> ... filters) {
        super(filters);
        this.modpackComboBox = modpackComboBox;
        this.type = type;
        if (modpackComboBox.getSelectedIndex() > 0 && type != GameType.MODPACK) {
            ModpackDTO m = ((CompleteVersion)modpackComboBox.getSelectedItem()).getModpack();
            ListGameEntityImpl subElementVersionFilter = new ListGameEntityImpl(type, m);
            HashSet<Long> incompatible = new HashSet<Long>();
            ModpackUtil.extractIncompatible(m, incompatible);
            GameType.getSubEntities().forEach(t -> ((ModpackVersionDTO)m.getVersion()).getByType((GameType)((Object)t)).stream().collect(Collectors.toList()).forEach(e -> ModpackUtil.extractIncompatible(e, incompatible)));
            IncompatibleFilter filter = new IncompatibleFilter(incompatible, ModpackUtil.getAllModpackIds(m));
            this.addFilter(filter);
            this.addFilter(subElementVersionFilter);
        }
    }

    @Override
    public boolean isProper(GameEntityDTO entity) {
        if (!super.isProper(entity)) {
            return false;
        }
        if (this.type != GameType.MODPACK && this.modpackComboBox.getSelectedIndex() > 0) {
            BaseModpackFilter<VersionDTO> filter = BaseModpackFilter.getBaseModpackStandardFilters(entity, this.type, this.modpackComboBox);
            return filter.findAll(entity.getVersions()).size() != 0;
        }
        return true;
    }
}

