/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack.filter.version;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameEntityDependencyDTO;
import org.tlauncher.modpack.domain.client.share.DependencyType;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.ui.modpack.filter.GameEntityFilter;

public class IncompatibleFilter
implements GameEntityFilter {
    private Set<Long> modpackIncompatible;
    private Set<Long> modapckIds;

    public IncompatibleFilter(Set<Long> modpackIncompatible, Set<Long> modapckIds) {
        this.modpackIncompatible = modpackIncompatible;
        this.modapckIds = modapckIds;
    }

    @Override
    public boolean isProper(GameEntityDTO entity) {
        if (this.modpackIncompatible.contains(entity.getId())) {
            return false;
        }
        if (entity.getDependencies() != null) {
            for (GameEntityDependencyDTO d : entity.getDependencies()) {
                if (d.getDependencyType() != DependencyType.REQUIRED || !this.modpackIncompatible.contains(d.getGameEntityId())) continue;
                return false;
            }
        }
        HashSet<Long> set = new HashSet<Long>();
        ModpackUtil.extractIncompatible(entity, set);
        return Collections.disjoint(this.modapckIds, set);
    }
}

