/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.updater.client;

import org.tlauncher.tlauncher.entity.ConfigEnum;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.updater.AutoUpdaterFrame;
import org.tlauncher.tlauncher.updater.client.Update;
import org.tlauncher.tlauncher.updater.client.UpdateListener;
import org.tlauncher.tlauncher.updater.client.Updater;
import org.tlauncher.tlauncher.updater.client.UpdaterAdapter;
import org.tlauncher.tlauncher.updater.client.UpdaterListener;

public class AutoUpdater
extends Updater {
    private final TLauncher t;
    private final AutoUpdaterFrame frame;
    private final UpdaterListener updaterL;
    private final UpdateListener updateL;

    public AutoUpdater(final TLauncher tlauncher) {
        this.t = tlauncher;
        this.frame = new AutoUpdaterFrame(this);
        this.addListener(new UpdaterAdapter(){

            @Override
            public void onUpdaterSucceeded(Updater.SearchSucceeded succeeded) {
                if (TLauncher.getVersion() < succeeded.response.getVersion()) {
                    tlauncher.getConfiguration().set(ConfigEnum.UPDATER_LAUNCHER, (Object)true);
                }
            }
        });
        this.addListener(this.frame);
        this.updaterL = new UpdaterAdapter(){

            @Override
            public void onUpdaterSucceeded(Updater.SearchSucceeded succeeded) {
                Update upd = succeeded.getResponse();
                if (upd.isApplicable()) {
                    upd.addListener(AutoUpdater.this.updateL);
                    upd.download();
                }
            }
        };
        this.updateL = new UpdateListener(){

            @Override
            public void onUpdateError(Update u, Throwable e) {
            }

            @Override
            public void onUpdateDownloading(Update u) {
            }

            @Override
            public void onUpdateDownloadError(Update u, Throwable e) {
            }

            @Override
            public void onUpdateReady(Update u) {
                u.apply();
            }

            @Override
            public void onUpdateApplying(Update u) {
            }

            @Override
            public void onUpdateApplyError(Update u, Throwable e) {
                System.exit(0);
            }
        };
        this.addListener(this.updaterL);
    }

    public TLauncher getLauncher() {
        return this.t;
    }

    @Override
    protected Updater.SearchResult findUpdate0() {
        return super.findUpdate0();
    }

    public void cancelUpdate() {
        this.t.getDownloader().stopDownload();
    }

    public boolean isClosed() {
        return this.frame.isClosed();
    }
}

