/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.guice;

import by.gdev.http.download.config.HttpClientConfig;
import by.gdev.http.download.impl.FileCacheServiceImpl;
import by.gdev.http.download.impl.GsonServiceImpl;
import by.gdev.http.download.impl.HttpServiceImpl;
import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.GsonService;
import by.gdev.http.download.service.HttpService;
import by.gdev.util.DesktopUtil;
import by.gdev.utils.service.FileMapperService;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.FileTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.launcher.versions.json.PatternTypeAdapter;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.InnerConfiguration;
import org.tlauncher.tlauncher.minecraft.auth.AuthenticatorDatabase;
import org.tlauncher.tlauncher.minecraft.auth.UUIDTypeAdapter;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.AdditionalFileAssistance;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.AdditionalFileAssistanceFactory;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.LanguageAssistance;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.SoundAssist;
import org.tlauncher.tlauncher.minecraft.launcher.server.InnerMinecraftServer;
import org.tlauncher.tlauncher.minecraft.launcher.server.InnerMinecraftServersImpl;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.console.Console;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.explorer.FileExplorer;
import org.tlauncher.tlauncher.ui.explorer.FileWrapper;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.progress.ProgressFrame;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.gson.serializer.MapDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ModDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ModpackDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ResourcePackDTOTypeAdapter;
import org.tlauncher.util.guice.CustomBarFactory;
import org.tlauncher.util.guice.LanguageAssistFactory;
import org.tlauncher.util.guice.MinecraftLauncherFactory;
import org.tlauncher.util.guice.SoundAssistFactory;
import org.tlauncher.util.guice.TlauncherFactory;

public class GuiceModule
extends AbstractModule {
    private final Configuration configuration;
    private final InnerConfiguration inner;
    private Injector injector;
    private boolean usedDefaultChooser = true;
    private EventBus eventBus = new EventBus();

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public GuiceModule(Configuration configuration, InnerConfiguration inner) {
        this.configuration = configuration;
        this.inner = inner;
        try {
            new FileExplorer();
        }
        catch (Throwable t) {
            U.log("problem with standard FileExplorer");
            this.usedDefaultChooser = false;
        }
    }

    protected void configure() {
        this.bind(Gson.class).annotatedWith((Annotation)Names.named((String)"GsonCompleteVersion")).toInstance((Object)this.createGsonCompleteVersion());
        this.bind(Gson.class).annotatedWith((Annotation)Names.named((String)"GsonAdditionalFile")).toInstance((Object)this.createAddittionalFileGson());
        this.bind(InnerMinecraftServer.class).to(InnerMinecraftServersImpl.class);
        this.bind(Console.class).annotatedWith((Annotation)Names.named((String)"console")).toInstance((Object)new Console());
        this.bind(ExecutorService.class).annotatedWith((Annotation)Names.named((String)"modpackExecutorService")).toInstance((Object)Executors.newSingleThreadExecutor());
        Class c = FileExplorer.class;
        if (!this.usedDefaultChooser) {
            c = FileWrapper.class;
        }
        this.bind(FileChooser.class).to(c);
        this.install(new FactoryModuleBuilder().implement(MinecraftLauncher.class, MinecraftLauncher.class).build(MinecraftLauncherFactory.class));
        this.install(new FactoryModuleBuilder().implement(TLauncher.class, TLauncher.class).build(TlauncherFactory.class));
        this.install(new FactoryModuleBuilder().implement(ProgressFrame.class, ProgressFrame.class).build(CustomBarFactory.class));
        this.install(new FactoryModuleBuilder().implement(SoundAssist.class, SoundAssist.class).build(SoundAssistFactory.class));
        this.install(new FactoryModuleBuilder().implement(AdditionalFileAssistance.class, AdditionalFileAssistance.class).build(AdditionalFileAssistanceFactory.class));
        this.install(new FactoryModuleBuilder().implement(LanguageAssistance.class, LanguageAssistance.class).build(LanguageAssistFactory.class));
        this.bind(EventBus.class).toInstance((Object)this.eventBus);
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                typeEncounter.register(new InjectionListener<I>(){

                    public void afterInjection(I i) {
                        GuiceModule.this.eventBus.register(i);
                    }
                });
            }
        });
    }

    @Provides
    @Singleton
    public TLauncher getTlauncher() {
        try {
            return ((TlauncherFactory)TLauncher.getInjector().getInstance(TlauncherFactory.class)).create(this.configuration);
        }
        catch (Throwable e) {
            if (TlauncherUtil.getStringError(e).contains("Problem reading font data.")) {
                String text = Localizable.get("alert.error.font.problem").replaceAll("pageLang", TlauncherUtil.getPageLanguage());
                Alert.showErrorHtml(text, 400);
                TLauncher.kill();
            } else {
                U.log("can't create TLauncher instance", e);
            }
            throw new NullPointerException("can't create TLauncher instance");
        }
    }

    @Provides
    @Singleton
    public FileCacheService getFileCacheService() {
        return new FileCacheServiceImpl(this.getHttpService(), this.getGson(), StandardCharsets.UTF_8, MinecraftUtil.getTLauncherFile("cache").toPath(), this.inner.getInteger("file.cache.service.time.to.life"));
    }

    @Provides
    @Singleton
    public Gson getGson() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        return builder.create();
    }

    @Provides
    @Singleton
    public FileMapperService createFileMapperService() {
        return new FileMapperService(this.getGson(), StandardCharsets.UTF_8, MinecraftUtil.getWorkingDirectory().getAbsolutePath());
    }

    private Gson createGsonCompleteVersion() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)CompleteVersion.class), new CompleteVersion.CompleteVersionSerializer());
        builder.registerTypeAdapter((Type)((Object)ModpackDTO.class), new ModpackDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ModDTO.class), new ModDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)MapDTO.class), new MapDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourcePackDTO.class), new ResourcePackDTOTypeAdapter());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        builder.disableHtmlEscaping();
        return builder.create();
    }

    private Gson createAddittionalFileGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Pattern.class), new PatternTypeAdapter());
        builder.setPrettyPrinting();
        return builder.create();
    }

    private Gson createProfileGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)AuthenticatorDatabase.class), new AuthenticatorDatabase.Serializer());
        builder.registerTypeAdapter((Type)((Object)UUIDTypeAdapter.class), new UUIDTypeAdapter());
        builder.setPrettyPrinting();
        return builder.create();
    }

    private int getMaxAttemts() {
        return DesktopUtil.numberOfAttempts(Lists.newArrayList((Object[])this.inner.getArray("net.check.urls")), this.inner.getInteger("max.attempts.per.request"), this.getRequestConfig(), this.getHttpClient());
    }

    @Provides
    @Singleton
    private RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
    }

    @Provides
    @Singleton
    CloseableHttpClient getHttpClient() {
        return HttpClientConfig.getInstanceHttpClient();
    }

    @Provides
    @Singleton
    public HttpService getHttpService() {
        return new HttpServiceImpl(null, this.getHttpClient(), this.getRequestConfig(), this.getMaxAttemts());
    }

    @Provides
    @Singleton
    public GsonService getGsonService() {
        return new GsonServiceImpl(this.createGsonCompleteVersion(), this.getFileCacheService(), this.getHttpService());
    }

    @Provides
    @Singleton
    public ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool();
    }

    @Named(value="profileFileMapperService")
    @Provides
    @Singleton
    public FileMapperService createFileMapperService1() {
        return new FileMapperService(this.createProfileGson(), StandardCharsets.UTF_8, MinecraftUtil.getWorkingDirectory().getAbsolutePath());
    }
}

