/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.json;

import com.github.lunatrius.ingameinfo.InGameInfoXML;
import com.github.lunatrius.ingameinfo.Utils;
import com.github.lunatrius.ingameinfo.Value;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class JsonParser
implements IParser {
    private JsonElement element;

    @Override
    public boolean load(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            com.google.gson.JsonParser parser = new com.google.gson.JsonParser();
            this.element = parser.parse((Reader)fileReader);
            fileReader.close();
            return true;
        }
        catch (Exception e) {
            InGameInfoXML.logger.log(Level.FATAL, "Could not read json configuration file!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean parse(Map<String, List<List<Value>>> format) {
        JsonObject config = this.element.getAsJsonObject();
        Set entries = config.entrySet();
        for (Map.Entry entry : entries) {
            String position = Utils.getPosition((String)entry.getKey());
            if (position == null) continue;
            format.put(position, this.getLines((JsonElement)entry.getValue()));
        }
        return true;
    }

    private List<List<Value>> getLines(JsonElement elementLines) {
        ArrayList<List<Value>> listLines = new ArrayList<List<Value>>();
        JsonArray arrayLines = elementLines.getAsJsonArray();
        for (JsonElement elementLine : arrayLines) {
            if (elementLine == null || !elementLine.isJsonArray()) continue;
            listLines.add(this.getValues(elementLine.getAsJsonArray()));
        }
        return listLines;
    }

    private List<Value> getValues(JsonArray arrayValues) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (JsonElement elementValue : arrayValues) {
            if (elementValue == null || !elementValue.isJsonObject()) continue;
            JsonObject object = elementValue.getAsJsonObject();
            Set entries = object.entrySet();
            for (Map.Entry entry : entries) {
                Value.ValueType type = Value.ValueType.fromString((String)entry.getKey());
                String value = "";
                if (type == Value.ValueType.STR || type == Value.ValueType.NUM || type == Value.ValueType.VAR || type == Value.ValueType.TRANS) {
                    value = Utils.unescapeValue(((JsonElement)entry.getValue()).getAsString(), false);
                }
                Value val = new Value(type, value);
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    val.values = this.getValues(((JsonElement)entry.getValue()).getAsJsonArray());
                }
                values.add(val);
            }
        }
        return values;
    }
}

