/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.parser.text;

import com.github.lunatrius.ingameinfo.InGameInfoXML;
import com.github.lunatrius.ingameinfo.Utils;
import com.github.lunatrius.ingameinfo.Value;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.github.lunatrius.ingameinfo.parser.text.AlignmentException;
import com.github.lunatrius.ingameinfo.parser.text.Token;
import com.github.lunatrius.ingameinfo.parser.text.Tokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class TextParser
implements IParser {
    private final Tokenizer tokenizer = new Tokenizer();
    private Token token;
    private int level = 0;
    private String position = "topleft";

    private Token nextToken() {
        this.token = this.tokenizer.nextToken();
        return this.token;
    }

    @Override
    public boolean load(File file) {
        if (file.exists()) {
            try {
                String line;
                FileReader fileReader = new FileReader(file);
                BufferedReader reader = new BufferedReader(fileReader);
                String content = "";
                while ((line = reader.readLine()) != null) {
                    content = content + line + "\n";
                }
                reader.close();
                fileReader.close();
                this.tokenizer.tokenize(content);
            }
            catch (Exception e) {
                InGameInfoXML.logger.log(Level.FATAL, "Could not read text configuration file!", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean parse(Map<String, List<List<Value>>> format) {
        boolean expr;
        try {
            this.nextToken();
            expr = this.alignments(format) && this.token.isEof();
        }
        catch (Exception e) {
            expr = false;
            e.printStackTrace();
        }
        return expr;
    }

    private boolean alignments(Map<String, List<List<Value>>> format) {
        return this.alignment(format) && this.alignmentsTail(format);
    }

    private boolean alignmentsTail(Map<String, List<List<Value>>> format) {
        if (this.alignment(format)) {
            this.alignmentsTail(format);
        }
        return true;
    }

    private boolean alignment(Map<String, List<List<Value>>> format) {
        boolean expr;
        List<List<Value>> lines = format.get(this.position);
        if (lines == null) {
            lines = new ArrayList<List<Value>>();
        }
        try {
            expr = this.lines(lines);
            if (expr) {
                format.put(this.position, lines);
            }
        }
        catch (AlignmentException e) {
            format.put(this.position, lines);
            this.position = e.getPosition();
            expr = e.isValid();
        }
        return expr;
    }

    private boolean lines(List<List<Value>> lines) throws AlignmentException {
        return this.line(lines) && this.linesTail(lines);
    }

    private boolean linesTail(List<List<Value>> lines) throws AlignmentException {
        if (this.line(lines)) {
            this.linesTail(lines);
        }
        return true;
    }

    private boolean line(List<List<Value>> lines) throws AlignmentException {
        ArrayList<Value> values = new ArrayList<Value>();
        boolean expr = this.values(values);
        if (this.token.getType().equals((Object)Token.TokenType.NEWLINE)) {
            this.nextToken();
        }
        if (expr) {
            lines.add(values);
        }
        return expr;
    }

    private boolean values(List<Value> values) throws AlignmentException {
        return this.value(values) && this.valuesTail(values);
    }

    private boolean valuesTail(List<Value> values) throws AlignmentException {
        if (this.value(values)) {
            this.valuesTail(values);
        }
        return true;
    }

    private boolean value(List<Value> values) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.STRING)) {
            expr = this.string(values, this.token.getLexem());
            this.nextToken();
        } else if (this.token.getType().equals((Object)Token.TokenType.FUNC_HEAD)) {
            this.nextToken();
            expr = this.function(values, this.token.getLexem());
        } else if (this.level == 0 && Token.TokenType.EXCEPTIONS.contains((Object)this.token.getType())) {
            expr = this.string(values, this.token.getLexem());
            this.nextToken();
        } else {
            expr = false;
        }
        return expr;
    }

    private boolean string(List<Value> values, String lexem) {
        values.add(new Value(Value.ValueType.STR, Utils.unescapeValue(lexem, true)));
        return true;
    }

    private boolean function(List<Value> values, String lexem) throws AlignmentException {
        boolean expr;
        Value value;
        ++this.level;
        Value.ValueType type = Value.ValueType.fromString(lexem);
        Value value2 = value = type == Value.ValueType.NONE ? new Value(Value.ValueType.VAR, lexem) : new Value(type, "");
        if (this.token.getType().equals((Object)Token.TokenType.STRING)) {
            this.nextToken();
            expr = this.argumentGroupA(value);
            if (this.token.getType().equals((Object)Token.TokenType.FUNC_TAIL)) {
                this.nextToken();
            } else {
                expr = false;
            }
        } else {
            expr = false;
        }
        --this.level;
        String position = Utils.getPosition(lexem);
        if (position != null) {
            throw new AlignmentException(position, expr);
        }
        if (expr) {
            values.add(value);
        }
        return expr;
    }

    private boolean argumentGroupA(Value value) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_HEAD)) {
            this.nextToken();
            expr = this.argumentsA(value);
            expr &= this.argumentGroupB(value);
            if (this.token.getType().equals((Object)Token.TokenType.ARGS_TAIL)) {
                this.nextToken();
            } else {
                expr = false;
            }
        } else {
            expr = true;
        }
        return expr;
    }

    private boolean argumentsA(Value value) throws AlignmentException {
        return this.argument(value) && this.argumentsATail(value);
    }

    private boolean argumentsATail(Value value) throws AlignmentException {
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_SEPARATOR)) {
            this.nextToken();
            if (this.argument(value)) {
                this.argumentsATail(value);
            }
        }
        return true;
    }

    private boolean argument(Value value) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.STRING)) {
            expr = this.string(value.values, this.token.getLexem());
            this.nextToken();
        } else if (this.token.getType().equals((Object)Token.TokenType.FUNC_HEAD)) {
            this.nextToken();
            expr = this.function(value.values, this.token.getLexem());
        } else {
            expr = this.string(value.values, "");
        }
        return expr;
    }

    private boolean argumentGroupB(Value value) throws AlignmentException {
        boolean expr;
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_HEAD)) {
            this.nextToken();
            expr = this.argumentsB(value);
            if (this.token.getType().equals((Object)Token.TokenType.ARGS_TAIL)) {
                this.nextToken();
            } else {
                expr = false;
            }
        } else {
            expr = true;
        }
        return expr;
    }

    private boolean argumentsB(Value value) throws AlignmentException {
        return this.argument(value) && this.argumentsBTail(value);
    }

    private boolean argumentsBTail(Value value) throws AlignmentException {
        if (this.token.getType().equals((Object)Token.TokenType.ARGS_SEPARATOR)) {
            this.nextToken();
            if (this.argument(value)) {
                this.argumentsBTail(value);
            }
        }
        return true;
    }
}

