/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.serializer.text;

import com.github.lunatrius.ingameinfo.InGameInfoXML;
import com.github.lunatrius.ingameinfo.Utils;
import com.github.lunatrius.ingameinfo.Value;
import com.github.lunatrius.ingameinfo.serializer.ISerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class TextSerializer
implements ISerializer {
    @Override
    public boolean save(File file, Map<String, List<List<Value>>> format) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            this.writeLines(writer, format);
            writer.close();
            fileWriter.close();
            return true;
        }
        catch (Exception e) {
            InGameInfoXML.logger.log(Level.FATAL, "Could not save text configuration file!", (Throwable)e);
            return false;
        }
    }

    private void writeLines(BufferedWriter writer, Map<String, List<List<Value>>> format) throws IOException {
        for (String alignment : Utils.ALIGNEMENTS) {
            if (!format.containsKey(alignment)) continue;
            writer.write(String.format("<%s>", alignment));
            this.writeLine(writer, format.get(alignment));
        }
    }

    private void writeLine(BufferedWriter writer, List<List<Value>> lines) throws IOException {
        for (List<Value> line : lines) {
            this.writeValues(writer, line);
            writer.write("\n");
        }
    }

    private void writeValues(BufferedWriter writer, List<Value> values) throws IOException {
        for (Value value : values) {
            this.writeValue(writer, value);
        }
    }

    private void writeValue(BufferedWriter writer, Value value) throws IOException {
        List<Value> values = value.values;
        int size = values.size();
        String type = value.type.toString().toLowerCase();
        if (size == 0) {
            if (value.type == Value.ValueType.STR || value.type == Value.ValueType.NUM) {
                writer.write(Utils.escapeValue(value.value, true));
            } else if (value.type == Value.ValueType.VAR) {
                writer.write(String.format("<%s>", value.value));
            }
        } else if (value.type == Value.ValueType.IF) {
            if (size == 2 || size == 3) {
                writer.write(String.format("<%s[", type));
                this.writeValue(writer, values.get(0));
                writer.write("[");
                this.writeValue(writer, values.get(1));
                if (size == 3) {
                    writer.write("/");
                    this.writeValue(writer, values.get(2));
                }
                writer.write("]");
                writer.write("]>");
            }
        } else if (value.type == Value.ValueType.NOT) {
            if (size == 1) {
                writer.write(String.format("<%s[", type));
                this.writeValue(writer, values.get(0));
                writer.write("]>");
            }
        } else if (value.type == Value.ValueType.AND || value.type == Value.ValueType.OR || value.type == Value.ValueType.XOR || value.type == Value.ValueType.CONCAT) {
            writer.write(String.format("<%s[", type));
            this.writeValue(writer, values.get(0));
            if (size > 1) {
                for (int i = 1; i < size; ++i) {
                    writer.write("/");
                    this.writeValue(writer, values.get(i));
                }
            }
            writer.write("]>");
        } else if (value.type == Value.ValueType.GREATER || value.type == Value.ValueType.LESSER || value.type == Value.ValueType.EQUAL) {
            if (size > 1) {
                writer.write(String.format("<%s[", type));
                this.writeValue(writer, values.get(0));
                for (int i = 1; i < size; ++i) {
                    writer.write("/");
                    this.writeValue(writer, values.get(i));
                }
                writer.write("]>");
            }
        } else if (value.type == Value.ValueType.PCT || value.type == Value.ValueType.ADD || value.type == Value.ValueType.SUB || value.type == Value.ValueType.MUL || value.type == Value.ValueType.DIV || value.type == Value.ValueType.ROUND || value.type == Value.ValueType.MOD || value.type == Value.ValueType.MODI) {
            if (size == 2) {
                writer.write(String.format("<%s[", type));
                this.writeValue(writer, values.get(0));
                writer.write("/");
                this.writeValue(writer, values.get(1));
                writer.write("]>");
            }
        } else if (value.type == Value.ValueType.MAX || value.type == Value.ValueType.MIN) {
            if (size == 2 || size == 4) {
                writer.write(String.format("<%s[", type));
                this.writeValue(writer, values.get(0));
                writer.write("/");
                this.writeValue(writer, values.get(1));
                if (size == 4) {
                    writer.write("[");
                    this.writeValue(writer, values.get(2));
                    writer.write("/");
                    this.writeValue(writer, values.get(3));
                    writer.write("]");
                }
                writer.write("]>");
            }
        } else if (value.type == Value.ValueType.ITEMQUANTITY) {
            if (size == 1 || size == 2) {
                writer.write(String.format("<%s[", type));
                this.writeValue(writer, values.get(0));
                if (size == 2) {
                    writer.write("/");
                    this.writeValue(writer, values.get(1));
                }
                writer.write("]>");
            }
        } else if (value.type == Value.ValueType.TRANS) {
            writer.write(String.format("<%s[", type));
            this.writeValue(writer, values.get(0));
            writer.write("]>");
        }
    }
}

