/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import thebombzen.mods.autoswitch.ConfigOption;
import thebombzen.mods.autoswitch.ConfigScreen;
import thebombzen.mods.autoswitch.Configuration;
import thebombzen.mods.autoswitch.NotSoRandom;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfiguration;
import thebombzen.mods.thebombzenapi.client.ThebombzenAPIConfigScreen;

@SideOnly(value=Side.CLIENT)
@Mod(modid="autoswitch", name="AutoSwitch", version="4.3.0", dependencies="required-after:thebombzenapi", guiFactory="thebombzen.mods.autoswitch.GuiFactory")
public class AutoSwitch
extends ThebombzenAPIBaseMod {
    public static final int STAGE_H0 = 0;
    public static final int STAGE_SWITCHED = 1;
    public static final int STAGE_CANCELED = 2;
    public static final Minecraft mc = Minecraft.func_71410_x();
    private int entityAttackStage = 0;
    private EntityLivingBase entitySwitchedOn = null;
    private Configuration configuration;
    private ItemStack prevHeldItemStack;
    private Random prevRandom;
    private boolean prevMouseDown = false;
    private boolean prevPulse = false;
    private int prevtool = 0;
    private boolean pulseOn = false;
    @Mod.Instance(value="autoswitch")
    public static AutoSwitch instance;

    public boolean canHarvestBlock(ItemStack itemstack, Block block, int metadata) {
        if (block == null) {
            return false;
        }
        this.fakeItemForPlayer(itemstack);
        boolean can = block.canHarvestBlock((EntityPlayer)AutoSwitch.mc.field_71439_g, metadata);
        this.unFakeItemForPlayer();
        return can;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        boolean mouseDown;
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        if (AutoSwitch.mc.field_71441_e == null) {
            return;
        }
        if (this.entityAttackStage == 2) {
            AutoSwitch.mc.field_71439_g.func_71038_i();
            AutoSwitch.mc.field_71442_b.func_78764_a((EntityPlayer)AutoSwitch.mc.field_71439_g, (Entity)this.entitySwitchedOn);
            this.entityAttackStage = 0;
            this.entitySwitchedOn = null;
            return;
        }
        this.pulseOn = Keyboard.isKeyDown((int)this.configuration.getPulseKeyCode());
        int keyCode = AutoSwitch.mc.field_71474_y.field_74312_F.func_151463_i();
        boolean bl = mouseDown = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
        if (!mouseDown && this.prevMouseDown || mouseDown && this.pulseOn ^ this.prevPulse) {
            this.switchBack();
        }
        if (mouseDown && !this.prevMouseDown || mouseDown && this.pulseOn ^ this.prevPulse) {
            this.prevtool = AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c;
        }
        if (mouseDown) {
            if (AutoSwitch.mc.field_71476_x != null && AutoSwitch.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.potentiallySwitchTools((World)AutoSwitch.mc.field_71441_e, AutoSwitch.mc.field_71476_x.field_72311_b, AutoSwitch.mc.field_71476_x.field_72312_c, AutoSwitch.mc.field_71476_x.field_72309_d);
            } else if (AutoSwitch.mc.field_71476_x != null && AutoSwitch.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && AutoSwitch.mc.field_71476_x.field_72308_g instanceof EntityLivingBase) {
                this.potentiallySwitchWeapons((EntityLivingBase)AutoSwitch.mc.field_71476_x.field_72308_g);
            }
        }
        this.prevMouseDown = mouseDown;
        this.prevPulse = this.pulseOn;
    }

    public int compareBlockStr(float newBlockStr, float oldBlockStr) {
        if (newBlockStr > oldBlockStr) {
            return 1;
        }
        if (oldBlockStr > newBlockStr) {
            return -1;
        }
        return 0;
    }

    public ThebombzenAPIConfigScreen createConfigScreen(GuiScreen base) {
        return new ConfigScreen(base);
    }

    public ItemStack createStackedBlock(Block block, int metadata) {
        return (ItemStack)ThebombzenAPI.invokePrivateMethod((Object)block, Block.class, (String[])new String[]{"createStackedBlock", "func_149644_j", "j"}, (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{metadata});
    }

    private void debug(String string) {
        this.debug("%s", string);
    }

    private void debug(String format, Object ... args) {
        if (this.configuration.getPropertyBoolean(ConfigOption.DEBUG)) {
            this.forceDebug(format, args);
        }
    }

    public boolean doesFortuneWorkOnBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (block == null) {
            return false;
        }
        if (this.configuration.isFortuneOverriddenToNotWork(block, metadata)) {
            return false;
        }
        if (this.configuration.isFortuneOverriddenToWork(block, metadata)) {
            return true;
        }
        NotSoRandom maxRandom = new NotSoRandom(false);
        NotSoRandom zeroRandom = new NotSoRandom(true);
        this.fakeRandomForWorld(world, maxRandom);
        ArrayList defaultMaxRandom = block.getDrops(world, x, y, z, metadata, 0);
        ArrayList fortuneMaxRandom = block.getDrops(world, x, y, z, metadata, 3);
        this.unFakeRandomForWorld(world);
        this.fakeRandomForWorld(world, zeroRandom);
        ArrayList defaultZeroRandom = block.getDrops(world, x, y, z, metadata, 0);
        ArrayList fortuneZeroRandom = block.getDrops(world, x, y, z, metadata, 3);
        this.unFakeRandomForWorld(world);
        return !ThebombzenAPI.areItemStackCollectionsEqual((Collection)defaultMaxRandom, (Collection)fortuneMaxRandom) || !ThebombzenAPI.areItemStackCollectionsEqual((Collection)defaultZeroRandom, (Collection)fortuneZeroRandom);
    }

    public boolean doesSilkTouchWorkOnBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (block == null) {
            return false;
        }
        if (this.configuration.isSilkTouchOverriddenToNotWork(block, metadata)) {
            return false;
        }
        if (this.configuration.isSilkTouchOverriddenToWork(block, metadata)) {
            return true;
        }
        return block.canSilkHarvest(world, (EntityPlayer)AutoSwitch.mc.field_71439_g, x, y, z, metadata);
    }

    private void fakeItemForPlayer(ItemStack itemstack) {
        this.prevHeldItemStack = AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c];
        AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c] = itemstack;
        if (this.prevHeldItemStack != null) {
            AutoSwitch.mc.field_71439_g.func_110140_aT().func_111148_a(this.prevHeldItemStack.func_111283_C());
        }
        if (itemstack != null) {
            AutoSwitch.mc.field_71439_g.func_110140_aT().func_111147_b(itemstack.func_111283_C());
        }
    }

    private void fakeRandomForWorld(World world, Random random) {
        this.prevRandom = world.field_73012_v;
        world.field_73012_v = random;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return 0.0f;
        }
        return block.func_149712_f(world, x, y, z);
    }

    public float getBlockStrength(ItemStack itemstack, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        this.fakeItemForPlayer(itemstack);
        float str = ForgeHooks.blockStrength((Block)block, (EntityPlayer)AutoSwitch.mc.field_71439_g, (World)world, (int)x, (int)y, (int)z);
        this.unFakeItemForPlayer();
        return str;
    }

    public ThebombzenAPIConfiguration<?> getConfiguration() {
        return this.configuration;
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        return itemstack == null ? 1.0f : itemstack.func_77973_b().getDigSpeed(itemstack, block, metadata);
    }

    public float getEff(float str, ItemStack itemstack) {
        if (str <= 1.5f) {
            return str;
        }
        this.fakeItemForPlayer(itemstack);
        float effLevel = EnchantmentHelper.func_77509_b((EntityLivingBase)AutoSwitch.mc.field_71439_g);
        this.unFakeItemForPlayer();
        if (effLevel == 0.0f) {
            return str;
        }
        return str + effLevel * effLevel + 1.0f;
    }

    public float getEnchantmentModifierLiving(ItemStack itemstack, EntityLivingBase entityover) {
        this.fakeItemForPlayer(itemstack);
        float modifier = EnchantmentHelper.func_77512_a((EntityLivingBase)AutoSwitch.mc.field_71439_g, (EntityLivingBase)entityover);
        this.unFakeItemForPlayer();
        return modifier;
    }

    public String getLongName() {
        return "AutoSwitch";
    }

    public String getLongVersionString() {
        return "AutoSwitch, version 4.3.0, Minecraft 1.7.2";
    }

    public Set<Enchantment> getNonstandardNondamageEnchantmentsOnBothStacks(ItemStack stack1, ItemStack stack2) {
        HashSet bothItemsEnchantments = new HashSet();
        HashSet<Enchantment> ret = new HashSet<Enchantment>();
        if (stack1 != null) {
            bothItemsEnchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)stack1).keySet());
        }
        if (stack2 != null) {
            bothItemsEnchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)stack2).keySet());
        }
        for (Integer effectId : bothItemsEnchantments) {
            if (effectId == Enchantment.field_77349_p.field_77352_x || effectId == Enchantment.field_77348_q.field_77352_x || effectId == Enchantment.field_77346_s.field_77352_x || effectId == Enchantment.field_77347_r.field_77352_x || effectId == Enchantment.field_77335_o.field_77352_x || effectId == Enchantment.field_77337_m.field_77352_x || effectId == Enchantment.field_77334_n.field_77352_x || Enchantment.field_77331_b[effectId].func_77320_a().startsWith("enchantment.damage.")) continue;
            ret.add(Enchantment.field_77331_b[effectId]);
        }
        return ret;
    }

    public int getNumToggleKeys() {
        return 1;
    }

    public String getShortName() {
        return "AS";
    }

    protected String getToggleMessageString(int index, boolean enabled) {
        if (enabled) {
            return "AutoSwitch is now enabled.";
        }
        return "AutoSwitch is now disabled.";
    }

    public int getToolStandardness(ItemStack itemstack, World world, int x, int y, int z) {
        int metadata;
        if (itemstack == null) {
            return 0;
        }
        Block block = world.func_147439_a(x, y, z);
        if (this.configuration.isToolOverriddenAsNotStandardOnBlock(itemstack, block, metadata = world.func_72805_g(x, y, z))) {
            return -2;
        }
        if (this.configuration.isToolOverriddenAsStandardOnBlock(itemstack, block, metadata)) {
            return 2;
        }
        if (this.getBlockHardness(world, x, y, z) != 0.0f && this.getDigSpeed(itemstack, block, metadata) > 1.5f) {
            return 1;
        }
        if (this.isItemStackDamageableOnBlock(itemstack, world, x, y, z)) {
            return -1;
        }
        return 0;
    }

    protected String getVersionFileURLString() {
        return "https://dl.dropboxusercontent.com/u/51080973/Mods/AutoSwitch/ASVersion.txt";
    }

    public boolean hasConfigScreen() {
        return true;
    }

    public boolean instanceOfItemSword(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b() instanceof ItemSword;
    }

    public boolean isItemStackDamageable(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.func_77973_b().func_77645_m();
    }

    public boolean isItemStackDamageableOnBlock(ItemStack itemstack, World world, int x, int y, int z) {
        if (!this.isItemStackDamageable(itemstack)) {
            return false;
        }
        return this.getBlockHardness(world, x, y, z) > 0.0f;
    }

    public boolean isToolBetter(ItemStack newItemStack, ItemStack oldItemStack, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null || block.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        int metadata = world.func_72805_g(x, y, z);
        float newStr = this.getDigSpeed(newItemStack, block, metadata);
        float oldStr = this.getDigSpeed(oldItemStack, block, metadata);
        float newBlockStr = this.getBlockStrength(newItemStack, world, x, y, z);
        float oldBlockStr = this.getBlockStrength(oldItemStack, world, x, y, z);
        if (newBlockStr == 0.0f && oldBlockStr == 0.0f) {
            this.debug("Not switching because block is unbreakable by either item.");
            return false;
        }
        boolean newHarvest = this.canHarvestBlock(newItemStack, block, metadata);
        boolean oldHarvest = this.canHarvestBlock(oldItemStack, block, metadata);
        this.debug("newBlockStr: %f, oldBlockStr %f", Float.valueOf(newBlockStr), Float.valueOf(oldBlockStr));
        this.debug("newHarvest: %b, oldHarvest: %b", newHarvest, oldHarvest);
        this.debug("newStrength: %f, oldStrength: %f", Float.valueOf(newStr), Float.valueOf(oldStr));
        float newEff = this.getEff(newStr, newItemStack);
        float oldEff = this.getEff(oldStr, oldItemStack);
        this.debug("newEff: %f, oldEff: %f", Float.valueOf(newEff), Float.valueOf(oldEff));
        if (this.canHarvestBlock(newItemStack, block, metadata) && !this.canHarvestBlock(oldItemStack, block, metadata)) {
            this.debug("Switching because new can harvest and old can't.");
            return true;
        }
        if (this.canHarvestBlock(oldItemStack, block, metadata) && !this.canHarvestBlock(newItemStack, block, metadata)) {
            this.debug("Not switching because old can harvest and new can't.");
            return false;
        }
        int newStandard = this.getToolStandardness(newItemStack, world, x, y, z);
        int oldStandard = this.getToolStandardness(oldItemStack, world, x, y, z);
        this.debug("newStandard: %d, oldStandard: %d", newStandard, oldStandard);
        boolean newDamageable = this.isItemStackDamageableOnBlock(newItemStack, world, x, y, z);
        boolean oldDamageable = this.isItemStackDamageableOnBlock(oldItemStack, world, x, y, z);
        this.debug("newDamageable: %b, oldDamageable: %b", newDamageable, oldDamageable);
        if (this.configuration.getToolSelectionMode() == 0 || this.configuration.getToolSelectionMode() == 1) {
            if (newStandard > oldStandard) {
                this.debug("Switching because new item is more standard than old.");
                return true;
            }
            if (oldStandard > newStandard) {
                this.debug("Not switching because old item is more standard than new.");
                return false;
            }
            if (newStandard <= 0 && oldStandard <= 0) {
                if (newDamageable && !oldDamageable) {
                    this.debug("Not switching because new tool is damageable and old isn't, and neither are standard.");
                    return false;
                }
                if (oldDamageable && !newDamageable) {
                    this.debug("Switching because old tool is damageable and new isn't, and neither are standard.");
                    return true;
                }
            }
        }
        boolean silkWorks = this.doesSilkTouchWorkOnBlock(world, x, y, z);
        boolean newHasSilk = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)newItemStack) > 0;
        boolean oldHasSilk = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)oldItemStack) > 0;
        this.debug("silkWorks: %b, newHasSilk: %b, oldHasSilk: %b", silkWorks, newHasSilk, oldHasSilk);
        if (newHasSilk && !oldHasSilk) {
            if (silkWorks) {
                this.debug("Switching because new has silk touch and old doesn't, and new works.");
                return true;
            }
            if (oldStandard > 0) {
                this.debug("Not switching because new has silk touch and old doesn't, and old replaces new.");
                return false;
            }
            if (newStandard <= 0) {
                this.debug("Not switching because new has silk touch and old doesn't, and new is weak.");
                return false;
            }
        } else if (oldHasSilk && !newHasSilk) {
            if (silkWorks) {
                this.debug("Not switching because old has silk touch and new doesn't, and old works.");
                return false;
            }
            if (newStandard > 0) {
                this.debug("Switching because old has silk touch and new doesn't, and new replaces old.");
                return true;
            }
            if (oldStandard <= 0) {
                this.debug("Switching because old has silk touch and new doesn't, and old is weak.");
                return true;
            }
        }
        boolean fortuneWorks = this.doesFortuneWorkOnBlock(world, x, y, z);
        int newFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)newItemStack);
        int oldFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)oldItemStack);
        this.debug("fortuneWorks: %b, newFortuneLevel: %d, oldFortuneLevel: %d", fortuneWorks, newFortuneLevel, oldFortuneLevel);
        if (fortuneWorks) {
            if (newFortuneLevel > oldFortuneLevel) {
                this.debug("Switching because new fortune, %d, is more than old, %d.", newFortuneLevel, oldFortuneLevel);
                return true;
            }
            if (oldFortuneLevel > newFortuneLevel) {
                this.debug("Not switching because old fortune, %d, is more than new, %d.", oldFortuneLevel, newFortuneLevel);
                return false;
            }
        }
        int comparison = this.compareBlockStr(newBlockStr, oldBlockStr);
        this.debug("Tool Selection Mode: %s", this.configuration.getProperty(ConfigOption.TOOL_SELECTION_MODE));
        if (this.configuration.getToolSelectionMode() == 0) {
            if (comparison > 0) {
                this.debug("Switching because new tool is stronger.");
                return true;
            }
            if (comparison < 0) {
                this.debug("Not switching because old tool is stronger.");
                return false;
            }
        } else if (this.configuration.getToolSelectionMode() == 1) {
            if (comparison < 0) {
                this.debug("Switching because new item is worse than old item and SLOW STANDARD is on.");
                return true;
            }
            if (comparison > 0) {
                this.debug("Not switching because new item is better than old item and SLOW STANDARD is on.");
                return false;
            }
        } else if (this.configuration.getToolSelectionMode() == 2) {
            if (comparison > 0) {
                this.debug("Switching because new tool is stronger.");
                return true;
            }
            if (comparison < 0) {
                this.debug("Not switching because old tool is stronger.");
                return false;
            }
        }
        Set<Enchantment> bothItemsEnchantments = this.getNonstandardNondamageEnchantmentsOnBothStacks(newItemStack, oldItemStack);
        for (Enchantment enchantment : bothItemsEnchantments) {
            int oldLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)oldItemStack);
            int newLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)newItemStack);
            if (newLevel > oldLevel) {
                this.debug("Switching because new %s level, %d, is more than old, %d.", enchantment.func_77320_a(), newLevel, oldLevel);
                return true;
            }
            if (newLevel >= oldLevel) continue;
            this.debug("Switching because old %s level, %d, is more than new, %d.", enchantment.func_77320_a(), oldLevel, newLevel);
            return false;
        }
        if (newDamageable && !oldDamageable) {
            this.debug("Not switching because new tool is damageable and old isn't.");
            return false;
        }
        if (oldDamageable && !newDamageable) {
            this.debug("Switching because old tool is damageable and new isn't.");
            return true;
        }
        if (newDamageable && oldDamageable) {
            int oldUnbreakingLevel;
            if (newFortuneLevel > oldFortuneLevel) {
                this.debug("Not switching because new fortune is bad and items are damageable.");
                return false;
            }
            if (oldFortuneLevel > newFortuneLevel) {
                this.debug("Switching because old fortune is bad and items are damageable.");
                return true;
            }
            if (newEff <= 1.5f && oldEff > 1.5f) {
                this.debug("Not switching because new item is wrong for the block and damageable, and old is right.");
                return false;
            }
            if (oldEff <= 1.5f && newEff > 1.5f) {
                this.debug("Switching because old item is wrong for the block and damageable, and new is right.");
                return true;
            }
            int newUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)newItemStack);
            if (newUnbreakingLevel > (oldUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)oldItemStack))) {
                this.debug("Switching because new unbreaking is more than old unbreaking.");
                return true;
            }
            if (oldUnbreakingLevel > newUnbreakingLevel) {
                this.debug("Not switching because old unbreaking is more than new unbreaking.");
                return false;
            }
        }
        this.debug("Not switching because tools are equal.");
        return false;
    }

    public boolean isWeaponBetter(ItemStack newItemStack, ItemStack oldItemStack, EntityLivingBase entityover) {
        boolean isPlayer = entityover instanceof EntityPlayer;
        double oldDamage = this.configuration.getCustomWeaponDamage(oldItemStack);
        double newDamage = this.configuration.getCustomWeaponDamage(newItemStack);
        if (oldDamage == -1.0) {
            this.fakeItemForPlayer(oldItemStack);
            oldDamage = AutoSwitch.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            this.unFakeItemForPlayer();
        }
        if (newDamage == -1.0) {
            this.fakeItemForPlayer(newItemStack);
            newDamage = (float)AutoSwitch.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            this.unFakeItemForPlayer();
        }
        this.debug("Old damage is %f, new damage is %f.", oldDamage += (double)this.getEnchantmentModifierLiving(oldItemStack, entityover), newDamage += (double)this.getEnchantmentModifierLiving(newItemStack, entityover));
        if (isPlayer) {
            if (newDamage > oldDamage) {
                this.debug("Switching because new damage is more.");
                return true;
            }
            if (newDamage < oldDamage) {
                this.debug("Not switching because old damage is more.");
                return false;
            }
        } else {
            int oldHits = oldDamage == 0.0 ? Integer.MAX_VALUE : MathHelper.func_76143_f((double)((double)entityover.func_110143_aJ() / oldDamage));
            int newHits = newDamage == 0.0 ? Integer.MAX_VALUE : MathHelper.func_76143_f((double)((double)entityover.func_110143_aJ() / newDamage));
            this.debug("Old hits are %d, new hits are %d", oldHits, newHits);
            if (newHits < oldHits) {
                this.debug("Switching because new hits are fewer.");
                return true;
            }
            if (newHits > oldHits) {
                this.debug("Not switching because old hits are fewer.");
                return false;
            }
        }
        int newLootingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)newItemStack);
        int newFireAspectLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)newItemStack);
        int newKnockbackLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)newItemStack);
        int newUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)newItemStack);
        int oldLootingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)oldItemStack);
        int oldFireAspectLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)oldItemStack);
        int oldKnockbackLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)oldItemStack);
        int oldUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)oldItemStack);
        if (!isPlayer) {
            if (newLootingLevel > oldLootingLevel) {
                this.debug("Switching because new looting, %d, is more than old, %d.", newLootingLevel, oldLootingLevel);
                return true;
            }
            if (oldLootingLevel > newLootingLevel) {
                this.debug("Not switching because old looting, %d, is more than new, %d.", oldLootingLevel, newLootingLevel);
                return false;
            }
        }
        if (newFireAspectLevel > oldFireAspectLevel) {
            this.debug("Switching because new fire aspect, %d, is more than old, %d.", newFireAspectLevel, oldFireAspectLevel);
            return true;
        }
        if (oldFireAspectLevel > newFireAspectLevel) {
            this.debug("Not switching because old fire aspect, %d, is more than new, %d.", oldFireAspectLevel, newFireAspectLevel);
            return false;
        }
        if (newKnockbackLevel > oldKnockbackLevel) {
            this.debug("Switching because new knockback, %d, is more than old, %d.", newKnockbackLevel, oldKnockbackLevel);
            return true;
        }
        if (oldKnockbackLevel > newKnockbackLevel) {
            this.debug("Not switching because old knockback, %d, is more than new, %d.", oldKnockbackLevel, newKnockbackLevel);
            return false;
        }
        Set<Enchantment> bothItemsEnchantments = this.getNonstandardNondamageEnchantmentsOnBothStacks(newItemStack, oldItemStack);
        for (Enchantment enchantment : bothItemsEnchantments) {
            int oldLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)oldItemStack);
            int newLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)newItemStack);
            if (newLevel > oldLevel) {
                this.debug("Switching because new %s level, %d, is more than old, %d.", enchantment.func_77320_a(), newLevel, oldLevel);
                return true;
            }
            if (newLevel >= oldLevel) continue;
            this.debug("Switching because old %s level, %d, is more than new, %d.", enchantment.func_77320_a(), oldLevel, newLevel);
            return false;
        }
        if (this.instanceOfItemSword(newItemStack) && !this.instanceOfItemSword(oldItemStack)) {
            this.debug("Switching because new weapon is sword and old isn't.");
            return true;
        }
        if (this.instanceOfItemSword(oldItemStack) && !this.instanceOfItemSword(newItemStack)) {
            this.debug("Not switching because old weapon is sword and new isn't.");
            return false;
        }
        boolean newDamageable = this.isItemStackDamageable(newItemStack);
        boolean oldDamageable = this.isItemStackDamageable(oldItemStack);
        this.debug("newDamageable: %b, oldDamageable: %b", newDamageable, oldDamageable);
        if (newDamageable && !oldDamageable) {
            this.debug("Not switching because new weapon is damageable and old isn't.");
            return false;
        }
        if (oldDamageable && !newDamageable) {
            this.debug("Switching because new weapon is not damageable and old is.");
            return true;
        }
        if (newDamageable && oldDamageable && newUnbreakingLevel > oldUnbreakingLevel) {
            this.debug("Switching because new unbreaking, %d, is more than old, %d.", newUnbreakingLevel, oldUnbreakingLevel);
            return true;
        }
        if (newDamageable && oldDamageable && oldUnbreakingLevel > newUnbreakingLevel) {
            this.debug("Not switching because old unbreaking, %d, is more than new, %d.", oldUnbreakingLevel, newUnbreakingLevel);
            return false;
        }
        if (newDamage > oldDamage) {
            this.debug("Switching because new damage is more and all else is equal.");
            return true;
        }
        if (newDamage < oldDamage) {
            this.debug("Not switching because old damage is more and all else is equal.");
            return false;
        }
        if (newItemStack == null && oldItemStack != null) {
            this.debug("Switching because new tool is fist and old is useless.");
            return true;
        }
        if (oldItemStack == null && newItemStack != null) {
            this.debug("Not switching because old tool is fist and new is useless.");
            return false;
        }
        this.debug("Not switching because weapons are equal.");
        return false;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent fmlie) {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityAttack(AttackEntityEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.entityAttackStage == 1 && this.entitySwitchedOn == event.target) {
            this.entityAttackStage = 2;
            event.setCanceled(true);
        } else if (this.entityAttackStage != 2) {
            this.entitySwitchedOn = null;
            this.entityAttackStage = 0;
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        try {
            this.getConfiguration().load();
        }
        catch (IOException ioe) {
            this.throwException("Unable to open configuration!", ioe, true);
        }
    }

    public boolean potentiallySwitchTools(World world, int x, int y, int z) {
        if (this.pulseOn == this.isToggleEnabled(0) || AutoSwitch.mc.field_71439_g.field_71075_bZ.field_75098_d && !this.configuration.getPropertyBoolean(ConfigOption.USE_IN_CREATIVE) || AutoSwitch.mc.field_71462_r != null || mc.func_71356_B() && !this.configuration.getPropertyBoolean(ConfigOption.BLOCKS_SP) || !mc.func_71356_B() && !this.configuration.getPropertyBoolean(ConfigOption.BLOCKS_MP)) {
            return false;
        }
        this.debug("====================================================");
        this.debug(this.getLongVersionString());
        this.debug("Switching on block, x = %d, y = %d, z = %d", x, y, z);
        try {
            this.switchToBestTool((World)AutoSwitch.mc.field_71441_e, x, y, z);
            return true;
        }
        catch (Throwable e) {
            this.throwException("Error switching tools", e, false);
            return false;
        }
    }

    public boolean potentiallySwitchWeapons(EntityLivingBase entity) {
        if (this.pulseOn == this.isToggleEnabled(0) || AutoSwitch.mc.field_71439_g.field_71075_bZ.field_75098_d && !this.configuration.getPropertyBoolean(ConfigOption.USE_IN_CREATIVE) || AutoSwitch.mc.field_71462_r != null || mc.func_71356_B() && !this.configuration.getPropertyBoolean(ConfigOption.MOBS_SP) || !mc.func_71356_B() && !this.configuration.getPropertyBoolean(ConfigOption.MOBS_MP)) {
            return false;
        }
        this.debug("====================================================");
        this.debug(this.getLongVersionString());
        this.debug("Switching on an entity, %s", entity.toString());
        try {
            this.entitySwitchedOn = entity;
            this.entityAttackStage = 1;
            this.switchToBestWeapon((EntityPlayer)AutoSwitch.mc.field_71439_g, entity);
            return true;
        }
        catch (Throwable e) {
            this.throwException("Error switching weapons", e, false);
            return false;
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configuration = new Configuration(this);
    }

    private void switchBack() {
        if (AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c != this.prevtool) {
            AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c = this.prevtool;
            this.debug("Switching tools back to %d", this.prevtool);
        }
    }

    private void switchToBestTool(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Block)block);
        String name = String.format("%s:%s", id.modId, id.name);
        this.debug("Testing vs block %s", name);
        String[] names = new String[9];
        for (int i = 0; i < 9; ++i) {
            if (AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i] == null) {
                names[i] = "null";
            } else {
                GameRegistry.UniqueIdentifier itemID = GameRegistry.findUniqueIdentifierFor((Item)AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i].func_77973_b());
                names[i] = String.format("%s:%s", itemID.modId, itemID.name);
            }
            this.debug("Hotbar slot %d contains item %s", i, names[i]);
        }
        int currentBest = this.prevtool;
        this.debug("Block hardness is %f", Float.valueOf(this.getBlockHardness(world, x, y, z)));
        for (int i = 0; i < 9; ++i) {
            if (i == currentBest) continue;
            this.debug("Checking if tool %d, which is %s, is better than %d, which is %s", i, names[i], currentBest, names[currentBest]);
            if (!this.isToolBetter(AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i], AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[currentBest], world, x, y, z)) continue;
            this.debug("Changing possible best tool.");
            currentBest = i;
        }
        this.debug("Current best is %d, which is %s", currentBest, names[currentBest]);
        this.switchToolsToN(currentBest == -1 ? AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c : currentBest);
    }

    private void switchToBestWeapon(EntityPlayer entityplayer, EntityLivingBase entityover) {
        ItemStack[] inventory = entityplayer.field_71071_by.field_70462_a;
        String[] names = new String[9];
        for (int i = 0; i < 9; ++i) {
            if (AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i] == null) {
                names[i] = "null";
            } else {
                GameRegistry.UniqueIdentifier itemID = GameRegistry.findUniqueIdentifierFor((Item)AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i].func_77973_b());
                names[i] = String.format("%s:%s", itemID.modId, itemID.name);
            }
            this.debug("Hotbar slot %d contains item %s", i, names[i]);
        }
        int currentBest = this.prevtool;
        this.debug("Current item is %d", entityplayer.field_71071_by.field_70461_c);
        this.debug("Setting possible best weapon to %d, which is %s", currentBest, names[currentBest]);
        for (int i = 0; i < 9; ++i) {
            this.debug("Checking if weapon %d, which is %s, is better than %d, which is %s", i, names[i], currentBest, names[currentBest]);
            if (!this.isWeaponBetter(inventory[i], inventory[currentBest], entityover)) continue;
            this.debug("Changing possible best weapon because weapon is better.");
            currentBest = i;
        }
        this.switchToolsToN(currentBest);
    }

    private void switchToolsToN(int n) {
        EntityClientPlayerMP entityplayer = AutoSwitch.mc.field_71439_g;
        entityplayer.field_71071_by.field_70461_c = n;
        String name = entityplayer.field_71071_by.field_70462_a[n] == null ? "Nothing" : entityplayer.field_71071_by.field_70462_a[n].func_77977_a();
        this.debug("Switching tools to %d, which is %s", n, name);
    }

    private void unFakeItemForPlayer() {
        ItemStack fakedStack = AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c];
        AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c] = this.prevHeldItemStack;
        if (fakedStack != null) {
            AutoSwitch.mc.field_71439_g.func_110140_aT().func_111148_a(fakedStack.func_111283_C());
        }
        if (this.prevHeldItemStack != null) {
            AutoSwitch.mc.field_71439_g.func_110140_aT().func_111147_b(this.prevHeldItemStack.func_111283_C());
        }
    }

    private void unFakeRandomForWorld(World world) {
        world.field_73012_v = this.prevRandom;
        this.prevRandom = null;
    }
}

