/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thebombzen.mods.autoswitch.ValueSet;

public class BlockItemIdentifier {
    public static final int ALL = 0;
    public static final int NAME = 1;
    public static final int CLASS = 2;
    public static final int MATERIAL = 3;
    private String namespace;
    private String name;
    private ValueSet[] damageValues;
    private int type;

    public static BlockItemIdentifier parseBlockItemIdentifier(String info) {
        String name;
        String namespace;
        Scanner scanner = new Scanner(info);
        scanner.useDelimiter("(?<=[^\\+-])(?=[\\+-])");
        char type = info.charAt(0);
        if (!scanner.hasNext()) {
            scanner.close();
            return new BlockItemIdentifier(0, new ValueSet[0]);
        }
        String fullname = scanner.next();
        if (fullname.startsWith("@") || fullname.startsWith("&")) {
            fullname = fullname.substring(1);
        }
        if (fullname.length() == 0) {
            namespace = "";
            name = "";
        } else {
            int index = fullname.indexOf(58);
            if (index < 0) {
                namespace = "minecraft";
                name = fullname;
            } else {
                namespace = fullname.substring(0, index);
                name = fullname.substring(index + 1);
            }
        }
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        while (scanner.hasNext()) {
            String s = scanner.next();
            ValueSet valueSet = ValueSet.parseValueSet(s);
            valueSets.add(valueSet);
        }
        scanner.close();
        ValueSet[] sets = valueSets.toArray(new ValueSet[valueSets.size()]);
        if (fullname.length() == 0) {
            return new BlockItemIdentifier(0, sets);
        }
        switch (type) {
            case '@': {
                return new BlockItemIdentifier(2, namespace, name, sets);
            }
            case '&': {
                return new BlockItemIdentifier(3, namespace, name, sets);
            }
        }
        return new BlockItemIdentifier(1, namespace, name, sets);
    }

    public BlockItemIdentifier(int type, String namespace, String name, int damageValue) {
        this(type, namespace, name, new ValueSet(damageValue, false));
    }

    public BlockItemIdentifier(int type, String namespace, String name, ValueSet ... damageValues) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.namespace = namespace;
        this.name = name;
        if (damageValues.length == 0) {
            damageValues = new ValueSet[]{new ValueSet()};
        }
        this.damageValues = damageValues;
    }

    public BlockItemIdentifier(int type, ValueSet ... damageValues) {
        this(type, "", "", damageValues);
    }

    public boolean contains(Block block, int metadata) {
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Block)block);
        return this.contains(id.modId, id.name, metadata);
    }

    public boolean contains(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
        return this.contains(id.modId, id.name, itemStack.func_77960_j());
    }

    public boolean contains(String namespace, String name, int damageValue) {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getName().equals(name) && this.getNamespace().equals(namespace)) break;
                return false;
            }
            case 2: {
                Block block = GameRegistry.findBlock((String)namespace, (String)name);
                if (block != null && this.getBlock() != null) {
                    if (this.getBlock().getClass().isAssignableFrom(block.getClass())) break;
                    return false;
                }
                Item item = GameRegistry.findItem((String)namespace, (String)name);
                if (item != null && this.getItem() != null) {
                    if (this.getItem().getClass().isAssignableFrom(item.getClass())) break;
                    return false;
                }
                return false;
            }
            case 3: {
                Block block = GameRegistry.findBlock((String)namespace, (String)name);
                if (block == null || this.getBlock() == null) {
                    return false;
                }
                if (this.getBlock().func_149688_o().equals(block.func_149688_o())) break;
                return false;
            }
        }
        for (int i = this.damageValues.length - 1; i >= 0; --i) {
            int testDamageValue = damageValue;
            if (this.damageValues[i].getMask() < 0) {
                testDamageValue = GameRegistry.findItem((String)namespace, (String)name).func_77612_l() - damageValue;
            }
            if (!this.damageValues[i].contains(testDamageValue)) continue;
            return !this.damageValues[i].doesSubtract();
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockItemIdentifier other = (BlockItemIdentifier)obj;
        if (!Arrays.equals(this.damageValues, other.damageValues)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return this.type == other.type;
    }

    public Block getBlock() {
        return GameRegistry.findBlock((String)this.namespace, (String)this.name);
    }

    public ValueSet[] getDamageValues() {
        return this.damageValues;
    }

    public Item getItem() {
        return GameRegistry.findItem((String)this.namespace, (String)this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.damageValues);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean isBlock() {
        return this.getBlock() != null;
    }

    public boolean isItem() {
        return this.getItem() != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        switch (this.type) {
            case 0: 
            case 2: {
                builder.append('@');
                break;
            }
            case 3: {
                builder.append('&');
            }
        }
        if (this.namespace.length() != 0) {
            builder.append(this.namespace).append(":");
        }
        builder.append(this.name);
        for (int i = 0; i < this.damageValues.length; ++i) {
            builder.append(this.damageValues[i]);
        }
        return builder.toString();
    }
}

