/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch;

import thebombzen.mods.thebombzenapi.ThebombzenAPIConfigOption;

public enum ConfigOption implements ThebombzenAPIConfigOption
{
    DEFAULT_ENABLED(0, 0, "true", "Enabled by default", "This option determines whether to", "enable AutoSwitch on new worlds", "and on worlds AutoSwitch hasn't", "been used on before."),
    TOOL_SELECTION_MODE(-1, 2, "FAST STANDARD", "Tool Selection Mode", "FAST STANDARD picks the best standard tool,", "    where faster is better.", "SLOW STANDARD picks the best standard tool,", "    where slower is better.", "FAST NONSTANDARD picks the best tool,", "    ignoring what's standard."),
    BLOCKS_SP(-1, 0, "true", "Use on blocks in SP", "This option determines whether to use", "AutoSwitch on blocks in singleplayer."),
    BLOCKS_MP(-1, 0, "true", "Use on blocks in MP", "This option determines whether to use", "AutoSwitch on blocks in multiplayer."),
    MOBS_SP(-1, 0, "true", "Use on entities in SP", "This option determines whether to use", "AutoSwitch on entities in singleplayer."),
    MOBS_MP(-1, 0, "true", "Use on entities in MP", "This option determines whether to use", "AutoSwitch on entities in multiplayer."),
    TOGGLE_KEY(-1, 1, "F10", "AutoSwitch Toggle Key", "This key toggles AutoSwitch."),
    PULSE_KEY(-1, 1, "V", "AutoSwitch Pulse Key", "This key temporarily toggles", "AutoSwitch while it's held down."),
    DEBUG(-1, 0, "false", "Debug Logging", "Log debug output to", ".minecraft/mods/AutoSwitch/DEBUG.txt"),
    USE_IN_CREATIVE(-1, 0, "true", "Use in creative", "Use AutoSwitch when in creative mode");

    private static final String[] TOOL_SELECTION_MODE_OPTIONS;
    private int defaultToggleIndex;
    private String defaultValue;
    private String[] info;
    private int optionType;
    private String shortInfo;

    private ConfigOption(int defaultToggleIndex, int optionType, String defaultValue, String shortInfo, String ... info) {
        this.optionType = optionType;
        this.defaultToggleIndex = defaultToggleIndex;
        this.defaultValue = defaultValue;
        this.shortInfo = shortInfo;
        this.info = info;
    }

    public int getDefaultToggleIndex() {
        return this.defaultToggleIndex;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getFiniteStringOptions() {
        if (this.optionType != 2) {
            throw new UnsupportedOperationException("This isn't a finite String!");
        }
        if (this.equals((Object)TOOL_SELECTION_MODE)) {
            return TOOL_SELECTION_MODE_OPTIONS;
        }
        return null;
    }

    public String[] getInfo() {
        return this.info;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public String getShortInfo() {
        return this.shortInfo;
    }

    static {
        TOOL_SELECTION_MODE_OPTIONS = new String[]{"FAST STANDARD", "SLOW STANDARD", "FAST NONSTANDARD"};
    }
}

