/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import thebombzen.mods.autoswitch.AutoSwitch;
import thebombzen.mods.autoswitch.BlockItemIdentifier;
import thebombzen.mods.autoswitch.BlockToolPair;
import thebombzen.mods.autoswitch.ConfigOption;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfigOption;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfiguration;

public class Configuration
extends ThebombzenAPIConfiguration<ConfigOption> {
    public static final int CONFIG_VERSION = 1;
    public static final int FAST_STANDARD = 0;
    public static final int SLOW_STANDARD = 1;
    public static final int FAST_NONSTANDARD = 2;
    private Map<BlockItemIdentifier, Integer> customWeapons = new HashMap<BlockItemIdentifier, Integer>();
    private final String defaultConfig;
    private File extraConfigFile;
    private long extraConfigLastModified;
    private Set<BlockItemIdentifier> fortuneNoWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> fortuneWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockToolPair> notStandardBlocksAndTools = new HashSet<BlockToolPair>();
    private Set<BlockItemIdentifier> silkTouchNoWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> silkTouchWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockToolPair> standardBlocksAndTools = new HashSet<BlockToolPair>();

    private static boolean doesSetContainBlock(Set<BlockItemIdentifier> set, Block block, int metadata) {
        for (BlockItemIdentifier test : set) {
            if (!test.contains(block, metadata)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(AutoSwitch autoSwitch) {
        super((ThebombzenAPIBaseMod)autoSwitch, ConfigOption.class);
        this.extraConfigFile = new File(new File(ThebombzenAPI.sideSpecificUtilities.getMinecraftDirectory(), "config"), "AutoSwitch_Overrides.cfg");
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(ThebombzenAPI.getResourceAsStream((Object)((Object)autoSwitch), (String)"AutoSwitch_Overrides.cfg")));
            while (null != (line = reader.readLine())) {
                builder.append(line).append(ThebombzenAPI.newLine);
            }
            reader.close();
        }
        catch (IOException ioe) {
            autoSwitch.throwException("Could not read default config!", ioe, true);
        }
        finally {
            this.defaultConfig = builder.toString();
        }
    }

    public int getCustomWeaponDamage(ItemStack itemstack) {
        if (itemstack == null) {
            return -1;
        }
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)itemstack.func_77973_b());
        for (BlockItemIdentifier itemID : this.customWeapons.keySet()) {
            if (!itemID.contains(id.modId, id.name, itemstack.func_77960_j())) continue;
            return this.customWeapons.get(itemID);
        }
        return -1;
    }

    public File getExtraConfigFile() {
        return this.extraConfigFile;
    }

    public int getPulseKeyCode() {
        return Keyboard.getKeyIndex((String)this.getProperty(ConfigOption.PULSE_KEY));
    }

    public int getToggleKeyCode() {
        return Keyboard.getKeyIndex((String)this.getProperty(ConfigOption.TOGGLE_KEY));
    }

    public int getToolSelectionMode() {
        int toolSelectionMode = 0;
        if (this.getProperty(ConfigOption.TOOL_SELECTION_MODE).equalsIgnoreCase("Fast Standard")) {
            toolSelectionMode = 0;
        } else if (this.getProperty(ConfigOption.TOOL_SELECTION_MODE).equalsIgnoreCase("Slow Standard")) {
            toolSelectionMode = 1;
        } else if (this.getProperty(ConfigOption.TOOL_SELECTION_MODE).equalsIgnoreCase("Fast Nonstandard")) {
            toolSelectionMode = 2;
        } else {
            this.setToolSelectionMode(0);
        }
        return toolSelectionMode;
    }

    public boolean isFortuneOverriddenToNotWork(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.fortuneNoWorks, block, metadata);
    }

    public boolean isFortuneOverriddenToWork(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.fortuneWorks, block, metadata);
    }

    public boolean isSilkTouchOverriddenToNotWork(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.silkTouchNoWorks, block, metadata);
    }

    public boolean isSilkTouchOverriddenToWork(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.silkTouchWorks, block, metadata);
    }

    public boolean isToolOverriddenAsNotStandardOnBlock(ItemStack tool, Block block, int metadata) {
        for (BlockToolPair pair : this.notStandardBlocksAndTools) {
            if (!pair.getBlock().contains(block, metadata) || !pair.getTool().contains(tool)) continue;
            return true;
        }
        return false;
    }

    public boolean isToolOverriddenAsStandardOnBlock(ItemStack tool, Block block, int metadata) {
        for (BlockToolPair pair : this.standardBlocksAndTools) {
            if (!pair.getBlock().contains(block, metadata) || !pair.getTool().contains(tool)) continue;
            return true;
        }
        return false;
    }

    protected void loadProperties() throws IOException {
        String s;
        super.loadProperties();
        AutoSwitch.instance.setToggleKeyCode(0, this.getToggleKeyCode());
        if (!this.extraConfigFile.exists()) {
            this.writeExtraConfig();
            this.parseConfig(this.defaultConfig);
            return;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(this.extraConfigFile));
        while (null != (s = reader.readLine())) {
            sb.append(s).append(ThebombzenAPI.newLine);
        }
        reader.close();
        this.parseConfig(sb.toString());
        this.extraConfigLastModified = this.getExtraConfigFile().lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseConfig(String config) {
        this.fortuneNoWorks.clear();
        this.fortuneWorks.clear();
        this.notStandardBlocksAndTools.clear();
        this.silkTouchNoWorks.clear();
        this.silkTouchWorks.clear();
        this.standardBlocksAndTools.clear();
        this.customWeapons.clear();
        Scanner s = new Scanner(config);
        s.useDelimiter(ThebombzenAPI.newLine);
        int version = -1;
        while (s.hasNext()) {
            String line = s.next();
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            if ((line = line.replaceAll("\\s", "")).length() == 0) continue;
            if (line.length() < 2) {
                AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                continue;
            }
            char first = line.charAt(0);
            switch (first) {
                case 'R': 
                case 'r': {
                    String sub = line.substring(1);
                    try {
                        version = Integer.parseInt(sub);
                    }
                    catch (NumberFormatException nfe) {
                        version = -1;
                    }
                    if (version == 1) break;
                    try {
                        this.writeExtraConfig();
                    }
                    catch (IOException ioe) {
                        this.mod.throwException("Could not write config file!", (Throwable)ioe, true);
                    }
                    finally {
                        this.parseConfig(this.defaultConfig);
                    }
                    s.close();
                    return;
                }
                case 'T': 
                case 't': {
                    char second = line.charAt(1);
                    if (second == '>') {
                        this.silkTouchWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        break;
                    }
                    if (second == '<') {
                        this.silkTouchNoWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        break;
                    }
                    AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                    break;
                }
                case 'F': 
                case 'f': {
                    char second = line.charAt(1);
                    if (second == '>') {
                        this.fortuneWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        break;
                    }
                    if (second == '<') {
                        this.fortuneNoWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        break;
                    }
                    AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                    break;
                }
                case 'S': {
                    int indexP = line.indexOf(62);
                    int indexM = line.indexOf(60);
                    String toolSub = "";
                    String blockSub = "";
                    boolean plus = false;
                    if (indexP != -1 && (indexM == -1 || indexP < indexM)) {
                        toolSub = line.substring(1, indexP);
                        blockSub = line.substring(indexP + 1);
                        plus = true;
                    } else if (indexM != -1 && (indexP == -1 || indexM < indexP)) {
                        toolSub = line.substring(1, indexM);
                        blockSub = line.substring(indexM + 1);
                        plus = false;
                    } else {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        break;
                    }
                    BlockItemIdentifier block = BlockItemIdentifier.parseBlockItemIdentifier(blockSub);
                    BlockItemIdentifier tool = BlockItemIdentifier.parseBlockItemIdentifier(toolSub);
                    (plus ? this.standardBlocksAndTools : this.notStandardBlocksAndTools).add(new BlockToolPair(block, tool));
                    break;
                }
                case 'W': {
                    int indexP = line.lastIndexOf(62);
                    if (indexP < 0 || indexP >= line.length() - 1) {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        break;
                    }
                    String sub = line.substring(1, indexP);
                    String damageString = line.substring(indexP);
                    Integer damage = null;
                    try {
                        damage = ThebombzenAPI.parseInteger((String)damageString);
                    }
                    catch (NumberFormatException nfe) {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        break;
                    }
                    BlockItemIdentifier tool = BlockItemIdentifier.parseBlockItemIdentifier(sub);
                    this.customWeapons.put(tool, damage);
                }
            }
        }
        if (version != 1) {
            try {
                this.writeExtraConfig();
            }
            catch (IOException ioe) {
                this.mod.throwException("Could not write config file!", (Throwable)ioe, true);
            }
            finally {
                this.parseConfig(this.defaultConfig);
            }
        }
        s.close();
        System.out.println(this.notStandardBlocksAndTools.toString());
    }

    protected void setPropertyWithoutSave(ThebombzenAPIConfigOption option, String value) {
        super.setPropertyWithoutSave(option, value);
        if (option.equals((Object)ConfigOption.TOGGLE_KEY)) {
            this.mod.setToggleKeyCode(0, Keyboard.getKeyIndex((String)value));
        }
    }

    public void setToolSelectionMode(int mode) {
        if (mode == 0) {
            this.setProperty(ConfigOption.TOOL_SELECTION_MODE, "FAST STANDARD");
        } else if (mode == 1) {
            this.setProperty(ConfigOption.TOOL_SELECTION_MODE, "SLOW STANDARD");
        } else if (mode == 2) {
            this.setProperty(ConfigOption.TOOL_SELECTION_MODE, "FAST NONSTANDARD");
        } else {
            this.setToolSelectionMode(0);
        }
    }

    public boolean shouldRefreshConfig() {
        if (super.shouldRefreshConfig()) {
            return true;
        }
        return this.extraConfigLastModified != this.getExtraConfigFile().lastModified();
    }

    private void writeExtraConfig() throws IOException {
        FileWriter writer = new FileWriter(this.extraConfigFile);
        writer.write(this.defaultConfig);
        writer.flush();
        writer.close();
    }
}

