/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch;

import java.util.Scanner;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;

public class ValueSet {
    private int data;
    private int mask;
    private boolean subtract;

    public static ValueSet parseValueSet(String s) {
        int mask;
        boolean subtract;
        switch (s.charAt(0)) {
            case '+': {
                subtract = false;
                break;
            }
            case '-': {
                subtract = true;
                break;
            }
            default: {
                throw new NumberFormatException();
            }
        }
        Scanner scanner = new Scanner(s.substring(1));
        scanner.useDelimiter(":");
        if (!scanner.hasNext()) {
            scanner.close();
            return new ValueSet(0, 0, subtract);
        }
        String num = scanner.next();
        int data = ThebombzenAPI.parseInteger((String)num);
        if (scanner.hasNext()) {
            num = scanner.next();
            mask = ThebombzenAPI.parseInteger((String)num);
        } else {
            mask = Integer.MAX_VALUE;
        }
        scanner.close();
        return new ValueSet(data, mask, subtract);
    }

    public ValueSet() {
        this(0, 0, false);
    }

    public ValueSet(int value, boolean subtract) {
        this(value, Integer.MAX_VALUE, subtract);
    }

    public ValueSet(int data, int mask, boolean subtract) {
        this.data = data;
        this.mask = mask;
        this.subtract = subtract;
    }

    public boolean contains(int value) {
        return (value & this.mask) == this.data;
    }

    public boolean doesSubtract() {
        return this.subtract;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSet other = (ValueSet)obj;
        if (this.data != other.data) {
            return false;
        }
        if (this.subtract != other.subtract) {
            return false;
        }
        return this.mask == other.mask;
    }

    public int getData() {
        return this.data;
    }

    public int getMask() {
        return this.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.data;
        result = 31 * result + (this.subtract ? 1231 : 1237);
        result = 31 * result + this.mask;
        return result;
    }

    public String toString() {
        return (this.subtract ? (char)'-' : '+') + "0x" + Integer.toHexString(this.data) + (this.mask != Integer.MAX_VALUE ? ":0x" + Integer.toHexString(this.mask) : "");
    }
}

