/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.minecraft;

import com.slatebit.paintball.common.Paintball;
import com.slatebit.paintball.common.TileEntityGearRack;
import com.slatebit.paintball.common.TileEntityMedKit;
import com.slatebit.paintball.common.TileEntityObject;
import com.slatebit.paintball.common.TileEntityPod;
import com.slatebit.paintball.common.TileEntityWeaponRack;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderObject
extends TileEntitySpecialRenderer {
    private Minecraft client = FMLClientHandler.instance().getClient();
    private ModelBase modelBase;
    private String type;

    public RenderObject(ModelBase modelBase, String type) {
        this.modelBase = modelBase;
        this.type = type;
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTickTime) {
        TileEntityObject tileEntityObject = (TileEntityObject)tileEntity;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(x + 0.5)), (float)((float)(y + 1.5)), (float)((float)(z + 0.5)));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.type == "Claymore") {
            GL11.glRotatef((float)(tileEntityObject.direction * 360 / 16 + 180), (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (this.type != "Flag") {
            GL11.glRotatef((float)(90 * tileEntityObject.direction), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)(90 * tileEntityObject.direction + 180), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        int cooldown = tileEntityObject.cooldown;
        String texture = "";
        if (tileEntityObject instanceof TileEntityPod) {
            texture = ((TileEntityPod)tileEntityObject).getTexture(cooldown);
        } else if (tileEntityObject instanceof TileEntityMedKit) {
            texture = ((TileEntityMedKit)tileEntityObject).getTexture(cooldown);
        } else if (tileEntityObject instanceof TileEntityWeaponRack) {
            texture = ((TileEntityWeaponRack)tileEntityObject).getTexture(cooldown);
        } else if (tileEntityObject instanceof TileEntityGearRack) {
            texture = ((TileEntityGearRack)tileEntityObject).getTexture(cooldown);
        }
        this.client.func_110434_K().func_110577_a(new ResourceLocation("paintball:textures/models/entities/" + Paintball.COLOR_MAP.get(tileEntity.func_145832_p()).toLowerCase() + "/" + this.type + texture + ".png"));
        this.modelBase.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }
}

