/*
 * Decompiled with CFR 0.152.
 */
package deconstruction.common;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import deconstruction.common.BlockDeconstructionTable;
import deconstruction.common.CommonProxy;
import deconstruction.common.DeconEventHooks;
import deconstruction.common.GuiHandler;
import deconstruction.common.Resources;
import deconstruction.common.UpdateHandler;
import deconstruction.deconTable.PacketHandler;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Logger;

@Mod(modid="deconstruction", name="Deconstruction Mod", version="2.1.0")
public class mod_Deconstruction {
    public static int[] DisabledIDS = new int[1];
    public static String[] DisabledRecipes;
    public static Block deconstructionTable;
    private GuiHandler guiHandler = new GuiHandler();
    public static Logger log;
    @Mod.Instance(value="deconstruction")
    public static mod_Deconstruction instance;
    @SidedProxy(clientSide="deconstruction.client.ClientProxy", serverSide="deconstruction.common.CommonProxy")
    public static CommonProxy proxy;

    public static boolean isIDBlacklisted(int id) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : DisabledIDS) {
            list.add(i);
        }
        return list.contains(id);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DeconEventHooks());
        log = event.getModLog();
        Configuration config = null;
        File cfgFile = new File(Loader.instance().getConfigDir(), "deconstruction.cfg");
        try {
            config = new Configuration(cfgFile);
            log.info("Config loaded from " + cfgFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.warn("Error while trying to access configuration! " + e);
            config = null;
        }
        if (config != null) {
            Property prop = config.get("Update Checker", "Enable Update Checks?", true);
            prop.comment = "Will Deconstruction Table look for updates when it launches?";
            Resources.CHECK_FOR_UPDATES = prop.getBoolean(true);
            prop = config.get("Update Checker", "Last Remote Version", Resources.LAST_DISCOVERED_VERSION);
            prop.comment = "The last version the update checker has found from the remote source";
            Resources.LAST_DISCOVERED_VERSION = prop.getString();
            prop = config.get("Update Checker", "Attempts", Resources.VERSION_CHECK_ATTEMPTS);
            prop.comment = "The ammount of attempts the update checker makes to find an available update before it gives up.";
            Resources.VERSION_CHECK_ATTEMPTS = prop.getInt();
            if (config.hasChanged()) {
                config.save();
            }
        }
        deconstructionTable = new BlockDeconstructionTable().func_149663_c("deconstructionTable");
        GameRegistry.registerBlock((Block)deconstructionTable, (String)"deconstructiondeconstructionTable.name");
        GameRegistry.addRecipe((ItemStack)new ItemStack(deconstructionTable, 1), (Object[])new Object[]{"BDB", "ACA", "AAA", Character.valueOf('A'), Blocks.field_150344_f, Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('D'), Items.field_151045_i});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
    }

    private void dispLowPermsScreen(String username) {
        while (true) {
            // Infinite loop
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        NetworkRegistry.INSTANCE.newChannel("DeconTable|RecSel", new ChannelHandler[]{new PacketHandler()});
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        UpdateHandler.execute();
    }

    public void setLastRemoteVers(String remoteVersion) {
        Resources.LAST_DISCOVERED_VERSION = remoteVersion;
    }
}

