/*
 * Decompiled with CFR 0.152.
 */
package magicwands;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class WandCoord3D {
    public int x;
    public int y;
    public int z;
    public int meta;
    public Block id;

    public WandCoord3D() {
        this(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public WandCoord3D(int i, int j, int k, int met) {
        this.x = i;
        this.y = j;
        this.z = k;
        this.meta = met;
    }

    public WandCoord3D(int i, int j, int k, Block ID, int met) {
        this(i, j, k, met);
        this.id = ID;
    }

    public WandCoord3D(int i, int j, int k, int ID, int met) {
        this(i, j, k, met);
        this.id = Block.func_149729_e((int)ID);
    }

    public WandCoord3D(WandCoord3D a) {
        this(a.x, a.y, a.z, a.id, a.meta);
    }

    public WandCoord3D copy() {
        return new WandCoord3D(this);
    }

    public int getArea(WandCoord3D b) {
        return Math.abs(this.x - b.x + 1) * Math.abs(this.y - b.y + 1) * Math.abs(this.z - b.z + 1);
    }

    public double getDistance(WandCoord3D b) {
        double d3 = this.x - b.x;
        double d4 = this.y - b.y;
        double d5 = this.z - b.z;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public double getDistanceFlat(WandCoord3D b) {
        double d3 = this.x - b.x;
        double d5 = this.z - b.z;
        return MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5));
    }

    public int getFlatArea(WandCoord3D b) {
        return Math.abs(this.x - b.x + 1) * Math.abs(this.z - b.z + 1);
    }

    public void set(int i, int j, int k) {
        this.x = i;
        this.y = j;
        this.z = k;
    }

    public void setTo(WandCoord3D a) {
        this.set(a.x, a.y, a.z);
    }

    public void writeToNBT(NBTTagCompound compound, String key) {
        if (!compound.func_74764_b("Coord3d")) {
            compound.func_74782_a("Coord3d", (NBTBase)new NBTTagCompound());
        }
        compound.func_74775_l("Coord3d").func_74783_a(key, new int[]{this.x, this.y, this.z, Block.func_149682_b((Block)this.id), this.meta});
    }

    public static void findEnds(WandCoord3D a, WandCoord3D b) {
        WandCoord3D n = new WandCoord3D();
        WandCoord3D m = new WandCoord3D();
        n.x = a.x > b.x ? b.x : a.x;
        n.y = a.y > b.y ? b.y : a.y;
        n.z = a.z > b.z ? b.z : a.z;
        m.x = a.x < b.x ? b.x : a.x;
        m.y = a.y < b.y ? b.y : a.y;
        m.z = a.z < b.z ? b.z : a.z;
        a.setTo(n);
        b.setTo(m);
    }

    public static int getArea(WandCoord3D a, WandCoord3D b) {
        return Math.abs(a.x - b.x + 1) * Math.abs(a.y - b.y + 1) * Math.abs(a.z - b.z + 1);
    }

    public static int getFlatArea(WandCoord3D a, WandCoord3D b) {
        return Math.abs(a.x - b.x + 1) * Math.abs(a.z - b.z + 1);
    }

    public static WandCoord3D getFromNBT(NBTTagCompound compound, String key) {
        int[] coord;
        NBTTagCompound nbt;
        if (compound.func_74764_b("Coord3d") && (nbt = compound.func_74775_l("Coord3d")).func_74764_b(key) && (coord = nbt.func_74759_k(key)).length == 5) {
            return new WandCoord3D(coord[0], coord[1], coord[2], coord[3], coord[4]);
        }
        return null;
    }
}

