/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.slimemodssp;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Log {
    private static final Logger logger = Logger.getLogger("com.chunkbase.mod");
    private static final String PREFIX = "[Slime Mod] ";
    private static final String FILENAME = "output-cb-slimemod-forge.log";
    private static boolean loggingToFile;

    public static void error(String s) {
        logger.log(Level.SEVERE, PREFIX + s);
    }

    public static void warn(String s) {
        logger.log(Level.WARNING, PREFIX + s);
    }

    public static void info(String s) {
        logger.log(Level.INFO, PREFIX + s);
    }

    public static void warn(Exception e) {
        Log.warn(e.getMessage());
    }

    public static void enableFileLogging() {
        if (loggingToFile) {
            return;
        }
        logger.setLevel(Level.ALL);
        try {
            FileHandler handler = new FileHandler(FILENAME, true);
            handler.setFormatter(new SimpleFormatter());
            Log.info("Logging to file output-cb-slimemod-forge.log");
            logger.addHandler(handler);
            loggingToFile = true;
        }
        catch (IOException e) {
            Log.warn("Failed to enable file logging");
        }
    }

    static {
        logger.setLevel(Level.WARNING);
        loggingToFile = false;
    }
}

