/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.slimemodssp;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class SlimeSpawning {
    private static final float[] slimeLunar = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};

    public static boolean isInSlimeChunk(World world, EntityPlayer player) {
        return SlimeSpawning.isInSlimeChunk(world.func_72905_C(), player);
    }

    public static boolean isInSlimeChunk(long seed, EntityPlayer player) {
        return SlimeSpawning.isSlimeChunk(seed, MathHelper.func_76128_c((double)(player.field_70165_t / 16.0)), MathHelper.func_76128_c((double)(player.field_70161_v / 16.0)));
    }

    public static boolean isSlimeChunk(World world, int chunkX, int chunkZ) {
        return SlimeSpawning.isSlimeChunk(world.func_72905_C(), chunkX, chunkZ);
    }

    private static boolean isSlimeChunk(long seed, int chunkX, int chunkZ) {
        Random r = new Random(seed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ 0x3AD8025FL);
        return r.nextInt(10) == 0;
    }

    public static boolean chunkHeightCheck(EntityPlayer player) {
        int playerY = (int)player.field_70121_D.field_72338_b;
        return playerY < 40;
    }

    public static boolean isInSwamp(World world, EntityPlayer player) {
        BiomeGenBase biome = world.func_72807_a(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70161_v));
        return biome == BiomeGenBase.field_76780_h;
    }

    public static boolean swampHeightCheck(EntityPlayer player) {
        int playerY = (int)player.field_70121_D.field_72338_b;
        return playerY < 70 && playerY > 50;
    }

    public static float getSwampSpawnRate(World world) {
        return slimeLunar[world.field_73011_w.func_76559_b(world.func_72820_D())];
    }

    public static float getNextSwampSpawnRate(World world) {
        return slimeLunar[(world.field_73011_w.func_76559_b(world.func_72820_D()) + 1) % 8];
    }
}

